#ifndef _DATETIME_H_INCLUDED_
#define _DATETIME_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Datetime.h
// ----------
// Implementation of a datetime data type
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: Datetime
// 
// Description: Date and time handling class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <time.h>
#include "Chain.h"
#include "ListT.h"

class Datetime {

public:
  
  Datetime();
  Datetime(const Chain& v);
  Datetime(const Chain& v, const Chain& format);
  Datetime(const Chain& v, const ListT<Chain>& formatList);
  Datetime(long long l);
  Datetime(int year, int month, int day, int hour, int minute, int second);
  
  ~Datetime();

  Chain asChain() const;
  Chain asChain(const Chain& format) const;
  long long asLong() const;

  void add(long long seconds);
  void sub(long long seconds);

  // member operators

  Datetime& operator = ( const Datetime& d);
  bool operator == ( const Datetime& str) const;
  bool operator != ( const Datetime& str) const;
  bool operator < ( const Datetime& str) const;
  bool operator > ( const Datetime& str) const;
  bool operator <= ( const Datetime& str) const;
  bool operator >= ( const Datetime& str) const;

  // friend operators
  friend ostream& operator << (ostream& s, const  Datetime& str);
  
private:

  time_t _t;

};
#endif



