#ifndef _BITMAP_H_INCLUDED_
#define _BITMAP_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Bitmap.h
// --------
// Bitmap class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: Bitmap
// 
// Description: This class provides bitmap management for boolean data
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES

#include "Chain.h"

class Bitmap {

public:
    
    Bitmap(unsigned size);
    ~Bitmap();
    
    void setValue(unsigned pos, bool val);
    bool getValue(unsigned pos) const;
   
    Chain toChain() const;

    Bitmap& operator = ( const Bitmap& bm);
    bool operator == ( const Bitmap& bm) const;
  
private:

    char *_pBM;
    unsigned _size;
};
#endif



