#ifndef _MATCHER_H_INCLUDED_
#define _MATCHER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Matcher.h
// --------
// Matcher class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: Matcher 
// 
// Description: Regular expression utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////


// INCLUDES
#include <iostream>
#include <sys/types.h>

class Matcher {

public:
    
    Matcher(const Chain& exp = Chain());
    ~Matcher();

    void setExpr(const Chain& expr);
    const Chain& getExpr() const;
    
    void prepare(bool isExtended = true);

    bool match(const Chain& str);
    
private:
    
    Chain _expr;
    void *_pRE;
    bool _isPrepared;
};
#endif
