/////////////////////////////////////////////////////////////////////////////// 
// 
// ScreenTest.cc 
// ------------- 
// Screen class test module 
// 
// Design and Implementation by Bjoern Lemke 
// 
// (C)opyright 2017-2022 by Bjoern Lemke 
// 
// 
/////////////////////////////////////////////////////////////////////////////// 

#include "../src/Exception.h" 
#include "../src/Screen.h" 

#include <locale.h> 

int main(int argc, char **argv) 
{ 

    try 
    { 

        Screen sc(Chain(":")); 

	sc.regMenu(Chain("Info"), 1);
	sc.regMenu(Chain("Confirmation"), 2); 
        sc.regMenu(Chain("Form"), 3); 
        sc.regMenu(Chain("Selection"), 4); 
        sc.regMenu(Chain("Table"), 5);
	sc.regMenu(Chain("Attriute"), 6); 
        sc.regMenu(Chain("quit"), 7);

	sc.regShortCut('a', 99);
	sc.regShortCut('b', 100);
	sc.regShortCut('c', 101);
						
        int midx = 0; 
        while ( midx != 7 ) 
        { 
           midx = sc.showHeader(); 

	   if ( midx == 1 )
	   {
	       
	       sc.showInfoBox("Info Sample", "This is the information sample\nto show the curses based information box.\nThis is a long line for an information sample to\n show the curses based information box" , 40);
	   }
           else if ( midx == 2 )
	   {
	       int r = sc.showConfirmBox("Confirmation Sample", "here comes details text");
	   }
           else if ( midx == 3 ) 
           { 
	       ListT<Chain> attrList; 
	       ListT<Chain> valList; 
	       attrList.Insert("Str:S:80:Hello"); 
	       attrList.Insert("Number:N:8:4711");
	       attrList.Insert("Password:P:5");
	       attrList.Insert("Menu Input:M:10:Beta=B,Alpha=A,Beta=B,Gamma=G");

	       sc.showFormBox("Form Sample", attrList, valList, 30);

	       Chain formResult;
	       Chain *pVal = valList.First();
	       while ( pVal )
	       {
		   formResult += Chain(" val = ") + *pVal + Chain("\n");
		   pVal = valList.Next();
	       }
	       sc.showInfoBox("Form result", formResult, 30);
           } 
           else if ( midx == 4 ) 
           {
	       ListT<Chain> selectList;
	       selectList.Insert("Alpha=1");
	       selectList.Insert("Beta=2");
	       selectList.Insert("Gamma=3");

	       Chain selectKey;
	       Chain selectValue;
	       int r = sc.showSelectBox("Selection Sample", selectList, selectKey, selectValue);

	       sc.showInfoBox(Chain("Select result "),  Chain(r)  + Chain(" value selected"), 60);
           }
           else if ( midx == 5 ) 
           {	      
	       int i=0;
	       int ret = SC_TIMEOUT;
	       int selectedRow=1;
	       int visibleRow=1;
	       
	       while ( ret != SC_LEAVE )
	       {
		   ListT<Chain> schema;
		   ListT<ListT<Chain> > table;
		   
		   schema.Insert("Alpha=10");
		   schema.Insert("Beta=20");
		   schema.Insert("Gamma=5");

		   /*
		   for ( int row=1; row<= 50; row++ )
		   {
		       ListT<Chain> row1;
		       row1.Insert("XXX");
		       row1.Insert("YYYY");
		       row1.Insert(Chain(row));
		       table.Insert(row1);
		   }
		   */
		   
		   ListT<Screen::TableColor> colorMap;		   
		   colorMap.Insert(Screen::TableColor(Chain("Alpha"), SC_RED));
	   
		   ret = sc.showTableBox("The title", schema, table, colorMap, 0, true, selectedRow, visibleRow,  0);

		   selectedRow = sc.getSelectedRow();
		   visibleRow = sc.getVisibleRow();

		   sc.setStatusLine(Chain("Selected = ") + Chain(selectedRow) + Chain(" Visible = ") + Chain(visibleRow));

		   if ( ret != SC_LEAVE && ret != SC_TIMEOUT )
		   {
		       sc.showInfoBox("Selected Row", Chain(sc.getSelectedRow()), 30);	   
		   }

	       }

	       sc.setStatusLine(Chain("                        "));
           }
	   else if ( midx == 6 ) 
           {
	       int ret = 1;
	       int i=0;
	       while ( ret != SC_LEAVE )
	       {

		   ListT< ListT<Chain> > attrSpec;
		   
		   for ( int row = 1; row < 3; row++ )
		   {
		       ListT<Chain> keyValueA;
		       keyValueA.Insert("Alpha=10");
		       keyValueA.Insert("Beta=20");
		       keyValueA.Insert("Gamma=" + Chain(i));

		       attrSpec.Insert(keyValueA);
		   }

		   ret = sc.showAttributeBox(10, 20, attrSpec, false, 3000);
		   i++;
	       }
	       // m.showInfoBox("Select result", Chain(r) + Chain(" value selected"));
           }

        }
    } 
    catch (Exception e) 
    { 
        Chain msg; 
        e.pop(msg); 
        cout << msg << endl; 
        return 1; 
    } 

    return 0; 

} 
