// ThreadTest.cc
// -------------
// thread class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include <unistd.h>
#include <stdlib.h>

#include "../src/Exception.h"
#include "../src/Thread.h"
#include "../src/ThreadLock.h"
#include "../src/Chain.h"
#include "../src/SigHandler.h"

static ThreadLock _lock;
static int flipflop = 0;

class MyThread : public Thread
{
    
public:
    
    MyThread() : Thread()  {	
    }

    ~MyThread() {
    }

    
    void* job(void* arg) {
	
	try {
	    
	    int n = *(int*)arg;      

	    int i= (n+1) * 1000000;
	    while (i>0)
	    {
		_lock.writeLock(100000);

		if ( flipflop == 0 )
		    flipflop++;
		else
		    flipflop--;

		// if ( flipflop > 1 )
		//     cout << "FLIPFLOP FAILS" << endl;
		// cout << "Thread " << getTid() << " : Setting flipflop to " << flipflop << endl;
		// sleep(1);
	  
		_lock.unlock();
		i--;
		

	    }
	}
	catch (Exception e)
	{
	    e.print();
	    cout << "thread failed" << endl;
	}
	
	return NULL;
    } 
    
private:
        
    
};

int main(int argc, char **argv)
{

    int numCheck = 2;
    int checkCount = 1;
    
    try {


	flipflop = 0;

	cout << "Size of pthread_t is " << sizeof(pthread_t) << endl;

	cout << "1.." << numCheck << endl;
       
	if ( 1 )
	{
	    
	    MyThread myThread;
	    
	}

	cout << "ok " << checkCount << " - constructor" << endl;
	checkCount++;
	

	_lock.init();
	
	MyThread myThread[100];
	
	long i, num[100], id[100];
	
	_lock.writeLock(100000);

	for (i=0; i<10; i++) 
	{
	    
	    // myThread.P(); // locking for argument synchronisation
	    
	    num[i]=i;
	    id[i] = myThread[i].start(&num[i]);
	    
	    // cout << "Thread " << id[i] << " started" << endl;       
	    // sleep(1);
	    
	}
	_lock.unlock();
	
	// sleep(1);

	// myThread.V();
	for (i=0; i<10; i++) 
	    myThread[i].join(id[i]);

        
	if ( flipflop == 0 ) 
	    cout << "ok " << checkCount << " - counter matches" << endl;
	else
	  cout << "not ok " << checkCount << " - flipflop does not match ( " << flipflop << " instead of 150 )" << endl;
	
	checkCount++;
		
	
    }

    catch (Exception e)
    {

	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;
}

  
