@REM $Id: imapsync_example_oauth2.bat,v 1.8 2025/09/23 23:50:38 gilles Exp gilles $

@REM Here is an imapsync example batch for Windows users.
@REM Lines beginning with @REM are just comments.
@REM Please read the comments, they are written for you, human folk.


@ECHO Getting/Updating the OAUTH2 tokens


CD .\oauth2_imap
@ECHO 
@IF NOT EXIST tokens MKDIR tokens
@ATTRIB  -r tokens


@REM You have to replace the email addresses gilles.lamiral@outlook.com 
@REM and gilles.lamiral@gmail.com by yours and also adapt the option 
@REM --provider office365 --provider gmail with those accounts.
@REM 

CALL .\oauth2_imap.exe --provider office365   gilles.lamiral@outlook.com 
CALL .\oauth2_imap.exe --provider gmail       gilles.lamiral@gmail.com 

CD ..
@ECHO Now calling imapsync with those fresh access tokens


@REM In this example,
@REM the source account uses an OAUTH2 access token ( --host1 --user1 --oauthaccesstoken1 )
@REM the destination account uses a password ( --host2 --user2 --password2 )
@REM change the values with yours.

@REM You also have to change the token files names here and replace them by the ones
@REM generated by the calls to oauth2_imap.exe
@REM 

CALL .\imapsync.exe  ^
  --host1 outlook.office365.com --user1 gilles.lamiral@outlook.com --oauthaccesstoken1  oauth2_imap\tokens\oauth2_tokens_gilles.lamiral@outlook.com.txt  ^
  --host2 imap.gmail.com        --user2 gilles.lamiral@gmail.com   --oauthaccesstoken2  oauth2_imap\tokens\oauth2_tokens_gilles.lamiral@gmail.com.txt  ^
  --dry --automap --justfolders


@ECHO The sync is over.
@ECHO Hit any key to close this window
@ECHO the following word "to continue" means in fact "to close this window" 
@PAUSE



@REM Developer side

@REM CALL .\oauth2_imap\oauth2_imap.exe  gilles.lamiral@outlook.com  


@REM CALL .\imapsync.exe  ^
@REM   --host1 outlook.office365.com  --user1 gilles.lamiral@outlook.com --oauthaccesstoken1 oauth2_imap\tokens\oauth2_tokens_gilles.lamiral@outlook.com.txt ^
@REM   --host2 outlook.office365.com  --user2 gilles.lamiral@outlook.com --oauthaccesstoken2 oauth2_imap\tokens\oauth2_tokens_gilles.lamiral@outlook.com.txt ^
@REM   --dry

