// Code generated by Wire. DO NOT EDIT.

//go:generate go run ./pkg/build/wire/cmd/wire/main.go gen -tags "oss"
//go:build !wireinject && !enterprise && !pro

package server

import (
	"context"
	"github.com/google/wire"
	httpclient2 "github.com/grafana/grafana-plugin-sdk-go/backend/httpclient"
	"github.com/grafana/grafana/apps/advisor/pkg/app/checkregistry"
	"github.com/grafana/grafana/apps/provisioning/pkg/repository"
	"github.com/grafana/grafana/apps/provisioning/pkg/repository/github"
	"github.com/grafana/grafana/pkg/api"
	"github.com/grafana/grafana/pkg/api/avatar"
	"github.com/grafana/grafana/pkg/api/routing"
	"github.com/grafana/grafana/pkg/bus"
	"github.com/grafana/grafana/pkg/configprovider"
	"github.com/grafana/grafana/pkg/expr"
	"github.com/grafana/grafana/pkg/infra/db"
	"github.com/grafana/grafana/pkg/infra/httpclient"
	"github.com/grafana/grafana/pkg/infra/httpclient/httpclientprovider"
	"github.com/grafana/grafana/pkg/infra/kvstore"
	"github.com/grafana/grafana/pkg/infra/localcache"
	"github.com/grafana/grafana/pkg/infra/log/slogadapter"
	"github.com/grafana/grafana/pkg/infra/metrics"
	"github.com/grafana/grafana/pkg/infra/remotecache"
	"github.com/grafana/grafana/pkg/infra/serverlock"
	"github.com/grafana/grafana/pkg/infra/tracing"
	"github.com/grafana/grafana/pkg/infra/usagestats"
	"github.com/grafana/grafana/pkg/infra/usagestats/service"
	"github.com/grafana/grafana/pkg/infra/usagestats/statscollector"
	validator3 "github.com/grafana/grafana/pkg/infra/usagestats/validator"
	"github.com/grafana/grafana/pkg/login/social"
	"github.com/grafana/grafana/pkg/login/social/connectors"
	"github.com/grafana/grafana/pkg/login/social/socialimpl"
	"github.com/grafana/grafana/pkg/middleware/csrf"
	"github.com/grafana/grafana/pkg/middleware/loggermw"
	"github.com/grafana/grafana/pkg/plugins/backendplugin/coreplugin"
	provider2 "github.com/grafana/grafana/pkg/plugins/backendplugin/provider"
	manager4 "github.com/grafana/grafana/pkg/plugins/manager"
	"github.com/grafana/grafana/pkg/plugins/manager/filestore"
	"github.com/grafana/grafana/pkg/plugins/manager/loader/assetpath"
	"github.com/grafana/grafana/pkg/plugins/manager/process"
	"github.com/grafana/grafana/pkg/plugins/manager/registry"
	"github.com/grafana/grafana/pkg/plugins/manager/signature"
	"github.com/grafana/grafana/pkg/plugins/manager/sources"
	"github.com/grafana/grafana/pkg/plugins/pluginassets"
	"github.com/grafana/grafana/pkg/plugins/pluginscdn"
	"github.com/grafana/grafana/pkg/plugins/repo"
	"github.com/grafana/grafana/pkg/registry/apis"
	"github.com/grafana/grafana/pkg/registry/apis/dashboard"
	"github.com/grafana/grafana/pkg/registry/apis/dashboard/legacy"
	"github.com/grafana/grafana/pkg/registry/apis/dashboardsnapshot"
	"github.com/grafana/grafana/pkg/registry/apis/datasource"
	"github.com/grafana/grafana/pkg/registry/apis/featuretoggle"
	"github.com/grafana/grafana/pkg/registry/apis/folders"
	"github.com/grafana/grafana/pkg/registry/apis/iam"
	"github.com/grafana/grafana/pkg/registry/apis/iam/noopstorage"
	"github.com/grafana/grafana/pkg/registry/apis/ofrep"
	"github.com/grafana/grafana/pkg/registry/apis/preferences"
	provisioning2 "github.com/grafana/grafana/pkg/registry/apis/provisioning"
	"github.com/grafana/grafana/pkg/registry/apis/provisioning/extras"
	"github.com/grafana/grafana/pkg/registry/apis/provisioning/webhooks"
	query2 "github.com/grafana/grafana/pkg/registry/apis/query"
	"github.com/grafana/grafana/pkg/registry/apis/secret"
	"github.com/grafana/grafana/pkg/registry/apis/secret/clock"
	"github.com/grafana/grafana/pkg/registry/apis/secret/contracts"
	"github.com/grafana/grafana/pkg/registry/apis/secret/decrypt"
	service4 "github.com/grafana/grafana/pkg/registry/apis/secret/encryption/cipher/service"
	"github.com/grafana/grafana/pkg/registry/apis/secret/encryption/kmsproviders"
	manager2 "github.com/grafana/grafana/pkg/registry/apis/secret/encryption/manager"
	"github.com/grafana/grafana/pkg/registry/apis/secret/garbagecollectionworker"
	"github.com/grafana/grafana/pkg/registry/apis/secret/inline"
	"github.com/grafana/grafana/pkg/registry/apis/secret/mutator"
	"github.com/grafana/grafana/pkg/registry/apis/secret/secretkeeper"
	service5 "github.com/grafana/grafana/pkg/registry/apis/secret/service"
	"github.com/grafana/grafana/pkg/registry/apis/secret/validator"
	"github.com/grafana/grafana/pkg/registry/apis/userstorage"
	"github.com/grafana/grafana/pkg/registry/apps"
	advisor2 "github.com/grafana/grafana/pkg/registry/apps/advisor"
	notifications2 "github.com/grafana/grafana/pkg/registry/apps/alerting/notifications"
	"github.com/grafana/grafana/pkg/registry/apps/investigations"
	"github.com/grafana/grafana/pkg/registry/apps/playlist"
	"github.com/grafana/grafana/pkg/registry/apps/plugins"
	"github.com/grafana/grafana/pkg/registry/apps/shorturl"
	"github.com/grafana/grafana/pkg/registry/backgroundsvcs"
	"github.com/grafana/grafana/pkg/registry/usagestatssvcs"
	"github.com/grafana/grafana/pkg/services/accesscontrol"
	"github.com/grafana/grafana/pkg/services/accesscontrol/acimpl"
	dualwrite2 "github.com/grafana/grafana/pkg/services/accesscontrol/dualwrite"
	"github.com/grafana/grafana/pkg/services/accesscontrol/ossaccesscontrol"
	"github.com/grafana/grafana/pkg/services/accesscontrol/permreg"
	"github.com/grafana/grafana/pkg/services/accesscontrol/resourcepermissions"
	"github.com/grafana/grafana/pkg/services/annotations"
	"github.com/grafana/grafana/pkg/services/annotations/annotationsimpl"
	"github.com/grafana/grafana/pkg/services/anonymous/anonimpl"
	"github.com/grafana/grafana/pkg/services/anonymous/anonimpl/anonstore"
	validator2 "github.com/grafana/grafana/pkg/services/anonymous/validator"
	"github.com/grafana/grafana/pkg/services/apikey/apikeyimpl"
	"github.com/grafana/grafana/pkg/services/apiserver"
	"github.com/grafana/grafana/pkg/services/apiserver/aggregatorrunner"
	"github.com/grafana/grafana/pkg/services/apiserver/builder"
	"github.com/grafana/grafana/pkg/services/apiserver/standalone"
	"github.com/grafana/grafana/pkg/services/auth"
	"github.com/grafana/grafana/pkg/services/auth/authimpl"
	"github.com/grafana/grafana/pkg/services/auth/idimpl"
	"github.com/grafana/grafana/pkg/services/auth/jwt"
	"github.com/grafana/grafana/pkg/services/authn/authnimpl"
	"github.com/grafana/grafana/pkg/services/authz"
	"github.com/grafana/grafana/pkg/services/caching"
	"github.com/grafana/grafana/pkg/services/cleanup"
	"github.com/grafana/grafana/pkg/services/cloudmigration/cloudmigrationimpl"
	"github.com/grafana/grafana/pkg/services/contexthandler"
	"github.com/grafana/grafana/pkg/services/correlations"
	"github.com/grafana/grafana/pkg/services/dashboardimport"
	service11 "github.com/grafana/grafana/pkg/services/dashboardimport/service"
	dashboards2 "github.com/grafana/grafana/pkg/services/dashboards"
	database2 "github.com/grafana/grafana/pkg/services/dashboards/database"
	service7 "github.com/grafana/grafana/pkg/services/dashboards/service"
	"github.com/grafana/grafana/pkg/services/dashboards/service/client"
	"github.com/grafana/grafana/pkg/services/dashboardsnapshots"
	database5 "github.com/grafana/grafana/pkg/services/dashboardsnapshots/database"
	service10 "github.com/grafana/grafana/pkg/services/dashboardsnapshots/service"
	"github.com/grafana/grafana/pkg/services/dashboardversion/dashverimpl"
	"github.com/grafana/grafana/pkg/services/datasourceproxy"
	"github.com/grafana/grafana/pkg/services/datasources"
	"github.com/grafana/grafana/pkg/services/datasources/guardian"
	service9 "github.com/grafana/grafana/pkg/services/datasources/service"
	"github.com/grafana/grafana/pkg/services/dsquerierclient"
	encryption2 "github.com/grafana/grafana/pkg/services/encryption"
	"github.com/grafana/grafana/pkg/services/encryption/provider"
	service2 "github.com/grafana/grafana/pkg/services/encryption/service"
	"github.com/grafana/grafana/pkg/services/extsvcauth"
	registry2 "github.com/grafana/grafana/pkg/services/extsvcauth/registry"
	"github.com/grafana/grafana/pkg/services/featuremgmt"
	"github.com/grafana/grafana/pkg/services/folder"
	"github.com/grafana/grafana/pkg/services/folder/folderimpl"
	"github.com/grafana/grafana/pkg/services/grpcserver"
	"github.com/grafana/grafana/pkg/services/grpcserver/context"
	"github.com/grafana/grafana/pkg/services/grpcserver/interceptors"
	"github.com/grafana/grafana/pkg/services/hooks"
	"github.com/grafana/grafana/pkg/services/kmsproviders/osskmsproviders"
	"github.com/grafana/grafana/pkg/services/ldap"
	api4 "github.com/grafana/grafana/pkg/services/ldap/api"
	service12 "github.com/grafana/grafana/pkg/services/ldap/service"
	"github.com/grafana/grafana/pkg/services/libraryelements"
	"github.com/grafana/grafana/pkg/services/librarypanels"
	"github.com/grafana/grafana/pkg/services/licensing"
	"github.com/grafana/grafana/pkg/services/live"
	"github.com/grafana/grafana/pkg/services/live/pushhttp"
	"github.com/grafana/grafana/pkg/services/login"
	"github.com/grafana/grafana/pkg/services/login/authinfoimpl"
	"github.com/grafana/grafana/pkg/services/loginattempt"
	"github.com/grafana/grafana/pkg/services/loginattempt/loginattemptimpl"
	"github.com/grafana/grafana/pkg/services/navtree/navtreeimpl"
	"github.com/grafana/grafana/pkg/services/ngalert"
	"github.com/grafana/grafana/pkg/services/ngalert/image"
	metrics2 "github.com/grafana/grafana/pkg/services/ngalert/metrics"
	store2 "github.com/grafana/grafana/pkg/services/ngalert/store"
	"github.com/grafana/grafana/pkg/services/notifications"
	"github.com/grafana/grafana/pkg/services/oauthtoken"
	"github.com/grafana/grafana/pkg/services/oauthtoken/oauthtokentest"
	"github.com/grafana/grafana/pkg/services/org/orgimpl"
	"github.com/grafana/grafana/pkg/services/playlist/playlistimpl"
	"github.com/grafana/grafana/pkg/services/plugindashboards"
	service8 "github.com/grafana/grafana/pkg/services/plugindashboards/service"
	"github.com/grafana/grafana/pkg/services/pluginsintegration"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/advisor"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/angulardetectorsprovider"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/angularinspector"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/angularpatternsstore"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/dashboards"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/keyretriever"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/keyretriever/dynamic"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/keystore"
	licensing2 "github.com/grafana/grafana/pkg/services/pluginsintegration/licensing"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/loader"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/managedplugins"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pipeline"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginaccesscontrol"
	pluginassets2 "github.com/grafana/grafana/pkg/services/pluginsintegration/pluginassets"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginchecker"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginconfig"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/plugincontext"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginerrs"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginexternal"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/plugininstaller"
	service6 "github.com/grafana/grafana/pkg/services/pluginsintegration/pluginsettings/service"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginstore"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/provisionedplugins"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/renderer"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/sandbox"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/serviceregistration"
	"github.com/grafana/grafana/pkg/services/preference/prefimpl"
	"github.com/grafana/grafana/pkg/services/promtypemigration"
	"github.com/grafana/grafana/pkg/services/provisioning"
	"github.com/grafana/grafana/pkg/services/publicdashboards"
	api2 "github.com/grafana/grafana/pkg/services/publicdashboards/api"
	database3 "github.com/grafana/grafana/pkg/services/publicdashboards/database"
	"github.com/grafana/grafana/pkg/services/publicdashboards/metric"
	service3 "github.com/grafana/grafana/pkg/services/publicdashboards/service"
	"github.com/grafana/grafana/pkg/services/query"
	"github.com/grafana/grafana/pkg/services/queryhistory"
	"github.com/grafana/grafana/pkg/services/quota/quotaimpl"
	"github.com/grafana/grafana/pkg/services/rendering"
	search2 "github.com/grafana/grafana/pkg/services/search"
	"github.com/grafana/grafana/pkg/services/search/sort"
	"github.com/grafana/grafana/pkg/services/searchV2"
	"github.com/grafana/grafana/pkg/services/searchusers"
	"github.com/grafana/grafana/pkg/services/searchusers/filters"
	"github.com/grafana/grafana/pkg/services/secrets"
	"github.com/grafana/grafana/pkg/services/secrets/database"
	kvstore2 "github.com/grafana/grafana/pkg/services/secrets/kvstore"
	migrations2 "github.com/grafana/grafana/pkg/services/secrets/kvstore/migrations"
	"github.com/grafana/grafana/pkg/services/secrets/manager"
	"github.com/grafana/grafana/pkg/services/secrets/migrator"
	"github.com/grafana/grafana/pkg/services/serviceaccounts"
	"github.com/grafana/grafana/pkg/services/serviceaccounts/extsvcaccounts"
	manager3 "github.com/grafana/grafana/pkg/services/serviceaccounts/manager"
	"github.com/grafana/grafana/pkg/services/serviceaccounts/proxy"
	"github.com/grafana/grafana/pkg/services/serviceaccounts/retriever"
	"github.com/grafana/grafana/pkg/services/shorturls"
	"github.com/grafana/grafana/pkg/services/shorturls/shorturlimpl"
	"github.com/grafana/grafana/pkg/services/signingkeys"
	"github.com/grafana/grafana/pkg/services/signingkeys/signingkeysimpl"
	"github.com/grafana/grafana/pkg/services/sqlstore"
	"github.com/grafana/grafana/pkg/services/sqlstore/migrations"
	"github.com/grafana/grafana/pkg/services/sqlstore/sqlutil"
	"github.com/grafana/grafana/pkg/services/ssosettings"
	"github.com/grafana/grafana/pkg/services/ssosettings/ssosettingsimpl"
	api3 "github.com/grafana/grafana/pkg/services/star/api"
	"github.com/grafana/grafana/pkg/services/star/starimpl"
	"github.com/grafana/grafana/pkg/services/stats/statsimpl"
	"github.com/grafana/grafana/pkg/services/store"
	"github.com/grafana/grafana/pkg/services/store/resolver"
	"github.com/grafana/grafana/pkg/services/supportbundles"
	"github.com/grafana/grafana/pkg/services/supportbundles/bundleregistry"
	"github.com/grafana/grafana/pkg/services/supportbundles/supportbundlesimpl"
	"github.com/grafana/grafana/pkg/services/tag"
	"github.com/grafana/grafana/pkg/services/tag/tagimpl"
	"github.com/grafana/grafana/pkg/services/team/teamapi"
	"github.com/grafana/grafana/pkg/services/team/teamimpl"
	"github.com/grafana/grafana/pkg/services/temp_user"
	"github.com/grafana/grafana/pkg/services/temp_user/tempuserimpl"
	"github.com/grafana/grafana/pkg/services/updatemanager"
	"github.com/grafana/grafana/pkg/services/user"
	"github.com/grafana/grafana/pkg/services/user/userimpl"
	"github.com/grafana/grafana/pkg/services/validations"
	"github.com/grafana/grafana/pkg/setting"
	"github.com/grafana/grafana/pkg/storage/legacysql/dualwrite"
	database4 "github.com/grafana/grafana/pkg/storage/secret/database"
	"github.com/grafana/grafana/pkg/storage/secret/encryption"
	"github.com/grafana/grafana/pkg/storage/secret/metadata"
	migrator2 "github.com/grafana/grafana/pkg/storage/secret/migrator"
	"github.com/grafana/grafana/pkg/storage/unified"
	"github.com/grafana/grafana/pkg/storage/unified/resource"
	"github.com/grafana/grafana/pkg/storage/unified/search"
	"github.com/grafana/grafana/pkg/tsdb/azuremonitor"
	"github.com/grafana/grafana/pkg/tsdb/cloud-monitoring"
	"github.com/grafana/grafana/pkg/tsdb/cloudwatch"
	"github.com/grafana/grafana/pkg/tsdb/elasticsearch"
	"github.com/grafana/grafana/pkg/tsdb/grafana-postgresql-datasource"
	"github.com/grafana/grafana/pkg/tsdb/grafana-pyroscope-datasource"
	"github.com/grafana/grafana/pkg/tsdb/grafana-testdata-datasource"
	"github.com/grafana/grafana/pkg/tsdb/grafanads"
	"github.com/grafana/grafana/pkg/tsdb/graphite"
	"github.com/grafana/grafana/pkg/tsdb/influxdb"
	"github.com/grafana/grafana/pkg/tsdb/jaeger"
	"github.com/grafana/grafana/pkg/tsdb/loki"
	"github.com/grafana/grafana/pkg/tsdb/mssql"
	"github.com/grafana/grafana/pkg/tsdb/mysql"
	"github.com/grafana/grafana/pkg/tsdb/opentsdb"
	"github.com/grafana/grafana/pkg/tsdb/parca"
	"github.com/grafana/grafana/pkg/tsdb/prometheus"
	"github.com/grafana/grafana/pkg/tsdb/tempo"
	"github.com/grafana/grafana/pkg/tsdb/zipkin"
	"github.com/stretchr/testify/mock"
	"go.opentelemetry.io/otel"
	"go.opentelemetry.io/otel/trace"
)

import (
	_ "github.com/grafana/grafana/pkg/extensions"
)

// Injectors from wire.go:

func Initialize(ctx context.Context, cfg *setting.Cfg, opts Options, apiOpts api.ServerOptions) (*Server, error) {
	routeRegisterImpl := routing.ProvideRegister()
	tracingConfig, err := tracing.ProvideTracingConfig(cfg)
	if err != nil {
		return nil, err
	}
	tracingService, err := tracing.ProvideService(tracingConfig)
	if err != nil {
		return nil, err
	}
	inProcBus := bus.ProvideBus(tracingService)
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	ossMigrations := migrations.ProvideOSSMigrations(featureToggles)
	sqlStore, err := sqlstore.ProvideService(cfg, featureToggles, ossMigrations, inProcBus, tracingService)
	if err != nil {
		return nil, err
	}
	kvStore := kvstore.ProvideService(sqlStore)
	accessControl := acimpl.ProvideAccessControl(featureToggles)
	bundleregistryService := bundleregistry.ProvideService()
	usageStats, err := service.ProvideService(cfg, kvStore, routeRegisterImpl, tracingService, accessControl, bundleregistryService)
	if err != nil {
		return nil, err
	}
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	providerProvider := provider.ProvideEncryptionProvider()
	serviceService, err := service2.ProvideEncryptionService(tracingService, providerProvider, usageStats, cfg)
	if err != nil {
		return nil, err
	}
	osskmsprovidersService := osskmsproviders.ProvideService(serviceService, cfg, featureToggles)
	secretsService, err := manager.ProvideSecretsService(tracingService, secretsStoreImpl, osskmsprovidersService, serviceService, cfg, featureToggles, usageStats)
	if err != nil {
		return nil, err
	}
	remoteCache, err := remotecache.ProvideService(cfg, sqlStore, usageStats, secretsService)
	if err != nil {
		return nil, err
	}
	ossImpl := setting.ProvideProvider(cfg)
	pluginManagementCfg, err := pluginconfig.ProvidePluginManagementConfig(cfg, ossImpl, featureToggles)
	if err != nil {
		return nil, err
	}
	pluginInstanceCfg, err := pluginconfig.ProvidePluginInstanceConfig(cfg, ossImpl, featureToggles)
	if err != nil {
		return nil, err
	}
	hooksService := hooks.ProvideService()
	ossLicensingService := licensing.ProvideService(cfg, hooksService)
	licensingService := licensing2.ProvideLicensing(cfg, ossLicensingService)
	envVarsProvider := pluginconfig.NewEnvVarsProvider(pluginInstanceCfg, licensingService)
	inMemory := registry.ProvideService()
	rendererManager, err := renderer.ProvideService(pluginManagementCfg, envVarsProvider, inMemory, tracingService)
	if err != nil {
		return nil, err
	}
	renderingService, err := rendering.ProvideService(cfg, featureToggles, remoteCache, rendererManager)
	if err != nil {
		return nil, err
	}
	cacheService := localcache.ProvideService()
	ossDataSourceRequestValidator := validations.ProvideValidator()
	sourcesService := sources.ProvideService(cfg, pluginManagementCfg)
	discovery := pipeline.ProvideDiscoveryStage(pluginManagementCfg, inMemory)
	keystoreService := keystore.ProvideService(kvStore)
	keyRetriever := dynamic.ProvideService(cfg, keystoreService)
	keyretrieverService := keyretriever.ProvideService(keyRetriever)
	signatureSignature := signature.ProvideService(pluginManagementCfg, keyretrieverService)
	pluginscdnService := pluginscdn.ProvideService(pluginManagementCfg)
	localProvider := pluginassets.ProvideService()
	assetpathService := assetpath.ProvideService(pluginManagementCfg, pluginscdnService, localProvider)
	bootstrap := pipeline.ProvideBootstrapStage(pluginManagementCfg, signatureSignature, assetpathService)
	unsignedPluginAuthorizer := signature.ProvideOSSAuthorizer(pluginManagementCfg)
	validation := signature.ProvideValidatorService(unsignedPluginAuthorizer)
	angularpatternsstoreService := angularpatternsstore.ProvideService(kvStore)
	angulardetectorsproviderDynamic, err := angulardetectorsprovider.ProvideDynamic(cfg, angularpatternsstoreService)
	if err != nil {
		return nil, err
	}
	angularinspectorService, err := angularinspector.ProvideService(angulardetectorsproviderDynamic)
	if err != nil {
		return nil, err
	}
	validate := pipeline.ProvideValidationStage(pluginManagementCfg, validation, angularinspectorService)
	ossDataSourceRequestURLValidator := validations.ProvideURLValidator()
	httpclientProvider := httpclientprovider.New(cfg, ossDataSourceRequestURLValidator, tracingService)
	azuremonitorService := azuremonitor.ProvideService(httpclientProvider)
	cloudwatchService := cloudwatch.ProvideService()
	cloudmonitoringService := cloudmonitoring.ProvideService(httpclientProvider)
	elasticsearchService := elasticsearch.ProvideService(httpclientProvider)
	graphiteService := graphite.ProvideService(httpclientProvider, tracingService)
	influxdbService := influxdb.ProvideService(httpclientProvider, featureToggles)
	tracer := otelTracer()
	lokiService := loki.ProvideService(httpclientProvider, tracer)
	opentsdbService := opentsdb.ProvideService(httpclientProvider)
	prometheusService := prometheus.ProvideService(httpclientProvider)
	tempoService := tempo.ProvideService(httpclientProvider)
	testdatasourceService := testdatasource.ProvideService()
	postgresService := postgres.ProvideService(cfg, featureToggles)
	mysqlService := mysql.ProvideService()
	mssqlService := mssql.ProvideService(cfg)
	entityEventsService := store.ProvideEntityEventsService(cfg, sqlStore, featureToggles)
	configProvider, err := configprovider.ProvideService(cfg)
	if err != nil {
		return nil, err
	}
	quotaService := quotaimpl.ProvideService(ctx, sqlStore, configProvider)
	orgService, err := orgimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return nil, err
	}
	teamService, err := teamimpl.ProvideService(sqlStore, cfg, tracingService)
	if err != nil {
		return nil, err
	}
	userService, err := userimpl.ProvideService(sqlStore, orgService, cfg, teamService, cacheService, tracingService, quotaService, bundleregistryService)
	if err != nil {
		return nil, err
	}
	actionSetService := resourcepermissions.NewActionSetService()
	permissionRegistry := permreg.ProvidePermissionRegistry()
	serverLockService := serverlock.ProvideService(sqlStore, tracingService)
	acimplService, err := acimpl.ProvideService(cfg, sqlStore, routeRegisterImpl, cacheService, accessControl, userService, actionSetService, featureToggles, tracingService, permissionRegistry, serverLockService)
	if err != nil {
		return nil, err
	}
	folderStoreImpl := folderimpl.ProvideStore(sqlStore)
	tagimplService := tagimpl.ProvideService(sqlStore)
	dashboardsStore, err := database2.ProvideDashboardStore(sqlStore, cfg, featureToggles, tagimplService)
	if err != nil {
		return nil, err
	}
	publicDashboardStoreImpl := database3.ProvideStore(sqlStore, cfg, featureToggles)
	publicDashboardServiceWrapperImpl := service3.ProvideServiceWrapper(publicDashboardStoreImpl)
	registerer := metrics.ProvideRegisterer()
	apikeyService, err := apikeyimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return nil, err
	}
	contextHandler := grpccontext.ProvideContextHandler(tracingService)
	authenticator := interceptors.ProvideAuthenticator(apikeyService, userService, acimplService, contextHandler)
	grpcserverProvider, err := grpcserver.ProvideService(cfg, featureToggles, authenticator, tracer, registerer)
	if err != nil {
		return nil, err
	}
	zanzanaClient, err := authz.ProvideZanzana(cfg, sqlStore, tracingService, featureToggles, registerer)
	if err != nil {
		return nil, err
	}
	eventualRestConfigProvider := apiserver.ProvideEventualRestConfigProvider()
	accessClient, err := authz.ProvideAuthZClient(cfg, featureToggles, grpcserverProvider, tracingService, registerer, sqlStore, acimplService, zanzanaClient, eventualRestConfigProvider)
	if err != nil {
		return nil, err
	}
	ossDashboardStats := search.ProvideDashboardStats()
	documentBuilderSupplier := search.ProvideDocumentBuilders(sqlStore, ossDashboardStats)
	databaseDatabase := database4.ProvideDatabase(sqlStore, tracer)
	clockClock := clock.ProvideClock()
	secureValueMetadataStorage, err := metadata.ProvideSecureValueMetadataStorage(clockClock, databaseDatabase, tracer, registerer)
	if err != nil {
		return nil, err
	}
	secureValueValidator := validator.ProvideSecureValueValidator()
	secureValueMutator := mutator.ProvideSecureValueMutator()
	keeperMetadataStorage, err := metadata.ProvideKeeperMetadataStorage(databaseDatabase, tracer, registerer)
	if err != nil {
		return nil, err
	}
	encryptedValueStorage, err := encryption.ProvideEncryptedValueStorage(databaseDatabase, tracer)
	if err != nil {
		return nil, err
	}
	dataKeyStorage, err := encryption.ProvideDataKeyStorage(databaseDatabase, tracer, registerer)
	if err != nil {
		return nil, err
	}
	cipher, err := service4.ProvideAESGCMCipherService(tracer, usageStats)
	if err != nil {
		return nil, err
	}
	providerConfig, err := kmsproviders.ProvideOSSKMSProviders(cfg, cipher)
	if err != nil {
		return nil, err
	}
	encryptionManager, err := manager2.ProvideEncryptionManager(tracer, dataKeyStorage, usageStats, cipher, providerConfig)
	if err != nil {
		return nil, err
	}
	ossKeeperService, err := secretkeeper.ProvideService(tracer, encryptedValueStorage, encryptionManager, registerer)
	if err != nil {
		return nil, err
	}
	secureValueService := service5.ProvideSecureValueService(tracer, accessClient, databaseDatabase, secureValueMetadataStorage, secureValueValidator, secureValueMutator, keeperMetadataStorage, ossKeeperService, registerer)
	inlineSecureValueSupport, err := inline.ProvideInlineSecureValueService(cfg, tracer, secureValueService, accessClient)
	if err != nil {
		return nil, err
	}
	options := &unified.Options{
		Cfg:          cfg,
		Features:     featureToggles,
		DB:           sqlStore,
		Tracer:       tracingService,
		Reg:          registerer,
		Authzc:       accessClient,
		Docs:         documentBuilderSupplier,
		SecureValues: inlineSecureValueSupport,
	}
	storageMetrics := resource.ProvideStorageMetrics(registerer)
	bleveIndexMetrics := resource.ProvideIndexMetrics(registerer)
	resourceClient, err := unified.ProvideUnifiedStorageClient(options, storageMetrics, bleveIndexMetrics)
	if err != nil {
		return nil, err
	}
	dualwriteService := dualwrite.ProvideService(featureToggles, registerer, kvStore, cfg)
	sortService := sort.ProvideService()
	folderimplService := folderimpl.ProvideService(folderStoreImpl, accessControl, inProcBus, dashboardsStore, userService, sqlStore, featureToggles, bundleregistryService, publicDashboardServiceWrapperImpl, cfg, registerer, tracer, resourceClient, dualwriteService, sortService, eventualRestConfigProvider)
	searchService := searchV2.ProvideService(cfg, sqlStore, entityEventsService, acimplService, tracingService, featureToggles, orgService, userService, folderimplService)
	systemUsers := store.ProvideSystemUsersService()
	storageService, err := store.ProvideService(sqlStore, featureToggles, cfg, quotaService, systemUsers)
	if err != nil {
		return nil, err
	}
	grafanadsService := grafanads.ProvideService(searchService, storageService, featureToggles)
	pyroscopeService := pyroscope.ProvideService(httpclientProvider)
	parcaService := parca.ProvideService(httpclientProvider)
	zipkinService := zipkin.ProvideService(httpclientProvider)
	jaegerService := jaeger.ProvideService(httpclientProvider)
	corepluginRegistry := coreplugin.ProvideCoreRegistry(tracingService, azuremonitorService, cloudwatchService, cloudmonitoringService, elasticsearchService, graphiteService, influxdbService, lokiService, opentsdbService, prometheusService, tempoService, testdatasourceService, postgresService, mysqlService, mssqlService, grafanadsService, pyroscopeService, parcaService, zipkinService, jaegerService)
	providerService := provider2.ProvideService(corepluginRegistry)
	processService := process.ProvideService()
	retrieverService := retriever.ProvideService(sqlStore, apikeyService, kvStore, userService, orgService)
	serviceAccountPermissionsService, err := ossaccesscontrol.ProvideServiceAccountPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, retrieverService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	serviceAccountsService, err := manager3.ProvideServiceAccountsService(cfg, usageStats, sqlStore, apikeyService, kvStore, userService, orgService, acimplService, serviceAccountPermissionsService, serverLockService)
	if err != nil {
		return nil, err
	}
	extSvcAccountsService := extsvcaccounts.ProvideExtSvcAccountsService(acimplService, cfg, inProcBus, sqlStore, featureToggles, registerer, serviceAccountsService, secretsService, tracingService)
	registryRegistry := registry2.ProvideExtSvcRegistry(cfg, extSvcAccountsService, serverLockService, featureToggles)
	service13 := service6.ProvideService(sqlStore, secretsService)
	serviceregistrationService := serviceregistration.ProvideService(cfg, featureToggles, registryRegistry, service13)
	initialize := pipeline.ProvideInitializationStage(pluginManagementCfg, inMemory, providerService, processService, serviceregistrationService, acimplService, actionSetService, envVarsProvider, tracingService)
	terminate, err := pipeline.ProvideTerminationStage(pluginManagementCfg, inMemory, processService)
	if err != nil {
		return nil, err
	}
	errorRegistry := pluginerrs.ProvideErrorTracker()
	loaderLoader := loader.ProvideService(pluginManagementCfg, discovery, bootstrap, validate, initialize, terminate, errorRegistry)
	pluginstoreService, err := pluginstore.ProvideService(inMemory, sourcesService, loaderLoader)
	if err != nil {
		return nil, err
	}
	filestoreService := filestore.ProvideService(inMemory)
	fileStoreManager := dashboards.ProvideFileStoreManager(pluginstoreService, filestoreService)
	folderPermissionsService, err := ossaccesscontrol.ProvideFolderPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, folderimplService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	k8sHandlerWithFallback := client.ProvideK8sClientWithFallback(cfg, eventualRestConfigProvider, dashboardsStore, userService, resourceClient, featureToggles, dualwriteService, sortService, registerer)
	dashboardServiceImpl, err := service7.ProvideDashboardServiceImpl(cfg, dashboardsStore, featureToggles, folderPermissionsService, accessControl, acimplService, folderimplService, registerer, quotaService, orgService, publicDashboardServiceWrapperImpl, dualwriteService, serverLockService, kvStore, k8sHandlerWithFallback)
	if err != nil {
		return nil, err
	}
	pluginService := service7.ProvideDashboardPluginService(featureToggles, dashboardServiceImpl)
	service14 := service8.ProvideService(fileStoreManager, pluginService)
	orgRoleMapper := connectors.ProvideOrgRoleMapper(cfg, orgService)
	ssosettingsimplService := ssosettingsimpl.ProvideService(cfg, sqlStore, accessControl, routeRegisterImpl, featureToggles, secretsService, usageStats, registerer, ossImpl, ossLicensingService)
	socialService := socialimpl.ProvideService(cfg, featureToggles, usageStats, bundleregistryService, remoteCache, orgRoleMapper, ssosettingsimplService)
	loginStore := authinfoimpl.ProvideStore(sqlStore, secretsService)
	authinfoimplService := authinfoimpl.ProvideService(loginStore, remoteCache, secretsService)
	userAuthTokenService, err := authimpl.ProvideUserAuthTokenService(sqlStore, serverLockService, quotaService, secretsService, cfg, tracingService, featureToggles)
	if err != nil {
		return nil, err
	}
	oauthtokenService := oauthtoken.ProvideService(socialService, authinfoimplService, cfg, registerer, serverLockService, tracingService, userAuthTokenService, featureToggles)
	ossCachingService := caching.ProvideCachingService()
	middlewareHandler, err := pluginsintegration.ProvideClientWithMiddlewares(cfg, inMemory, oauthtokenService, tracingService, ossCachingService, featureToggles, registerer)
	if err != nil {
		return nil, err
	}
	pluginerrsStore := pluginerrs.ProvideStore(errorRegistry)
	repoManager, err := repo.ProvideService(pluginManagementCfg)
	if err != nil {
		return nil, err
	}
	pluginInstaller := manager4.ProvideInstaller(pluginManagementCfg, inMemory, loaderLoader, repoManager, serviceregistrationService)
	ossProvider := guardian.ProvideGuardian()
	cacheServiceImpl := service9.ProvideCacheService(cacheService, sqlStore, ossProvider)
	shortURLService := shorturlimpl.ProvideService(sqlStore)
	queryHistoryService := queryhistory.ProvideService(cfg, sqlStore, routeRegisterImpl, accessControl)
	dashboardService := service7.ProvideDashboardService(featureToggles, dashboardServiceImpl)
	dashverService := dashverimpl.ProvideService(cfg, sqlStore, dashboardService, featureToggles, k8sHandlerWithFallback)
	dashboardSnapshotStore := database5.ProvideStore(sqlStore, cfg)
	serviceImpl := service10.ProvideService(dashboardSnapshotStore, secretsService, dashboardService)
	dBstore, err := store2.ProvideDBStore(cfg, featureToggles, sqlStore, folderimplService, dashboardService, accessControl, inProcBus)
	if err != nil {
		return nil, err
	}
	deleteExpiredService := image.ProvideDeleteExpiredService(dBstore)
	tempuserService := tempuserimpl.ProvideService(sqlStore, cfg)
	cleanupServiceImpl := annotationsimpl.ProvideCleanupService(sqlStore, cfg)
	cleanUpService := cleanup.ProvideService(cfg, featureToggles, serverLockService, shortURLService, sqlStore, queryHistoryService, dashverService, serviceImpl, deleteExpiredService, tempuserService, tracingService, cleanupServiceImpl, dBstore, eventualRestConfigProvider, orgService)
	secretsKVStore, err := kvstore2.ProvideService(sqlStore, secretsService)
	if err != nil {
		return nil, err
	}
	datasourcePermissionsService := ossaccesscontrol.ProvideDatasourcePermissionsService(cfg, featureToggles, sqlStore)
	requestConfigProvider := pluginconfig.NewRequestConfigProvider(pluginInstanceCfg)
	baseProvider := plugincontext.ProvideBaseService(cfg, requestConfigProvider)
	service15, err := service9.ProvideService(sqlStore, secretsService, secretsKVStore, cfg, featureToggles, accessControl, datasourcePermissionsService, quotaService, pluginstoreService, middlewareHandler, baseProvider)
	if err != nil {
		return nil, err
	}
	correlationsService, err := correlations.ProvideService(sqlStore, routeRegisterImpl, service15, accessControl, inProcBus, quotaService, cfg)
	if err != nil {
		return nil, err
	}
	mailer, err := notifications.ProvideSmtpService(cfg)
	if err != nil {
		return nil, err
	}
	notificationService, err := notifications.ProvideService(inProcBus, cfg, mailer, tempuserService)
	if err != nil {
		return nil, err
	}
	dashboardProvisioningService := service7.ProvideDashboardProvisioningService(featureToggles, dashboardServiceImpl)
	receiverPermissionsService, err := ossaccesscontrol.ProvideReceiverPermissionsService(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	azurePromMigrationService := promtypemigration.ProvideAzurePromMigrationService(service15, inMemory, repoManager, pluginInstaller, cfg)
	amazonPromMigrationService := promtypemigration.ProvideAmazonPromMigrationService(service15, inMemory, repoManager, pluginInstaller, cfg)
	promTypeMigrationProviderImpl := promtypemigration.ProvidePromTypeMigrationProvider(serverLockService, featureToggles, azurePromMigrationService, amazonPromMigrationService)
	provisioningServiceImpl, err := provisioning.ProvideService(accessControl, cfg, sqlStore, pluginstoreService, dBstore, serviceService, notificationService, dashboardProvisioningService, service15, correlationsService, dashboardService, folderimplService, service13, searchService, quotaService, secretsService, orgService, receiverPermissionsService, tracingService, dualwriteService, promTypeMigrationProviderImpl)
	if err != nil {
		return nil, err
	}
	dataSourceProxyService := datasourceproxy.ProvideService(cacheServiceImpl, ossDataSourceRequestValidator, pluginstoreService, cfg, httpclientProvider, oauthtokenService, service15, tracingService, secretsService, featureToggles)
	starService := starimpl.ProvideService(sqlStore)
	searchSearchService := search2.ProvideService(cfg, sqlStore, starService, dashboardService, folderimplService, featureToggles, sortService)
	plugincontextProvider := plugincontext.ProvideService(cfg, cacheService, pluginstoreService, cacheServiceImpl, service15, service13, requestConfigProvider)
	qsDatasourceClientBuilder := dsquerierclient.NewNullQSDatasourceClientBuilder()
	exprService := expr.ProvideService(cfg, middlewareHandler, plugincontextProvider, featureToggles, registerer, tracingService, qsDatasourceClientBuilder)
	queryServiceImpl := query.ProvideService(cfg, cacheServiceImpl, exprService, ossDataSourceRequestValidator, middlewareHandler, plugincontextProvider, qsDatasourceClientBuilder)
	repositoryImpl := annotationsimpl.ProvideService(sqlStore, cfg, featureToggles, tagimplService, tracingService, dBstore, dashboardService, registerer)
	grafanaLive, err := live.ProvideService(plugincontextProvider, cfg, routeRegisterImpl, pluginstoreService, middlewareHandler, cacheService, cacheServiceImpl, sqlStore, secretsService, usageStats, queryServiceImpl, featureToggles, accessControl, dashboardService, repositoryImpl, orgService, eventualRestConfigProvider)
	if err != nil {
		return nil, err
	}
	gateway := pushhttp.ProvideService(cfg, grafanaLive)
	authnimplService := authnimpl.ProvideService(cfg, tracingService, userAuthTokenService, usageStats, registerer, authinfoimplService)
	authnAuthenticator := authnimpl.ProvideAuthnServiceAuthenticateOnly(authnimplService)
	contexthandlerContextHandler := contexthandler.ProvideService(cfg, authnAuthenticator, featureToggles)
	logger := loggermw.Provide(cfg, featureToggles)
	ngAlert := metrics2.ProvideService()
	alertNG, err := ngalert.ProvideService(cfg, featureToggles, cacheServiceImpl, service15, routeRegisterImpl, sqlStore, kvStore, exprService, dataSourceProxyService, quotaService, secretsService, notificationService, ngAlert, folderimplService, accessControl, dashboardService, renderingService, inProcBus, acimplService, repositoryImpl, pluginstoreService, tracingService, dBstore, httpclientProvider, plugincontextProvider, receiverPermissionsService, userService)
	if err != nil {
		return nil, err
	}
	libraryElementService := libraryelements.ProvideService(cfg, sqlStore, routeRegisterImpl, folderimplService, featureToggles, accessControl, dashboardService, eventualRestConfigProvider, userService)
	libraryPanelService, err := librarypanels.ProvideService(cfg, sqlStore, routeRegisterImpl, libraryElementService, folderimplService)
	if err != nil {
		return nil, err
	}
	grafanaService, err := updatemanager.ProvideGrafanaService(cfg, tracingService)
	if err != nil {
		return nil, err
	}
	noop := managedplugins.NewNoop()
	provisionedpluginsNoop := provisionedplugins.NewNoop()
	preinstallImpl := pluginchecker.ProvidePreinstall(cfg)
	plugincheckerService := pluginchecker.ProvideService(noop, provisionedpluginsNoop, preinstallImpl)
	pluginsService, err := updatemanager.ProvidePluginsService(cfg, pluginstoreService, pluginInstaller, tracingService, featureToggles, plugincheckerService)
	if err != nil {
		return nil, err
	}
	ossSearchUserFilter := filters.ProvideOSSSearchUserFilter()
	ossService := searchusers.ProvideUsersService(cfg, ossSearchUserFilter, userService)
	serviceAccountsProxy, err := proxy.ProvideServiceAccountsProxy(cfg, accessControl, acimplService, featureToggles, serviceAccountPermissionsService, serviceAccountsService, routeRegisterImpl)
	if err != nil {
		return nil, err
	}
	pluginassetsService := pluginassets2.ProvideService(pluginManagementCfg, pluginscdnService, signatureSignature, pluginstoreService)
	avatarCacheServer := avatar.ProvideAvatarCacheServer(cfg)
	prefService := prefimpl.ProvideService(sqlStore, cfg)
	dashboardPermissionsService, err := ossaccesscontrol.ProvideDashboardPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardService, folderimplService, acimplService, teamService, userService, actionSetService, dashboardServiceImpl)
	if err != nil {
		return nil, err
	}
	csrfCSRF := csrf.ProvideCSRFFilter(cfg)
	playlistService := playlistimpl.ProvideService(sqlStore, tracingService)
	secretsMigrator := migrator.ProvideSecretsMigrator(serviceService, secretsService, sqlStore, ossImpl, featureToggles)
	dataSourceSecretMigrationService := migrations2.ProvideDataSourceMigrationService(service15, kvStore, featureToggles)
	secretMigrationProviderImpl := migrations2.ProvideSecretMigrationProvider(serverLockService, dataSourceSecretMigrationService)
	publicDashboardServiceImpl := service3.ProvideService(cfg, featureToggles, publicDashboardStoreImpl, queryServiceImpl, repositoryImpl, accessControl, publicDashboardServiceWrapperImpl, dashboardService, ossLicensingService)
	middleware := api2.ProvideMiddleware()
	apiApi := api2.ProvideApi(publicDashboardServiceImpl, routeRegisterImpl, accessControl, featureToggles, middleware, cfg, ossLicensingService)
	loginattemptimplService := loginattemptimpl.ProvideService(sqlStore, cfg, serverLockService)
	deletionService, err := orgimpl.ProvideDeletionService(sqlStore, cfg, dashboardService, accessControl)
	if err != nil {
		return nil, err
	}
	authnService := authnimpl.ProvideAuthnService(authnimplService)
	navtreeService := navtreeimpl.ProvideService(cfg, accessControl, pluginstoreService, service13, starService, featureToggles, dashboardService, acimplService, kvStore, apikeyService, ossLicensingService, authnService)
	searchHTTPService := searchV2.ProvideSearchHTTPService(searchService)
	statsService := statsimpl.ProvideService(cfg, sqlStore, dashboardService, folderimplService, orgService, featureToggles)
	gatherer := metrics.ProvideGatherer()
	apiAPI := api3.ProvideApi(starService, dashboardService)
	anonUserLimitValidatorImpl := validator2.ProvideAnonUserLimitValidator()
	anonDeviceService := anonimpl.ProvideAnonymousDeviceService(usageStats, authnService, sqlStore, cfg, orgService, serverLockService, accessControl, routeRegisterImpl, anonUserLimitValidatorImpl)
	signingkeysimplService, err := signingkeysimpl.ProvideEmbeddedSigningKeysService(sqlStore, secretsService, remoteCache, routeRegisterImpl)
	if err != nil {
		return nil, err
	}
	localSigner, err := idimpl.ProvideLocalSigner(signingkeysimplService)
	if err != nil {
		return nil, err
	}
	idimplService := idimpl.ProvideService(cfg, localSigner, remoteCache, authnService, registerer, tracer)
	verifier := userimpl.ProvideVerifier(cfg, userService, tempuserService, notificationService, idimplService)
	httpServer, err := api.ProvideHTTPServer(apiOpts, cfg, routeRegisterImpl, inProcBus, renderingService, ossLicensingService, hooksService, cacheService, sqlStore, ossDataSourceRequestValidator, pluginstoreService, service14, pluginstoreService, middlewareHandler, pluginerrsStore, pluginInstaller, ossImpl, cacheServiceImpl, userAuthTokenService, cleanUpService, shortURLService, queryHistoryService, correlationsService, remoteCache, provisioningServiceImpl, accessControl, dataSourceProxyService, searchSearchService, grafanaLive, gateway, plugincontextProvider, contexthandlerContextHandler, logger, featureToggles, alertNG, libraryPanelService, libraryElementService, quotaService, socialService, tracingService, serviceService, grafanaService, pluginsService, ossService, service15, queryServiceImpl, filestoreService, serviceAccountsProxy, pluginassetsService, authinfoimplService, storageService, notificationService, dashboardService, dashboardProvisioningService, folderimplService, ossProvider, serviceImpl, service13, avatarCacheServer, prefService, folderPermissionsService, dashboardPermissionsService, dashverService, starService, csrfCSRF, noop, playlistService, apikeyService, kvStore, secretsMigrator, secretsService, secretMigrationProviderImpl, secretsKVStore, apiApi, userService, tempuserService, loginattemptimplService, orgService, deletionService, teamService, acimplService, navtreeService, repositoryImpl, tagimplService, searchHTTPService, oauthtokenService, statsService, authnService, pluginscdnService, gatherer, apiAPI, registerer, eventualRestConfigProvider, anonDeviceService, verifier, preinstallImpl)
	if err != nil {
		return nil, err
	}
	validatorService, err := validator3.ProvideService(pluginstoreService)
	if err != nil {
		return nil, err
	}
	sandboxService := sandbox.ProvideService(cfg)
	advisorService, err := advisor.ProvideService(cfg, eventualRestConfigProvider)
	if err != nil {
		return nil, err
	}
	statscollectorService := statscollector.ProvideService(usageStats, validatorService, statsService, cfg, sqlStore, socialService, pluginstoreService, featureManager, service15, httpclientProvider, sandboxService, advisorService)
	internalMetricsService, err := metrics.ProvideService(cfg, registerer, gatherer)
	if err != nil {
		return nil, err
	}
	supportbundlesimplService, err := supportbundlesimpl.ProvideService(accessControl, acimplService, bundleregistryService, cfg, featureToggles, httpServer, kvStore, service13, pluginstoreService, routeRegisterImpl, ossImpl, sqlStore, usageStats, tracingService)
	if err != nil {
		return nil, err
	}
	metricService, err := metric.ProvideService(publicDashboardStoreImpl, registerer)
	if err != nil {
		return nil, err
	}
	scopedPluginDatasourceProvider := datasource.ProvideDefaultPluginConfigs(service15, cacheServiceImpl, plugincontextProvider)
	v := builder.ProvideDefaultBuildHandlerChainFuncFromBuilders()
	aggregatorRunner := aggregatorrunner.ProvideNoopAggregatorConfigurator()
	playlistAppInstaller, err := playlist.RegisterAppInstaller(playlistService, cfg, featureToggles)
	if err != nil {
		return nil, err
	}
	pluginsAppInstaller, err := plugins.RegisterAppInstaller(cfg, featureToggles)
	if err != nil {
		return nil, err
	}
	shortURLAppInstaller, err := shorturl.RegisterAppInstaller(cfg, shortURLService)
	if err != nil {
		return nil, err
	}
	v2 := appregistry.ProvideAppInstallers(featureToggles, playlistAppInstaller, pluginsAppInstaller, shortURLAppInstaller)
	builderMetrics := builder.ProvideBuilderMetrics(registerer)
	apiserverService, err := apiserver.ProvideService(cfg, featureToggles, routeRegisterImpl, tracingService, serverLockService, sqlStore, kvStore, middlewareHandler, scopedPluginDatasourceProvider, plugincontextProvider, pluginstoreService, dualwriteService, resourceClient, inlineSecureValueSupport, eventualRestConfigProvider, v, eventualRestConfigProvider, registerer, aggregatorRunner, v2, builderMetrics)
	if err != nil {
		return nil, err
	}
	pluginexternalService, err := pluginexternal.ProvideService(cfg, pluginstoreService)
	if err != nil {
		return nil, err
	}
	plugininstallerService, err := plugininstaller.ProvideService(cfg, pluginstoreService, pluginInstaller, registerer, repoManager, featureToggles, plugincheckerService)
	if err != nil {
		return nil, err
	}
	zanzanaReconciler := dualwrite2.ProvideZanzanaReconciler(cfg, featureToggles, zanzanaClient, sqlStore, serverLockService, folderimplService)
	investigationsAppProvider := investigations.RegisterApp(cfg)
	checkregistryService := checkregistry.ProvideService(service15, pluginstoreService, plugincontextProvider, middlewareHandler, plugincheckerService, repoManager, preinstallImpl, noop, provisionedpluginsNoop, ssosettingsimplService, cfg, pluginerrsStore)
	advisorAppProvider := advisor2.RegisterApp(checkregistryService, cfg)
	alertingNotificationsAppProvider := notifications2.RegisterApp(cfg, alertNG)
	appregistryService, err := appregistry.ProvideBuilderRunners(apiserverService, eventualRestConfigProvider, featureToggles, investigationsAppProvider, advisorAppProvider, alertingNotificationsAppProvider, cfg)
	if err != nil {
		return nil, err
	}
	importDashboardService := service11.ProvideService(routeRegisterImpl, quotaService, service14, pluginstoreService, libraryPanelService, dashboardService, accessControl, folderimplService, featureToggles)
	dashboardUpdater := service8.ProvideDashboardUpdater(inProcBus, pluginstoreService, service14, importDashboardService, service13, pluginService, dashboardService)
	worker := garbagecollectionworker.ProvideWorker(cfg, secureValueMetadataStorage, keeperMetadataStorage, ossKeeperService)
	healthService, err := grpcserver.ProvideHealthService(cfg, grpcserverProvider)
	if err != nil {
		return nil, err
	}
	reflectionService, err := grpcserver.ProvideReflectionService(cfg, grpcserverProvider)
	if err != nil {
		return nil, err
	}
	ossGroups := ldap.ProvideGroupsService()
	identitySynchronizer := authnimpl.ProvideIdentitySynchronizer(authnimplService)
	ldapImpl := service12.ProvideService(cfg, featureToggles, ssosettingsimplService)
	apiService := api4.ProvideService(cfg, routeRegisterImpl, accessControl, userService, authinfoimplService, ossGroups, identitySynchronizer, orgService, ldapImpl, userAuthTokenService, bundleregistryService)
	dashboardsAPIBuilder := dashboard.RegisterAPIService(cfg, featureToggles, apiserverService, dashboardService, dashboardProvisioningService, pluginstoreService, service15, dashboardServiceImpl, dashboardPermissionsService, accessControl, accessClient, provisioningServiceImpl, dashboardsStore, registerer, sqlStore, tracingService, resourceClient, dualwriteService, sortService, quotaService, libraryPanelService, eventualRestConfigProvider, userService)
	snapshotsAPIBuilder := dashboardsnapshot.RegisterAPIService(serviceImpl, apiserverService, cfg, featureToggles, sqlStore, registerer)
	featureFlagAPIBuilder := featuretoggle.RegisterAPIService(featureManager, accessControl, apiserverService, cfg, registerer)
	dataSourceAPIBuilder, err := datasource.RegisterAPIService(featureToggles, apiserverService, middlewareHandler, scopedPluginDatasourceProvider, plugincontextProvider, pluginstoreService, accessControl, registerer)
	if err != nil {
		return nil, err
	}
	folderAPIBuilder := folders.RegisterAPIService(cfg, featureToggles, apiserverService, folderimplService, folderPermissionsService, accessControl, acimplService, accessClient, registerer, resourceClient, zanzanaClient)
	storageBackendImpl := noopstorage.ProvideStorageBackend()
	identityAccessManagementAPIBuilder, err := iam.RegisterAPIService(featureToggles, apiserverService, ssosettingsimplService, sqlStore, accessControl, accessClient, registerer, storageBackendImpl, storageBackendImpl)
	if err != nil {
		return nil, err
	}
	legacyDataSourceLookup := service9.ProvideLegacyDataSourceLookup(service15)
	queryAPIBuilder, err := query2.RegisterAPIService(cfg, featureToggles, apiserverService, service15, pluginstoreService, accessControl, middlewareHandler, plugincontextProvider, registerer, tracingService, legacyDataSourceLookup, exprService)
	if err != nil {
		return nil, err
	}
	userStorageAPIBuilder := userstorage.RegisterAPIService(featureToggles, apiserverService, registerer)
	apiBuilder := preferences.RegisterAPIService(cfg, featureToggles, sqlStore, prefService, starService, userService, apiserverService)
	legacyMigrator := legacy.ProvideLegacyMigrator(sqlStore, provisioningServiceImpl, libraryPanelService, dashboardPermissionsService, accessControl, featureToggles)
	webhookExtraBuilder := webhooks.ProvideWebhooks(cfg, renderingService, resourceClient, eventualRestConfigProvider)
	v3 := extras.ProvideProvisioningOSSExtras(webhookExtraBuilder)
	decryptAuthorizer := decrypt.ProvideDecryptAuthorizer(tracer)
	decryptStorage, err := metadata.ProvideDecryptStorage(tracer, ossKeeperService, keeperMetadataStorage, secureValueMetadataStorage, decryptAuthorizer, registerer)
	if err != nil {
		return nil, err
	}
	decryptService, err := decrypt.ProvideDecryptService(cfg, tracer, decryptStorage)
	if err != nil {
		return nil, err
	}
	factory := github.ProvideFactory()
	v4 := extras.ProvideProvisioningOSSRepositoryExtras(cfg, decryptService, factory, webhookExtraBuilder)
	repositoryFactory, err := repository.ProvideFactory(v4)
	if err != nil {
		return nil, err
	}
	provisioningAPIBuilder, err := provisioning2.RegisterAPIService(cfg, featureToggles, apiserverService, registerer, resourceClient, eventualRestConfigProvider, accessClient, legacyMigrator, dualwriteService, usageStats, tracingService, v3, repositoryFactory)
	if err != nil {
		return nil, err
	}
	ofrepAPIBuilder, err := ofrep.RegisterAPIService(apiserverService, cfg)
	if err != nil {
		return nil, err
	}
	secretDBMigrator := migrator2.NewWithEngine(sqlStore)
	dependencyRegisterer, err := secret.RegisterDependencies(featureToggles, cfg, secretDBMigrator, acimplService)
	if err != nil {
		return nil, err
	}
	apiregistryService := apiregistry.ProvideRegistryServiceSink(dashboardsAPIBuilder, snapshotsAPIBuilder, featureFlagAPIBuilder, dataSourceAPIBuilder, folderAPIBuilder, identityAccessManagementAPIBuilder, queryAPIBuilder, userStorageAPIBuilder, apiBuilder, provisioningAPIBuilder, ofrepAPIBuilder, dependencyRegisterer)
	teamPermissionsService, err := ossaccesscontrol.ProvideTeamPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	teamAPI := teamapi.ProvideTeamAPI(routeRegisterImpl, teamService, acimplService, accessControl, teamPermissionsService, userService, ossLicensingService, cfg, prefService, dashboardService, featureToggles)
	cloudmigrationService, err := cloudmigrationimpl.ProvideService(cfg, httpclientProvider, featureToggles, sqlStore, service15, secretsKVStore, secretsService, routeRegisterImpl, registerer, tracingService, dashboardService, folderimplService, pluginstoreService, service13, accessControl, acimplService, kvStore, libraryElementService, alertNG)
	if err != nil {
		return nil, err
	}
	authService, err := jwt.ProvideService(cfg, remoteCache)
	if err != nil {
		return nil, err
	}
	ossUserProtectionImpl := authinfoimpl.ProvideOSSUserProtectionService()
	registration := authnimpl.ProvideRegistration(cfg, authnService, orgService, userAuthTokenService, acimplService, permissionRegistry, apikeyService, userService, authService, ossUserProtectionImpl, loginattemptimplService, quotaService, authinfoimplService, renderingService, featureToggles, oauthtokenService, socialService, remoteCache, ldapImpl, ossImpl, tracingService, tempuserService, notificationService)
	backgroundServiceRegistry := backgroundsvcs.ProvideBackgroundServiceRegistry(httpServer, alertNG, cleanUpService, grafanaLive, gateway, notificationService, pluginstoreService, renderingService, userAuthTokenService, tracingService, provisioningServiceImpl, usageStats, statscollectorService, grafanaService, pluginsService, internalMetricsService, secretsService, remoteCache, storageService, searchService, entityEventsService, serviceAccountsService, grpcserverProvider, secretMigrationProviderImpl, loginattemptimplService, supportbundlesimplService, metricService, keyRetriever, angulardetectorsproviderDynamic, apiserverService, anonDeviceService, ssosettingsimplService, pluginexternalService, plugininstallerService, zanzanaReconciler, appregistryService, dashboardUpdater, dashboardServiceImpl, worker, serviceImpl, serviceAccountsProxy, healthService, reflectionService, apiService, apiregistryService, idimplService, teamAPI, ssosettingsimplService, cloudmigrationService, registration)
	usageStatsProvidersRegistry := usagestatssvcs.ProvideUsageStatsProvidersRegistry(acimplService, userService)
	server, err := New(opts, cfg, httpServer, acimplService, provisioningServiceImpl, backgroundServiceRegistry, usageStatsProvidersRegistry, statscollectorService, registerer)
	if err != nil {
		return nil, err
	}
	return server, nil
}

func InitializeForTest(ctx context.Context, t sqlutil.ITestDB, testingT interface {
	Cleanup(func())
	mock.TestingT
}, cfg *setting.Cfg, opts Options, apiOpts api.ServerOptions) (*TestEnv, error) {
	routeRegisterImpl := routing.ProvideRegister()
	tracingConfig, err := tracing.ProvideTracingConfig(cfg)
	if err != nil {
		return nil, err
	}
	tracingService, err := tracing.ProvideService(tracingConfig)
	if err != nil {
		return nil, err
	}
	inProcBus := bus.ProvideBus(tracingService)
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	ossMigrations := migrations.ProvideOSSMigrations(featureToggles)
	sqlStore, err := sqlstore.ProvideServiceForTests(t, cfg, featureToggles, inProcBus, ossMigrations)
	if err != nil {
		return nil, err
	}
	kvStore := kvstore.ProvideService(sqlStore)
	accessControl := acimpl.ProvideAccessControl(featureToggles)
	bundleregistryService := bundleregistry.ProvideService()
	usageStats, err := service.ProvideService(cfg, kvStore, routeRegisterImpl, tracingService, accessControl, bundleregistryService)
	if err != nil {
		return nil, err
	}
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	providerProvider := provider.ProvideEncryptionProvider()
	serviceService, err := service2.ProvideEncryptionService(tracingService, providerProvider, usageStats, cfg)
	if err != nil {
		return nil, err
	}
	osskmsprovidersService := osskmsproviders.ProvideService(serviceService, cfg, featureToggles)
	secretsService, err := manager.ProvideSecretsService(tracingService, secretsStoreImpl, osskmsprovidersService, serviceService, cfg, featureToggles, usageStats)
	if err != nil {
		return nil, err
	}
	remoteCache, err := remotecache.ProvideService(cfg, sqlStore, usageStats, secretsService)
	if err != nil {
		return nil, err
	}
	ossImpl := setting.ProvideProvider(cfg)
	pluginManagementCfg, err := pluginconfig.ProvidePluginManagementConfig(cfg, ossImpl, featureToggles)
	if err != nil {
		return nil, err
	}
	pluginInstanceCfg, err := pluginconfig.ProvidePluginInstanceConfig(cfg, ossImpl, featureToggles)
	if err != nil {
		return nil, err
	}
	hooksService := hooks.ProvideService()
	ossLicensingService := licensing.ProvideService(cfg, hooksService)
	licensingService := licensing2.ProvideLicensing(cfg, ossLicensingService)
	envVarsProvider := pluginconfig.NewEnvVarsProvider(pluginInstanceCfg, licensingService)
	inMemory := registry.ProvideService()
	rendererManager, err := renderer.ProvideService(pluginManagementCfg, envVarsProvider, inMemory, tracingService)
	if err != nil {
		return nil, err
	}
	renderingService, err := rendering.ProvideService(cfg, featureToggles, remoteCache, rendererManager)
	if err != nil {
		return nil, err
	}
	cacheService := localcache.ProvideService()
	ossDataSourceRequestValidator := validations.ProvideValidator()
	sourcesService := sources.ProvideService(cfg, pluginManagementCfg)
	discovery := pipeline.ProvideDiscoveryStage(pluginManagementCfg, inMemory)
	keystoreService := keystore.ProvideService(kvStore)
	keyRetriever := dynamic.ProvideService(cfg, keystoreService)
	keyretrieverService := keyretriever.ProvideService(keyRetriever)
	signatureSignature := signature.ProvideService(pluginManagementCfg, keyretrieverService)
	pluginscdnService := pluginscdn.ProvideService(pluginManagementCfg)
	localProvider := pluginassets.ProvideService()
	assetpathService := assetpath.ProvideService(pluginManagementCfg, pluginscdnService, localProvider)
	bootstrap := pipeline.ProvideBootstrapStage(pluginManagementCfg, signatureSignature, assetpathService)
	unsignedPluginAuthorizer := signature.ProvideOSSAuthorizer(pluginManagementCfg)
	validation := signature.ProvideValidatorService(unsignedPluginAuthorizer)
	angularpatternsstoreService := angularpatternsstore.ProvideService(kvStore)
	angulardetectorsproviderDynamic, err := angulardetectorsprovider.ProvideDynamic(cfg, angularpatternsstoreService)
	if err != nil {
		return nil, err
	}
	angularinspectorService, err := angularinspector.ProvideService(angulardetectorsproviderDynamic)
	if err != nil {
		return nil, err
	}
	validate := pipeline.ProvideValidationStage(pluginManagementCfg, validation, angularinspectorService)
	ossDataSourceRequestURLValidator := validations.ProvideURLValidator()
	httpclientProvider := httpclientprovider.New(cfg, ossDataSourceRequestURLValidator, tracingService)
	azuremonitorService := azuremonitor.ProvideService(httpclientProvider)
	cloudwatchService := cloudwatch.ProvideService()
	cloudmonitoringService := cloudmonitoring.ProvideService(httpclientProvider)
	elasticsearchService := elasticsearch.ProvideService(httpclientProvider)
	graphiteService := graphite.ProvideService(httpclientProvider, tracingService)
	influxdbService := influxdb.ProvideService(httpclientProvider, featureToggles)
	tracer := otelTracer()
	lokiService := loki.ProvideService(httpclientProvider, tracer)
	opentsdbService := opentsdb.ProvideService(httpclientProvider)
	prometheusService := prometheus.ProvideService(httpclientProvider)
	tempoService := tempo.ProvideService(httpclientProvider)
	testdatasourceService := testdatasource.ProvideService()
	postgresService := postgres.ProvideService(cfg, featureToggles)
	mysqlService := mysql.ProvideService()
	mssqlService := mssql.ProvideService(cfg)
	entityEventsService := store.ProvideEntityEventsService(cfg, sqlStore, featureToggles)
	configProvider, err := configprovider.ProvideService(cfg)
	if err != nil {
		return nil, err
	}
	quotaService := quotaimpl.ProvideService(ctx, sqlStore, configProvider)
	orgService, err := orgimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return nil, err
	}
	teamService, err := teamimpl.ProvideService(sqlStore, cfg, tracingService)
	if err != nil {
		return nil, err
	}
	userService, err := userimpl.ProvideService(sqlStore, orgService, cfg, teamService, cacheService, tracingService, quotaService, bundleregistryService)
	if err != nil {
		return nil, err
	}
	actionSetService := resourcepermissions.NewActionSetService()
	permissionRegistry := permreg.ProvidePermissionRegistry()
	serverLockService := serverlock.ProvideService(sqlStore, tracingService)
	acimplService, err := acimpl.ProvideService(cfg, sqlStore, routeRegisterImpl, cacheService, accessControl, userService, actionSetService, featureToggles, tracingService, permissionRegistry, serverLockService)
	if err != nil {
		return nil, err
	}
	folderStoreImpl := folderimpl.ProvideStore(sqlStore)
	tagimplService := tagimpl.ProvideService(sqlStore)
	dashboardsStore, err := database2.ProvideDashboardStore(sqlStore, cfg, featureToggles, tagimplService)
	if err != nil {
		return nil, err
	}
	publicDashboardStoreImpl := database3.ProvideStore(sqlStore, cfg, featureToggles)
	publicDashboardServiceWrapperImpl := service3.ProvideServiceWrapper(publicDashboardStoreImpl)
	registerer := metrics.ProvideRegistererForTest()
	apikeyService, err := apikeyimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return nil, err
	}
	contextHandler := grpccontext.ProvideContextHandler(tracingService)
	authenticator := interceptors.ProvideAuthenticator(apikeyService, userService, acimplService, contextHandler)
	grpcserverProvider, err := grpcserver.ProvideService(cfg, featureToggles, authenticator, tracer, registerer)
	if err != nil {
		return nil, err
	}
	zanzanaClient, err := authz.ProvideZanzana(cfg, sqlStore, tracingService, featureToggles, registerer)
	if err != nil {
		return nil, err
	}
	eventualRestConfigProvider := apiserver.ProvideEventualRestConfigProvider()
	accessClient, err := authz.ProvideAuthZClient(cfg, featureToggles, grpcserverProvider, tracingService, registerer, sqlStore, acimplService, zanzanaClient, eventualRestConfigProvider)
	if err != nil {
		return nil, err
	}
	ossDashboardStats := search.ProvideDashboardStats()
	documentBuilderSupplier := search.ProvideDocumentBuilders(sqlStore, ossDashboardStats)
	databaseDatabase := database4.ProvideDatabase(sqlStore, tracer)
	clockClock := clock.ProvideClock()
	secureValueMetadataStorage, err := metadata.ProvideSecureValueMetadataStorage(clockClock, databaseDatabase, tracer, registerer)
	if err != nil {
		return nil, err
	}
	secureValueValidator := validator.ProvideSecureValueValidator()
	secureValueMutator := mutator.ProvideSecureValueMutator()
	keeperMetadataStorage, err := metadata.ProvideKeeperMetadataStorage(databaseDatabase, tracer, registerer)
	if err != nil {
		return nil, err
	}
	encryptedValueStorage, err := encryption.ProvideEncryptedValueStorage(databaseDatabase, tracer)
	if err != nil {
		return nil, err
	}
	dataKeyStorage, err := encryption.ProvideDataKeyStorage(databaseDatabase, tracer, registerer)
	if err != nil {
		return nil, err
	}
	cipher, err := service4.ProvideAESGCMCipherService(tracer, usageStats)
	if err != nil {
		return nil, err
	}
	providerConfig, err := kmsproviders.ProvideOSSKMSProviders(cfg, cipher)
	if err != nil {
		return nil, err
	}
	encryptionManager, err := manager2.ProvideEncryptionManager(tracer, dataKeyStorage, usageStats, cipher, providerConfig)
	if err != nil {
		return nil, err
	}
	ossKeeperService, err := secretkeeper.ProvideService(tracer, encryptedValueStorage, encryptionManager, registerer)
	if err != nil {
		return nil, err
	}
	secureValueService := service5.ProvideSecureValueService(tracer, accessClient, databaseDatabase, secureValueMetadataStorage, secureValueValidator, secureValueMutator, keeperMetadataStorage, ossKeeperService, registerer)
	inlineSecureValueSupport, err := inline.ProvideInlineSecureValueService(cfg, tracer, secureValueService, accessClient)
	if err != nil {
		return nil, err
	}
	options := &unified.Options{
		Cfg:          cfg,
		Features:     featureToggles,
		DB:           sqlStore,
		Tracer:       tracingService,
		Reg:          registerer,
		Authzc:       accessClient,
		Docs:         documentBuilderSupplier,
		SecureValues: inlineSecureValueSupport,
	}
	storageMetrics := resource.ProvideStorageMetrics(registerer)
	bleveIndexMetrics := resource.ProvideIndexMetrics(registerer)
	resourceClient, err := unified.ProvideUnifiedStorageClient(options, storageMetrics, bleveIndexMetrics)
	if err != nil {
		return nil, err
	}
	dualwriteService := dualwrite.ProvideService(featureToggles, registerer, kvStore, cfg)
	sortService := sort.ProvideService()
	folderimplService := folderimpl.ProvideService(folderStoreImpl, accessControl, inProcBus, dashboardsStore, userService, sqlStore, featureToggles, bundleregistryService, publicDashboardServiceWrapperImpl, cfg, registerer, tracer, resourceClient, dualwriteService, sortService, eventualRestConfigProvider)
	searchService := searchV2.ProvideService(cfg, sqlStore, entityEventsService, acimplService, tracingService, featureToggles, orgService, userService, folderimplService)
	systemUsers := store.ProvideSystemUsersService()
	storageService, err := store.ProvideService(sqlStore, featureToggles, cfg, quotaService, systemUsers)
	if err != nil {
		return nil, err
	}
	grafanadsService := grafanads.ProvideService(searchService, storageService, featureToggles)
	pyroscopeService := pyroscope.ProvideService(httpclientProvider)
	parcaService := parca.ProvideService(httpclientProvider)
	zipkinService := zipkin.ProvideService(httpclientProvider)
	jaegerService := jaeger.ProvideService(httpclientProvider)
	corepluginRegistry := coreplugin.ProvideCoreRegistry(tracingService, azuremonitorService, cloudwatchService, cloudmonitoringService, elasticsearchService, graphiteService, influxdbService, lokiService, opentsdbService, prometheusService, tempoService, testdatasourceService, postgresService, mysqlService, mssqlService, grafanadsService, pyroscopeService, parcaService, zipkinService, jaegerService)
	providerService := provider2.ProvideService(corepluginRegistry)
	processService := process.ProvideService()
	retrieverService := retriever.ProvideService(sqlStore, apikeyService, kvStore, userService, orgService)
	serviceAccountPermissionsService, err := ossaccesscontrol.ProvideServiceAccountPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, retrieverService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	serviceAccountsService, err := manager3.ProvideServiceAccountsService(cfg, usageStats, sqlStore, apikeyService, kvStore, userService, orgService, acimplService, serviceAccountPermissionsService, serverLockService)
	if err != nil {
		return nil, err
	}
	extSvcAccountsService := extsvcaccounts.ProvideExtSvcAccountsService(acimplService, cfg, inProcBus, sqlStore, featureToggles, registerer, serviceAccountsService, secretsService, tracingService)
	registryRegistry := registry2.ProvideExtSvcRegistry(cfg, extSvcAccountsService, serverLockService, featureToggles)
	service13 := service6.ProvideService(sqlStore, secretsService)
	serviceregistrationService := serviceregistration.ProvideService(cfg, featureToggles, registryRegistry, service13)
	initialize := pipeline.ProvideInitializationStage(pluginManagementCfg, inMemory, providerService, processService, serviceregistrationService, acimplService, actionSetService, envVarsProvider, tracingService)
	terminate, err := pipeline.ProvideTerminationStage(pluginManagementCfg, inMemory, processService)
	if err != nil {
		return nil, err
	}
	errorRegistry := pluginerrs.ProvideErrorTracker()
	loaderLoader := loader.ProvideService(pluginManagementCfg, discovery, bootstrap, validate, initialize, terminate, errorRegistry)
	pluginstoreService, err := pluginstore.ProvideService(inMemory, sourcesService, loaderLoader)
	if err != nil {
		return nil, err
	}
	filestoreService := filestore.ProvideService(inMemory)
	fileStoreManager := dashboards.ProvideFileStoreManager(pluginstoreService, filestoreService)
	folderPermissionsService, err := ossaccesscontrol.ProvideFolderPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, folderimplService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	k8sHandlerWithFallback := client.ProvideK8sClientWithFallback(cfg, eventualRestConfigProvider, dashboardsStore, userService, resourceClient, featureToggles, dualwriteService, sortService, registerer)
	dashboardServiceImpl, err := service7.ProvideDashboardServiceImpl(cfg, dashboardsStore, featureToggles, folderPermissionsService, accessControl, acimplService, folderimplService, registerer, quotaService, orgService, publicDashboardServiceWrapperImpl, dualwriteService, serverLockService, kvStore, k8sHandlerWithFallback)
	if err != nil {
		return nil, err
	}
	pluginService := service7.ProvideDashboardPluginService(featureToggles, dashboardServiceImpl)
	service14 := service8.ProvideService(fileStoreManager, pluginService)
	oauthtokentestService := oauthtokentest.ProvideService()
	ossCachingService := caching.ProvideCachingService()
	middlewareHandler, err := pluginsintegration.ProvideClientWithMiddlewares(cfg, inMemory, oauthtokentestService, tracingService, ossCachingService, featureToggles, registerer)
	if err != nil {
		return nil, err
	}
	pluginerrsStore := pluginerrs.ProvideStore(errorRegistry)
	repoManager, err := repo.ProvideService(pluginManagementCfg)
	if err != nil {
		return nil, err
	}
	pluginInstaller := manager4.ProvideInstaller(pluginManagementCfg, inMemory, loaderLoader, repoManager, serviceregistrationService)
	ossProvider := guardian.ProvideGuardian()
	cacheServiceImpl := service9.ProvideCacheService(cacheService, sqlStore, ossProvider)
	userAuthTokenService, err := authimpl.ProvideUserAuthTokenService(sqlStore, serverLockService, quotaService, secretsService, cfg, tracingService, featureToggles)
	if err != nil {
		return nil, err
	}
	shortURLService := shorturlimpl.ProvideService(sqlStore)
	queryHistoryService := queryhistory.ProvideService(cfg, sqlStore, routeRegisterImpl, accessControl)
	dashboardService := service7.ProvideDashboardService(featureToggles, dashboardServiceImpl)
	dashverService := dashverimpl.ProvideService(cfg, sqlStore, dashboardService, featureToggles, k8sHandlerWithFallback)
	dashboardSnapshotStore := database5.ProvideStore(sqlStore, cfg)
	serviceImpl := service10.ProvideService(dashboardSnapshotStore, secretsService, dashboardService)
	dBstore, err := store2.ProvideDBStore(cfg, featureToggles, sqlStore, folderimplService, dashboardService, accessControl, inProcBus)
	if err != nil {
		return nil, err
	}
	deleteExpiredService := image.ProvideDeleteExpiredService(dBstore)
	tempuserService := tempuserimpl.ProvideService(sqlStore, cfg)
	cleanupServiceImpl := annotationsimpl.ProvideCleanupService(sqlStore, cfg)
	cleanUpService := cleanup.ProvideService(cfg, featureToggles, serverLockService, shortURLService, sqlStore, queryHistoryService, dashverService, serviceImpl, deleteExpiredService, tempuserService, tracingService, cleanupServiceImpl, dBstore, eventualRestConfigProvider, orgService)
	secretsKVStore, err := kvstore2.ProvideService(sqlStore, secretsService)
	if err != nil {
		return nil, err
	}
	datasourcePermissionsService := ossaccesscontrol.ProvideDatasourcePermissionsService(cfg, featureToggles, sqlStore)
	requestConfigProvider := pluginconfig.NewRequestConfigProvider(pluginInstanceCfg)
	baseProvider := plugincontext.ProvideBaseService(cfg, requestConfigProvider)
	service15, err := service9.ProvideService(sqlStore, secretsService, secretsKVStore, cfg, featureToggles, accessControl, datasourcePermissionsService, quotaService, pluginstoreService, middlewareHandler, baseProvider)
	if err != nil {
		return nil, err
	}
	correlationsService, err := correlations.ProvideService(sqlStore, routeRegisterImpl, service15, accessControl, inProcBus, quotaService, cfg)
	if err != nil {
		return nil, err
	}
	mailer, err := notifications.ProvideSmtpService(cfg)
	if err != nil {
		return nil, err
	}
	notificationService, err := notifications.ProvideService(inProcBus, cfg, mailer, tempuserService)
	if err != nil {
		return nil, err
	}
	dashboardProvisioningService := service7.ProvideDashboardProvisioningService(featureToggles, dashboardServiceImpl)
	receiverPermissionsService, err := ossaccesscontrol.ProvideReceiverPermissionsService(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	azurePromMigrationService := promtypemigration.ProvideAzurePromMigrationService(service15, inMemory, repoManager, pluginInstaller, cfg)
	amazonPromMigrationService := promtypemigration.ProvideAmazonPromMigrationService(service15, inMemory, repoManager, pluginInstaller, cfg)
	promTypeMigrationProviderImpl := promtypemigration.ProvidePromTypeMigrationProvider(serverLockService, featureToggles, azurePromMigrationService, amazonPromMigrationService)
	provisioningServiceImpl, err := provisioning.ProvideService(accessControl, cfg, sqlStore, pluginstoreService, dBstore, serviceService, notificationService, dashboardProvisioningService, service15, correlationsService, dashboardService, folderimplService, service13, searchService, quotaService, secretsService, orgService, receiverPermissionsService, tracingService, dualwriteService, promTypeMigrationProviderImpl)
	if err != nil {
		return nil, err
	}
	orgRoleMapper := connectors.ProvideOrgRoleMapper(cfg, orgService)
	ssosettingsimplService := ssosettingsimpl.ProvideService(cfg, sqlStore, accessControl, routeRegisterImpl, featureToggles, secretsService, usageStats, registerer, ossImpl, ossLicensingService)
	socialService := socialimpl.ProvideService(cfg, featureToggles, usageStats, bundleregistryService, remoteCache, orgRoleMapper, ssosettingsimplService)
	loginStore := authinfoimpl.ProvideStore(sqlStore, secretsService)
	authinfoimplService := authinfoimpl.ProvideService(loginStore, remoteCache, secretsService)
	oauthtokenService := oauthtoken.ProvideService(socialService, authinfoimplService, cfg, registerer, serverLockService, tracingService, userAuthTokenService, featureToggles)
	dataSourceProxyService := datasourceproxy.ProvideService(cacheServiceImpl, ossDataSourceRequestValidator, pluginstoreService, cfg, httpclientProvider, oauthtokenService, service15, tracingService, secretsService, featureToggles)
	starService := starimpl.ProvideService(sqlStore)
	searchSearchService := search2.ProvideService(cfg, sqlStore, starService, dashboardService, folderimplService, featureToggles, sortService)
	plugincontextProvider := plugincontext.ProvideService(cfg, cacheService, pluginstoreService, cacheServiceImpl, service15, service13, requestConfigProvider)
	qsDatasourceClientBuilder := dsquerierclient.NewNullQSDatasourceClientBuilder()
	exprService := expr.ProvideService(cfg, middlewareHandler, plugincontextProvider, featureToggles, registerer, tracingService, qsDatasourceClientBuilder)
	queryServiceImpl := query.ProvideService(cfg, cacheServiceImpl, exprService, ossDataSourceRequestValidator, middlewareHandler, plugincontextProvider, qsDatasourceClientBuilder)
	repositoryImpl := annotationsimpl.ProvideService(sqlStore, cfg, featureToggles, tagimplService, tracingService, dBstore, dashboardService, registerer)
	grafanaLive, err := live.ProvideService(plugincontextProvider, cfg, routeRegisterImpl, pluginstoreService, middlewareHandler, cacheService, cacheServiceImpl, sqlStore, secretsService, usageStats, queryServiceImpl, featureToggles, accessControl, dashboardService, repositoryImpl, orgService, eventualRestConfigProvider)
	if err != nil {
		return nil, err
	}
	gateway := pushhttp.ProvideService(cfg, grafanaLive)
	authnimplService := authnimpl.ProvideService(cfg, tracingService, userAuthTokenService, usageStats, registerer, authinfoimplService)
	authnAuthenticator := authnimpl.ProvideAuthnServiceAuthenticateOnly(authnimplService)
	contexthandlerContextHandler := contexthandler.ProvideService(cfg, authnAuthenticator, featureToggles)
	logger := loggermw.Provide(cfg, featureToggles)
	notificationServiceMock := notifications.MockNotificationService()
	ngAlert := metrics2.ProvideServiceForTest()
	alertNG, err := ngalert.ProvideService(cfg, featureToggles, cacheServiceImpl, service15, routeRegisterImpl, sqlStore, kvStore, exprService, dataSourceProxyService, quotaService, secretsService, notificationServiceMock, ngAlert, folderimplService, accessControl, dashboardService, renderingService, inProcBus, acimplService, repositoryImpl, pluginstoreService, tracingService, dBstore, httpclientProvider, plugincontextProvider, receiverPermissionsService, userService)
	if err != nil {
		return nil, err
	}
	libraryElementService := libraryelements.ProvideService(cfg, sqlStore, routeRegisterImpl, folderimplService, featureToggles, accessControl, dashboardService, eventualRestConfigProvider, userService)
	libraryPanelService, err := librarypanels.ProvideService(cfg, sqlStore, routeRegisterImpl, libraryElementService, folderimplService)
	if err != nil {
		return nil, err
	}
	grafanaService, err := updatemanager.ProvideGrafanaService(cfg, tracingService)
	if err != nil {
		return nil, err
	}
	noop := managedplugins.NewNoop()
	provisionedpluginsNoop := provisionedplugins.NewNoop()
	preinstallImpl := pluginchecker.ProvidePreinstall(cfg)
	plugincheckerService := pluginchecker.ProvideService(noop, provisionedpluginsNoop, preinstallImpl)
	pluginsService, err := updatemanager.ProvidePluginsService(cfg, pluginstoreService, pluginInstaller, tracingService, featureToggles, plugincheckerService)
	if err != nil {
		return nil, err
	}
	ossSearchUserFilter := filters.ProvideOSSSearchUserFilter()
	ossService := searchusers.ProvideUsersService(cfg, ossSearchUserFilter, userService)
	serviceAccountsProxy, err := proxy.ProvideServiceAccountsProxy(cfg, accessControl, acimplService, featureToggles, serviceAccountPermissionsService, serviceAccountsService, routeRegisterImpl)
	if err != nil {
		return nil, err
	}
	pluginassetsService := pluginassets2.ProvideService(pluginManagementCfg, pluginscdnService, signatureSignature, pluginstoreService)
	avatarCacheServer := avatar.ProvideAvatarCacheServer(cfg)
	prefService := prefimpl.ProvideService(sqlStore, cfg)
	dashboardPermissionsService, err := ossaccesscontrol.ProvideDashboardPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardService, folderimplService, acimplService, teamService, userService, actionSetService, dashboardServiceImpl)
	if err != nil {
		return nil, err
	}
	csrfCSRF := csrf.ProvideCSRFFilter(cfg)
	playlistService := playlistimpl.ProvideService(sqlStore, tracingService)
	secretsMigrator := migrator.ProvideSecretsMigrator(serviceService, secretsService, sqlStore, ossImpl, featureToggles)
	dataSourceSecretMigrationService := migrations2.ProvideDataSourceMigrationService(service15, kvStore, featureToggles)
	secretMigrationProviderImpl := migrations2.ProvideSecretMigrationProvider(serverLockService, dataSourceSecretMigrationService)
	publicDashboardServiceImpl := service3.ProvideService(cfg, featureToggles, publicDashboardStoreImpl, queryServiceImpl, repositoryImpl, accessControl, publicDashboardServiceWrapperImpl, dashboardService, ossLicensingService)
	middleware := api2.ProvideMiddleware()
	apiApi := api2.ProvideApi(publicDashboardServiceImpl, routeRegisterImpl, accessControl, featureToggles, middleware, cfg, ossLicensingService)
	loginattemptimplService := loginattemptimpl.ProvideService(sqlStore, cfg, serverLockService)
	deletionService, err := orgimpl.ProvideDeletionService(sqlStore, cfg, dashboardService, accessControl)
	if err != nil {
		return nil, err
	}
	authnService := authnimpl.ProvideAuthnService(authnimplService)
	navtreeService := navtreeimpl.ProvideService(cfg, accessControl, pluginstoreService, service13, starService, featureToggles, dashboardService, acimplService, kvStore, apikeyService, ossLicensingService, authnService)
	searchHTTPService := searchV2.ProvideSearchHTTPService(searchService)
	statsService := statsimpl.ProvideService(cfg, sqlStore, dashboardService, folderimplService, orgService, featureToggles)
	gatherer := metrics.ProvideGathererForTest(registerer)
	apiAPI := api3.ProvideApi(starService, dashboardService)
	anonUserLimitValidatorImpl := validator2.ProvideAnonUserLimitValidator()
	anonDeviceService := anonimpl.ProvideAnonymousDeviceService(usageStats, authnService, sqlStore, cfg, orgService, serverLockService, accessControl, routeRegisterImpl, anonUserLimitValidatorImpl)
	signingkeysimplService, err := signingkeysimpl.ProvideEmbeddedSigningKeysService(sqlStore, secretsService, remoteCache, routeRegisterImpl)
	if err != nil {
		return nil, err
	}
	localSigner, err := idimpl.ProvideLocalSigner(signingkeysimplService)
	if err != nil {
		return nil, err
	}
	idimplService := idimpl.ProvideService(cfg, localSigner, remoteCache, authnService, registerer, tracer)
	verifier := userimpl.ProvideVerifier(cfg, userService, tempuserService, notificationServiceMock, idimplService)
	httpServer, err := api.ProvideHTTPServer(apiOpts, cfg, routeRegisterImpl, inProcBus, renderingService, ossLicensingService, hooksService, cacheService, sqlStore, ossDataSourceRequestValidator, pluginstoreService, service14, pluginstoreService, middlewareHandler, pluginerrsStore, pluginInstaller, ossImpl, cacheServiceImpl, userAuthTokenService, cleanUpService, shortURLService, queryHistoryService, correlationsService, remoteCache, provisioningServiceImpl, accessControl, dataSourceProxyService, searchSearchService, grafanaLive, gateway, plugincontextProvider, contexthandlerContextHandler, logger, featureToggles, alertNG, libraryPanelService, libraryElementService, quotaService, socialService, tracingService, serviceService, grafanaService, pluginsService, ossService, service15, queryServiceImpl, filestoreService, serviceAccountsProxy, pluginassetsService, authinfoimplService, storageService, notificationServiceMock, dashboardService, dashboardProvisioningService, folderimplService, ossProvider, serviceImpl, service13, avatarCacheServer, prefService, folderPermissionsService, dashboardPermissionsService, dashverService, starService, csrfCSRF, noop, playlistService, apikeyService, kvStore, secretsMigrator, secretsService, secretMigrationProviderImpl, secretsKVStore, apiApi, userService, tempuserService, loginattemptimplService, orgService, deletionService, teamService, acimplService, navtreeService, repositoryImpl, tagimplService, searchHTTPService, oauthtokentestService, statsService, authnService, pluginscdnService, gatherer, apiAPI, registerer, eventualRestConfigProvider, anonDeviceService, verifier, preinstallImpl)
	if err != nil {
		return nil, err
	}
	validatorService, err := validator3.ProvideService(pluginstoreService)
	if err != nil {
		return nil, err
	}
	sandboxService := sandbox.ProvideService(cfg)
	advisorService, err := advisor.ProvideService(cfg, eventualRestConfigProvider)
	if err != nil {
		return nil, err
	}
	statscollectorService := statscollector.ProvideService(usageStats, validatorService, statsService, cfg, sqlStore, socialService, pluginstoreService, featureManager, service15, httpclientProvider, sandboxService, advisorService)
	internalMetricsService, err := metrics.ProvideService(cfg, registerer, gatherer)
	if err != nil {
		return nil, err
	}
	supportbundlesimplService, err := supportbundlesimpl.ProvideService(accessControl, acimplService, bundleregistryService, cfg, featureToggles, httpServer, kvStore, service13, pluginstoreService, routeRegisterImpl, ossImpl, sqlStore, usageStats, tracingService)
	if err != nil {
		return nil, err
	}
	metricService, err := metric.ProvideService(publicDashboardStoreImpl, registerer)
	if err != nil {
		return nil, err
	}
	scopedPluginDatasourceProvider := datasource.ProvideDefaultPluginConfigs(service15, cacheServiceImpl, plugincontextProvider)
	v := builder.ProvideDefaultBuildHandlerChainFuncFromBuilders()
	aggregatorRunner := aggregatorrunner.ProvideNoopAggregatorConfigurator()
	playlistAppInstaller, err := playlist.RegisterAppInstaller(playlistService, cfg, featureToggles)
	if err != nil {
		return nil, err
	}
	pluginsAppInstaller, err := plugins.RegisterAppInstaller(cfg, featureToggles)
	if err != nil {
		return nil, err
	}
	shortURLAppInstaller, err := shorturl.RegisterAppInstaller(cfg, shortURLService)
	if err != nil {
		return nil, err
	}
	v2 := appregistry.ProvideAppInstallers(featureToggles, playlistAppInstaller, pluginsAppInstaller, shortURLAppInstaller)
	builderMetrics := builder.ProvideBuilderMetrics(registerer)
	apiserverService, err := apiserver.ProvideService(cfg, featureToggles, routeRegisterImpl, tracingService, serverLockService, sqlStore, kvStore, middlewareHandler, scopedPluginDatasourceProvider, plugincontextProvider, pluginstoreService, dualwriteService, resourceClient, inlineSecureValueSupport, eventualRestConfigProvider, v, eventualRestConfigProvider, registerer, aggregatorRunner, v2, builderMetrics)
	if err != nil {
		return nil, err
	}
	pluginexternalService, err := pluginexternal.ProvideService(cfg, pluginstoreService)
	if err != nil {
		return nil, err
	}
	plugininstallerService, err := plugininstaller.ProvideService(cfg, pluginstoreService, pluginInstaller, registerer, repoManager, featureToggles, plugincheckerService)
	if err != nil {
		return nil, err
	}
	zanzanaReconciler := dualwrite2.ProvideZanzanaReconciler(cfg, featureToggles, zanzanaClient, sqlStore, serverLockService, folderimplService)
	investigationsAppProvider := investigations.RegisterApp(cfg)
	checkregistryService := checkregistry.ProvideService(service15, pluginstoreService, plugincontextProvider, middlewareHandler, plugincheckerService, repoManager, preinstallImpl, noop, provisionedpluginsNoop, ssosettingsimplService, cfg, pluginerrsStore)
	advisorAppProvider := advisor2.RegisterApp(checkregistryService, cfg)
	alertingNotificationsAppProvider := notifications2.RegisterApp(cfg, alertNG)
	appregistryService, err := appregistry.ProvideBuilderRunners(apiserverService, eventualRestConfigProvider, featureToggles, investigationsAppProvider, advisorAppProvider, alertingNotificationsAppProvider, cfg)
	if err != nil {
		return nil, err
	}
	importDashboardService := service11.ProvideService(routeRegisterImpl, quotaService, service14, pluginstoreService, libraryPanelService, dashboardService, accessControl, folderimplService, featureToggles)
	dashboardUpdater := service8.ProvideDashboardUpdater(inProcBus, pluginstoreService, service14, importDashboardService, service13, pluginService, dashboardService)
	worker := garbagecollectionworker.ProvideWorker(cfg, secureValueMetadataStorage, keeperMetadataStorage, ossKeeperService)
	healthService, err := grpcserver.ProvideHealthService(cfg, grpcserverProvider)
	if err != nil {
		return nil, err
	}
	reflectionService, err := grpcserver.ProvideReflectionService(cfg, grpcserverProvider)
	if err != nil {
		return nil, err
	}
	ossGroups := ldap.ProvideGroupsService()
	identitySynchronizer := authnimpl.ProvideIdentitySynchronizer(authnimplService)
	ldapImpl := service12.ProvideService(cfg, featureToggles, ssosettingsimplService)
	apiService := api4.ProvideService(cfg, routeRegisterImpl, accessControl, userService, authinfoimplService, ossGroups, identitySynchronizer, orgService, ldapImpl, userAuthTokenService, bundleregistryService)
	dashboardsAPIBuilder := dashboard.RegisterAPIService(cfg, featureToggles, apiserverService, dashboardService, dashboardProvisioningService, pluginstoreService, service15, dashboardServiceImpl, dashboardPermissionsService, accessControl, accessClient, provisioningServiceImpl, dashboardsStore, registerer, sqlStore, tracingService, resourceClient, dualwriteService, sortService, quotaService, libraryPanelService, eventualRestConfigProvider, userService)
	snapshotsAPIBuilder := dashboardsnapshot.RegisterAPIService(serviceImpl, apiserverService, cfg, featureToggles, sqlStore, registerer)
	featureFlagAPIBuilder := featuretoggle.RegisterAPIService(featureManager, accessControl, apiserverService, cfg, registerer)
	dataSourceAPIBuilder, err := datasource.RegisterAPIService(featureToggles, apiserverService, middlewareHandler, scopedPluginDatasourceProvider, plugincontextProvider, pluginstoreService, accessControl, registerer)
	if err != nil {
		return nil, err
	}
	folderAPIBuilder := folders.RegisterAPIService(cfg, featureToggles, apiserverService, folderimplService, folderPermissionsService, accessControl, acimplService, accessClient, registerer, resourceClient, zanzanaClient)
	storageBackendImpl := noopstorage.ProvideStorageBackend()
	identityAccessManagementAPIBuilder, err := iam.RegisterAPIService(featureToggles, apiserverService, ssosettingsimplService, sqlStore, accessControl, accessClient, registerer, storageBackendImpl, storageBackendImpl)
	if err != nil {
		return nil, err
	}
	legacyDataSourceLookup := service9.ProvideLegacyDataSourceLookup(service15)
	queryAPIBuilder, err := query2.RegisterAPIService(cfg, featureToggles, apiserverService, service15, pluginstoreService, accessControl, middlewareHandler, plugincontextProvider, registerer, tracingService, legacyDataSourceLookup, exprService)
	if err != nil {
		return nil, err
	}
	userStorageAPIBuilder := userstorage.RegisterAPIService(featureToggles, apiserverService, registerer)
	apiBuilder := preferences.RegisterAPIService(cfg, featureToggles, sqlStore, prefService, starService, userService, apiserverService)
	legacyMigrator := legacy.ProvideLegacyMigrator(sqlStore, provisioningServiceImpl, libraryPanelService, dashboardPermissionsService, accessControl, featureToggles)
	webhookExtraBuilder := webhooks.ProvideWebhooks(cfg, renderingService, resourceClient, eventualRestConfigProvider)
	v3 := extras.ProvideProvisioningOSSExtras(webhookExtraBuilder)
	decryptAuthorizer := decrypt.ProvideDecryptAuthorizer(tracer)
	decryptStorage, err := metadata.ProvideDecryptStorage(tracer, ossKeeperService, keeperMetadataStorage, secureValueMetadataStorage, decryptAuthorizer, registerer)
	if err != nil {
		return nil, err
	}
	decryptService, err := decrypt.ProvideDecryptService(cfg, tracer, decryptStorage)
	if err != nil {
		return nil, err
	}
	factory := github.ProvideFactory()
	v4 := extras.ProvideProvisioningOSSRepositoryExtras(cfg, decryptService, factory, webhookExtraBuilder)
	repositoryFactory, err := repository.ProvideFactory(v4)
	if err != nil {
		return nil, err
	}
	provisioningAPIBuilder, err := provisioning2.RegisterAPIService(cfg, featureToggles, apiserverService, registerer, resourceClient, eventualRestConfigProvider, accessClient, legacyMigrator, dualwriteService, usageStats, tracingService, v3, repositoryFactory)
	if err != nil {
		return nil, err
	}
	ofrepAPIBuilder, err := ofrep.RegisterAPIService(apiserverService, cfg)
	if err != nil {
		return nil, err
	}
	secretDBMigrator := migrator2.NewWithEngine(sqlStore)
	dependencyRegisterer, err := secret.RegisterDependencies(featureToggles, cfg, secretDBMigrator, acimplService)
	if err != nil {
		return nil, err
	}
	apiregistryService := apiregistry.ProvideRegistryServiceSink(dashboardsAPIBuilder, snapshotsAPIBuilder, featureFlagAPIBuilder, dataSourceAPIBuilder, folderAPIBuilder, identityAccessManagementAPIBuilder, queryAPIBuilder, userStorageAPIBuilder, apiBuilder, provisioningAPIBuilder, ofrepAPIBuilder, dependencyRegisterer)
	teamPermissionsService, err := ossaccesscontrol.ProvideTeamPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	teamAPI := teamapi.ProvideTeamAPI(routeRegisterImpl, teamService, acimplService, accessControl, teamPermissionsService, userService, ossLicensingService, cfg, prefService, dashboardService, featureToggles)
	cloudmigrationService, err := cloudmigrationimpl.ProvideService(cfg, httpclientProvider, featureToggles, sqlStore, service15, secretsKVStore, secretsService, routeRegisterImpl, registerer, tracingService, dashboardService, folderimplService, pluginstoreService, service13, accessControl, acimplService, kvStore, libraryElementService, alertNG)
	if err != nil {
		return nil, err
	}
	authService, err := jwt.ProvideService(cfg, remoteCache)
	if err != nil {
		return nil, err
	}
	ossUserProtectionImpl := authinfoimpl.ProvideOSSUserProtectionService()
	registration := authnimpl.ProvideRegistration(cfg, authnService, orgService, userAuthTokenService, acimplService, permissionRegistry, apikeyService, userService, authService, ossUserProtectionImpl, loginattemptimplService, quotaService, authinfoimplService, renderingService, featureToggles, oauthtokentestService, socialService, remoteCache, ldapImpl, ossImpl, tracingService, tempuserService, notificationServiceMock)
	backgroundServiceRegistry := backgroundsvcs.ProvideBackgroundServiceRegistry(httpServer, alertNG, cleanUpService, grafanaLive, gateway, notificationService, pluginstoreService, renderingService, userAuthTokenService, tracingService, provisioningServiceImpl, usageStats, statscollectorService, grafanaService, pluginsService, internalMetricsService, secretsService, remoteCache, storageService, searchService, entityEventsService, serviceAccountsService, grpcserverProvider, secretMigrationProviderImpl, loginattemptimplService, supportbundlesimplService, metricService, keyRetriever, angulardetectorsproviderDynamic, apiserverService, anonDeviceService, ssosettingsimplService, pluginexternalService, plugininstallerService, zanzanaReconciler, appregistryService, dashboardUpdater, dashboardServiceImpl, worker, serviceImpl, serviceAccountsProxy, healthService, reflectionService, apiService, apiregistryService, idimplService, teamAPI, ssosettingsimplService, cloudmigrationService, registration)
	usageStatsProvidersRegistry := usagestatssvcs.ProvideUsageStatsProvidersRegistry(acimplService, userService)
	server, err := New(opts, cfg, httpServer, acimplService, provisioningServiceImpl, backgroundServiceRegistry, usageStatsProvidersRegistry, statscollectorService, registerer)
	if err != nil {
		return nil, err
	}
	testEnv, err := ProvideTestEnv(testingT, server, sqlStore, cfg, notificationServiceMock, grpcserverProvider, inMemory, httpclientProvider, oauthtokentestService, featureToggles, resourceClient, idimplService, factory, decryptService)
	if err != nil {
		return nil, err
	}
	return testEnv, nil
}

func InitializeForCLI(ctx context.Context, cfg *setting.Cfg) (Runner, error) {
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return Runner{}, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	ossMigrations := migrations.ProvideOSSMigrations(featureToggles)
	tracingConfig, err := tracing.ProvideTracingConfig(cfg)
	if err != nil {
		return Runner{}, err
	}
	tracingService, err := tracing.ProvideService(tracingConfig)
	if err != nil {
		return Runner{}, err
	}
	inProcBus := bus.ProvideBus(tracingService)
	sqlStore, err := sqlstore.ProvideService(cfg, featureToggles, ossMigrations, inProcBus, tracingService)
	if err != nil {
		return Runner{}, err
	}
	ossImpl := setting.ProvideProvider(cfg)
	providerProvider := provider.ProvideEncryptionProvider()
	kvStore := kvstore.ProvideService(sqlStore)
	routeRegisterImpl := routing.ProvideRegister()
	accessControl := acimpl.ProvideAccessControl(featureToggles)
	bundleregistryService := bundleregistry.ProvideService()
	usageStats, err := service.ProvideService(cfg, kvStore, routeRegisterImpl, tracingService, accessControl, bundleregistryService)
	if err != nil {
		return Runner{}, err
	}
	serviceService, err := service2.ProvideEncryptionService(tracingService, providerProvider, usageStats, cfg)
	if err != nil {
		return Runner{}, err
	}
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	osskmsprovidersService := osskmsproviders.ProvideService(serviceService, cfg, featureToggles)
	secretsService, err := manager.ProvideSecretsService(tracingService, secretsStoreImpl, osskmsprovidersService, serviceService, cfg, featureToggles, usageStats)
	if err != nil {
		return Runner{}, err
	}
	secretsMigrator := migrator.ProvideSecretsMigrator(serviceService, secretsService, sqlStore, ossImpl, featureToggles)
	configProvider, err := configprovider.ProvideService(cfg)
	if err != nil {
		return Runner{}, err
	}
	quotaService := quotaimpl.ProvideService(ctx, sqlStore, configProvider)
	orgService, err := orgimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return Runner{}, err
	}
	teamService, err := teamimpl.ProvideService(sqlStore, cfg, tracingService)
	if err != nil {
		return Runner{}, err
	}
	cacheService := localcache.ProvideService()
	userService, err := userimpl.ProvideService(sqlStore, orgService, cfg, teamService, cacheService, tracingService, quotaService, bundleregistryService)
	if err != nil {
		return Runner{}, err
	}
	tracer := otelTracer()
	databaseDatabase := database4.ProvideDatabase(sqlStore, tracer)
	registerer := metrics.ProvideRegisterer()
	globalDataKeyStorage, err := encryption.ProvideGlobalDataKeyStorage(databaseDatabase, tracer, registerer)
	if err != nil {
		return Runner{}, err
	}
	encryptedValueStorage, err := encryption.ProvideEncryptedValueStorage(databaseDatabase, tracer)
	if err != nil {
		return Runner{}, err
	}
	globalEncryptedValueStorage, err := encryption.ProvideGlobalEncryptedValueStorage(databaseDatabase, tracer)
	if err != nil {
		return Runner{}, err
	}
	dataKeyStorage, err := encryption.ProvideDataKeyStorage(databaseDatabase, tracer, registerer)
	if err != nil {
		return Runner{}, err
	}
	cipher, err := service4.ProvideAESGCMCipherService(tracer, usageStats)
	if err != nil {
		return Runner{}, err
	}
	providerConfig, err := kmsproviders.ProvideOSSKMSProviders(cfg, cipher)
	if err != nil {
		return Runner{}, err
	}
	encryptionManager, err := manager2.ProvideEncryptionManager(tracer, dataKeyStorage, usageStats, cipher, providerConfig)
	if err != nil {
		return Runner{}, err
	}
	consolidationService := service5.ProvideConsolidationService(tracer, globalDataKeyStorage, encryptedValueStorage, globalEncryptedValueStorage, encryptionManager)
	runner := NewRunner(cfg, sqlStore, ossImpl, serviceService, featureToggles, secretsService, secretsMigrator, userService, consolidationService)
	return runner, nil
}

// InitializeForCLITarget is a simplified set of dependencies for the CLI, used
// by the server target subcommand to launch specific dskit modules.
func InitializeForCLITarget(ctx context.Context, cfg *setting.Cfg) (ModuleRunner, error) {
	ossImpl := setting.ProvideProvider(cfg)
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return ModuleRunner{}, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	moduleRunner := NewModuleRunner(cfg, ossImpl, featureToggles)
	return moduleRunner, nil
}

// InitializeModuleServer is a simplified set of dependencies for the CLI,
// suitable for running background services and targeting dskit modules.
func InitializeModuleServer(cfg *setting.Cfg, opts Options, apiOpts api.ServerOptions) (*ModuleServer, error) {
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	registerer := metrics.ProvideRegisterer()
	storageMetrics := resource.ProvideStorageMetrics(registerer)
	bleveIndexMetrics := resource.ProvideIndexMetrics(registerer)
	gatherer := metrics.ProvideGatherer()
	tracingConfig, err := tracing.ProvideTracingConfig(cfg)
	if err != nil {
		return nil, err
	}
	tracingService, err := tracing.ProvideService(tracingConfig)
	if err != nil {
		return nil, err
	}
	hooksService := hooks.ProvideService()
	ossLicensingService := licensing.ProvideService(cfg, hooksService)
	moduleServer, err := NewModule(opts, apiOpts, featureToggles, cfg, storageMetrics, bleveIndexMetrics, registerer, gatherer, tracingService, ossLicensingService)
	if err != nil {
		return nil, err
	}
	return moduleServer, nil
}

// Initialize the standalone APIServer factory
func InitializeAPIServerFactory() (standalone.APIServerFactory, error) {
	apiServerFactory := standalone.ProvideAPIServerFactory()
	return apiServerFactory, nil
}

func InitializeDocumentBuilders(cfg *setting.Cfg) (resource.DocumentBuilderSupplier, error) {
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	ossMigrations := migrations.ProvideOSSMigrations(featureToggles)
	tracingConfig, err := tracing.ProvideTracingConfig(cfg)
	if err != nil {
		return nil, err
	}
	tracingService, err := tracing.ProvideService(tracingConfig)
	if err != nil {
		return nil, err
	}
	inProcBus := bus.ProvideBus(tracingService)
	sqlStore, err := sqlstore.ProvideService(cfg, featureToggles, ossMigrations, inProcBus, tracingService)
	if err != nil {
		return nil, err
	}
	ossDashboardStats := search.ProvideDashboardStats()
	documentBuilderSupplier := search.ProvideDocumentBuilders(sqlStore, ossDashboardStats)
	return documentBuilderSupplier, nil
}

// wire.go:

func otelTracer() trace.Tracer {
	return otel.GetTracerProvider().Tracer("grafana")
}

var withOTelSet = wire.NewSet(
	otelTracer, grpcserver.ProvideService, interceptors.ProvideAuthenticator,
)

var wireBasicSet = wire.NewSet(annotationsimpl.ProvideService, wire.Bind(new(annotations.Repository), new(*annotationsimpl.RepositoryImpl)), New, api.ProvideHTTPServer, query.ProvideService, wire.Bind(new(query.Service), new(*query.ServiceImpl)), bus.ProvideBus, wire.Bind(new(bus.Bus), new(*bus.InProcBus)), rendering.ProvideService, wire.Bind(new(rendering.Service), new(*rendering.RenderingService)), routing.ProvideRegister, wire.Bind(new(routing.RouteRegister), new(*routing.RouteRegisterImpl)), hooks.ProvideService, kvstore.ProvideService, localcache.ProvideService, bundleregistry.ProvideService, wire.Bind(new(supportbundles.Service), new(*bundleregistry.Service)), updatemanager.ProvideGrafanaService, updatemanager.ProvidePluginsService, service.ProvideService, wire.Bind(new(usagestats.Service), new(*service.UsageStats)), validator3.ProvideService, legacy.ProvideLegacyMigrator, pluginsintegration.WireSet, dashboards.ProvideFileStoreManager, wire.Bind(new(dashboards.FileStore), new(*dashboards.FileStoreManager)), cloudwatch.ProvideService, cloudmonitoring.ProvideService, azuremonitor.ProvideService, postgres.ProvideService, mysql.ProvideService, mssql.ProvideService, store.ProvideEntityEventsService, dualwrite.ProvideService, httpclientprovider.New, wire.Bind(new(httpclient.Provider), new(*httpclient2.Provider)), serverlock.ProvideService, annotationsimpl.ProvideCleanupService, wire.Bind(new(annotations.Cleaner), new(*annotationsimpl.CleanupServiceImpl)), cleanup.ProvideService, shorturlimpl.ProvideService, wire.Bind(new(shorturls.Service), new(*shorturlimpl.ShortURLService)), queryhistory.ProvideService, wire.Bind(new(queryhistory.Service), new(*queryhistory.QueryHistoryService)), correlations.ProvideService, wire.Bind(new(correlations.Service), new(*correlations.CorrelationsService)), quotaimpl.ProvideService, remotecache.ProvideService, wire.Bind(new(remotecache.CacheStorage), new(*remotecache.RemoteCache)), authinfoimpl.ProvideService, wire.Bind(new(login.AuthInfoService), new(*authinfoimpl.Service)), authinfoimpl.ProvideStore, datasourceproxy.ProvideService, sort.ProvideService, search2.ProvideService, searchV2.ProvideService, searchV2.ProvideSearchHTTPService, store.ProvideService, store.ProvideSystemUsersService, live.ProvideService, pushhttp.ProvideService, contexthandler.ProvideService, service12.ProvideService, wire.Bind(new(service12.LDAP), new(*service12.LDAPImpl)), jwt.ProvideService, wire.Bind(new(jwt.JWTService), new(*jwt.AuthService)), store2.ProvideDBStore, image.ProvideDeleteExpiredService, ngalert.ProvideService, librarypanels.ProvideService, wire.Bind(new(librarypanels.Service), new(*librarypanels.LibraryPanelService)), libraryelements.ProvideService, wire.Bind(new(libraryelements.Service), new(*libraryelements.LibraryElementService)), notifications.ProvideService, notifications.ProvideSmtpService, github.ProvideFactory, tracing.ProvideService, tracing.ProvideTracingConfig, wire.Bind(new(tracing.Tracer), new(*tracing.TracingService)), withOTelSet, testdatasource.ProvideService, api4.ProvideService, opentsdb.ProvideService, socialimpl.ProvideService, influxdb.ProvideService, wire.Bind(new(social.Service), new(*socialimpl.SocialService)), tempo.ProvideService, loki.ProvideService, graphite.ProvideService, prometheus.ProvideService, elasticsearch.ProvideService, pyroscope.ProvideService, parca.ProvideService, zipkin.ProvideService, jaeger.ProvideService, service9.ProvideCacheService, wire.Bind(new(datasources.CacheService), new(*service9.CacheServiceImpl)), service2.ProvideEncryptionService, wire.Bind(new(encryption2.Internal), new(*service2.Service)), manager.ProvideSecretsService, wire.Bind(new(secrets.Service), new(*manager.SecretsService)), database.ProvideSecretsStore, wire.Bind(new(secrets.Store), new(*database.SecretsStoreImpl)), garbagecollectionworker.ProvideWorker, grafanads.ProvideService, wire.Bind(new(dashboardsnapshots.Store), new(*database5.DashboardSnapshotStore)), database5.ProvideStore, wire.Bind(new(dashboardsnapshots.Service), new(*service10.ServiceImpl)), service10.ProvideService, service9.ProvideService, wire.Bind(new(datasources.DataSourceService), new(*service9.Service)), service9.ProvideLegacyDataSourceLookup, retriever.ProvideService, wire.Bind(new(serviceaccounts.ServiceAccountRetriever), new(*retriever.Service)), ossaccesscontrol.ProvideServiceAccountPermissions, wire.Bind(new(accesscontrol.ServiceAccountPermissionsService), new(*ossaccesscontrol.ServiceAccountPermissionsService)), manager3.ProvideServiceAccountsService, proxy.ProvideServiceAccountsProxy, wire.Bind(new(serviceaccounts.Service), new(*proxy.ServiceAccountsProxy)), dsquerierclient.NewNullQSDatasourceClientBuilder, expr.ProvideService, featuremgmt.ProvideManagerService, featuremgmt.ProvideToggles, service7.ProvideDashboardServiceImpl, wire.Bind(new(dashboards2.PermissionsRegistrationService), new(*service7.DashboardServiceImpl)), service7.ProvideDashboardService, service7.ProvideDashboardProvisioningService, service7.ProvideDashboardPluginService, database2.ProvideDashboardStore, folderimpl.ProvideService, wire.Bind(new(folder.Service), new(*folderimpl.Service)), wire.Bind(new(folder.LegacyService), new(*folderimpl.Service)), folderimpl.ProvideStore, wire.Bind(new(folder.Store), new(*folderimpl.FolderStoreImpl)), service11.ProvideService, wire.Bind(new(dashboardimport.Service), new(*service11.ImportDashboardService)), service8.ProvideService, wire.Bind(new(plugindashboards.Service), new(*service8.Service)), service8.ProvideDashboardUpdater, kvstore2.ProvideService, avatar.ProvideAvatarCacheServer, statscollector.ProvideService, csrf.ProvideCSRFFilter, wire.Bind(new(csrf.Service), new(*csrf.CSRF)), ossaccesscontrol.ProvideTeamPermissions, wire.Bind(new(accesscontrol.TeamPermissionsService), new(*ossaccesscontrol.TeamPermissionsService)), ossaccesscontrol.ProvideFolderPermissions, wire.Bind(new(accesscontrol.FolderPermissionsService), new(*ossaccesscontrol.FolderPermissionsService)), ossaccesscontrol.ProvideDashboardPermissions, wire.Bind(new(accesscontrol.DashboardPermissionsService), new(*ossaccesscontrol.DashboardPermissionsService)), ossaccesscontrol.ProvideReceiverPermissionsService, wire.Bind(new(accesscontrol.ReceiverPermissionsService), new(*ossaccesscontrol.ReceiverPermissionsService)), starimpl.ProvideService, playlistimpl.ProvideService, apikeyimpl.ProvideService, dashverimpl.ProvideService, service3.ProvideService, wire.Bind(new(publicdashboards.Service), new(*service3.PublicDashboardServiceImpl)), database3.ProvideStore, wire.Bind(new(publicdashboards.Store), new(*database3.PublicDashboardStoreImpl)), metric.ProvideService, api2.ProvideApi, api3.ProvideApi, userimpl.ProvideService, orgimpl.ProvideService, orgimpl.ProvideDeletionService, statsimpl.ProvideService, grpccontext.ProvideContextHandler, grpcserver.ProvideHealthService, grpcserver.ProvideReflectionService, resolver.ProvideEntityReferenceResolver, teamimpl.ProvideService, teamapi.ProvideTeamAPI, tempuserimpl.ProvideService, loginattemptimpl.ProvideService, wire.Bind(new(loginattempt.Service), new(*loginattemptimpl.Service)), migrations2.ProvideDataSourceMigrationService, migrations2.ProvideSecretMigrationProvider, wire.Bind(new(migrations2.SecretMigrationProvider), new(*migrations2.SecretMigrationProviderImpl)), promtypemigration.ProvideAzurePromMigrationService, promtypemigration.ProvideAmazonPromMigrationService, promtypemigration.ProvidePromTypeMigrationProvider, wire.Bind(new(promtypemigration.PromTypeMigrationProvider), new(*promtypemigration.PromTypeMigrationProviderImpl)), resourcepermissions.NewActionSetService, wire.Bind(new(accesscontrol.ActionResolver), new(resourcepermissions.ActionSetService)), wire.Bind(new(pluginaccesscontrol.ActionSetRegistry), new(resourcepermissions.ActionSetService)), permreg.ProvidePermissionRegistry, acimpl.ProvideAccessControl, dualwrite2.ProvideZanzanaReconciler, navtreeimpl.ProvideService, wire.Bind(new(accesscontrol.AccessControl), new(*acimpl.AccessControl)), wire.Bind(new(notifications.TempUserStore), new(tempuser.Service)), tagimpl.ProvideService, wire.Bind(new(tag.Service), new(*tagimpl.Service)), authnimpl.ProvideService, authnimpl.ProvideIdentitySynchronizer, authnimpl.ProvideAuthnService, authnimpl.ProvideAuthnServiceAuthenticateOnly, authnimpl.ProvideRegistration, supportbundlesimpl.ProvideService, extsvcaccounts.ProvideExtSvcAccountsService, wire.Bind(new(serviceaccounts.ExtSvcAccountsService), new(*extsvcaccounts.ExtSvcAccountsService)), registry2.ProvideExtSvcRegistry, wire.Bind(new(extsvcauth.ExternalServiceRegistry), new(*registry2.Registry)), anonstore.ProvideAnonDBStore, wire.Bind(new(anonstore.AnonStore), new(*anonstore.AnonDBStore)), loggermw.Provide, slogadapter.Provide, signingkeysimpl.ProvideEmbeddedSigningKeysService, wire.Bind(new(signingkeys.Service), new(*signingkeysimpl.Service)), ssosettingsimpl.ProvideService, wire.Bind(new(ssosettings.Service), new(*ssosettingsimpl.Service)), idimpl.ProvideService, wire.Bind(new(auth.IDService), new(*idimpl.Service)), cloudmigrationimpl.ProvideService, userimpl.ProvideVerifier, connectors.ProvideOrgRoleMapper, wire.Bind(new(user.Verifier), new(*userimpl.Verifier)), authz.WireSet, metadata.ProvideSecureValueMetadataStorage, metadata.ProvideKeeperMetadataStorage, metadata.ProvideDecryptStorage, decrypt.ProvideDecryptAuthorizer, decrypt.ProvideDecryptService, inline.ProvideInlineSecureValueService, encryption.ProvideDataKeyStorage, encryption.ProvideGlobalDataKeyStorage, encryption.ProvideEncryptedValueStorage, encryption.ProvideGlobalEncryptedValueStorage, service5.ProvideSecureValueService, validator.ProvideKeeperValidator, validator.ProvideSecureValueValidator, mutator.ProvideKeeperMutator, mutator.ProvideSecureValueMutator, migrator2.NewWithEngine, database4.ProvideDatabase, clock.ProvideClock, wire.Bind(new(contracts.Database), new(*database4.Database)), wire.Bind(new(contracts.Clock), new(*clock.Clock)), manager2.ProvideEncryptionManager, service4.ProvideAESGCMCipherService, resource.ProvideStorageMetrics, resource.ProvideIndexMetrics, apiserver.WireSet, apiregistry.WireSet, appregistry.WireSet, client.ProvideK8sClientWithFallback)

var wireSet = wire.NewSet(
	wireBasicSet, metrics.WireSet, sqlstore.ProvideService, metrics2.ProvideService, wire.Bind(new(notifications.Service), new(*notifications.NotificationService)), wire.Bind(new(notifications.WebhookSender), new(*notifications.NotificationService)), wire.Bind(new(notifications.EmailSender), new(*notifications.NotificationService)), wire.Bind(new(db.DB), new(*sqlstore.SQLStore)), prefimpl.ProvideService, oauthtoken.ProvideService, wire.Bind(new(oauthtoken.OAuthTokenService), new(*oauthtoken.Service)), wire.Bind(new(cleanup.AlertRuleService), new(*store2.DBstore)),
)

var wireCLISet = wire.NewSet(
	NewRunner,
	wireBasicSet, metrics.WireSet, sqlstore.ProvideService, metrics2.ProvideService, wire.Bind(new(notifications.Service), new(*notifications.NotificationService)), wire.Bind(new(notifications.WebhookSender), new(*notifications.NotificationService)), wire.Bind(new(notifications.EmailSender), new(*notifications.NotificationService)), wire.Bind(new(db.DB), new(*sqlstore.SQLStore)), prefimpl.ProvideService, oauthtoken.ProvideService, wire.Bind(new(oauthtoken.OAuthTokenService), new(*oauthtoken.Service)),
)

var wireTestSet = wire.NewSet(
	wireBasicSet,
	ProvideTestEnv, metrics.WireSetForTest, sqlstore.ProvideServiceForTests, metrics2.ProvideServiceForTest, notifications.MockNotificationService, wire.Bind(new(notifications.Service), new(*notifications.NotificationServiceMock)), wire.Bind(new(notifications.WebhookSender), new(*notifications.NotificationServiceMock)), wire.Bind(new(notifications.EmailSender), new(*notifications.NotificationServiceMock)), wire.Bind(new(db.DB), new(*sqlstore.SQLStore)), prefimpl.ProvideService, oauthtoken.ProvideService, oauthtokentest.ProvideService, wire.Bind(new(oauthtoken.OAuthTokenService), new(*oauthtokentest.Service)), wire.Bind(new(cleanup.AlertRuleService), new(*store2.DBstore)),
)
