---
stage: Software Supply Chain Security
group: Compliance
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 監査イベント
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

セキュリティ監査イベントは、インフラストラクチャの詳細な分析とレビューであり、懸念事項や潜在的に危険なプラクティスを表示するために使用されます。監査イベントプロセスを支援するために、GitLabは、GitLab内でさまざまなアクションを追跡できる監査イベントを提供します。GitLabは、オーナーと管理者が包括的なレポートを生成することで、監査担当者に対応できるよう支援します。これらのレポートは、ニーズに応じてスコープが異なります。

たとえば、監査イベントを使用して以下を追跡できます:

- GitLabプロジェクトの特定のユーザーの権限レベルを誰がいつ変更したか。
- 新しいユーザーを誰がいつ追加または削除したか。

これらの監査イベントは、リスクの評価、セキュリティ対策の強化、インシデントへの対応、コンプライアンスの遵守に関する監査に使用できます。GitLabが提供する監査イベントの完全なリストについては、[監査イベントのタイプ](audit_event_types.md)を参照してください。例: 

- 特定のログ機能の証拠をリクエストする外部監査人に提供するために、監査イベントのレポートを生成します。
- 監査担当者が組織のアクセスマネジメントポリシーへのコンプライアンスを検証できるように、四半期ごとのアクセスレビューのために、グループおよびプロジェクトのメンバーシップを示すすべてのユーザーのレポートを提供します。

監査イベントは無期限に保持されます。保持期間がないため、すべての監査イベントが利用可能です。

## 前提要件 {#prerequisites}

特定のタイプの監査イベントを表示するには、最小限のロールが必要です。

- グループ内のすべてのユーザーのグループ監査イベントを表示するには、グループの[オーナーロール](../permissions.md#roles)が必要です。
- プロジェクト内のすべてのユーザーのプロジェクト監査イベントを表示するには、少なくともプロジェクトの[メンテナーロール](../permissions.md#roles)が必要です。
- グループまたはプロジェクトでの自分のアクションに基づいてグループおよびプロジェクトの監査イベントを表示するには、グループまたはプロジェクトの少なくとも[デベロッパーロール](../permissions.md#roles)が必要です。

[監査担当者アクセスレベル](../../administration/auditor_users.md)のユーザーは、すべてのユーザーのグループとプロジェクトのイベントを表示できます。

## 監査イベントの表示 {#viewing-audit-events}

監査イベントは、グループ、プロジェクト、インスタンス、およびサインインレベルで表示できます。各レベルには、ログに記録する異なる監査イベントがあります。

### サインイン監査イベント {#sign-in-audit-events}

サインインに成功したイベントは、すべての階層で利用できる唯一の監査イベントです。サインインに成功したイベントを表示するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集** > **認証ログ**を選択します。
有料の階層にアップグレードした後、監査イベントページでサインインに成功したイベントも確認できます。

### グループ監査イベント {#group-audit-events}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループの監査イベントを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **監査イベント**を選択します。
1. アクションを実行したプロジェクトのメンバー（ユーザー）と日付範囲で監査イベントを絞り込みます。

グループ監査イベントは、[グループ監査イベントAPI](../../api/audit_events.md#group-audit-events)を使用してアクセスすることもできます。グループ監査イベントクエリ`created_after`および`created_before`パラメータは、日付間の最大30日の差に制限されています。

### プロジェクト監査イベント {#project-audit-events}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **監査イベント**を選択します。
1. アクションを実行したプロジェクトのメンバー（ユーザー）と日付範囲で監査イベントを絞り込みます。

プロジェクト監査イベントは、[プロジェクト監査イベントAPI](../../api/audit_events.md#project-audit-events)を使用してアクセスすることもできます。プロジェクト監査イベントクエリ`created_after`および`created_before`パラメータは、日付間の最大30日の差に制限されています。

## タイムゾーン {#time-zones}

{{< history >}}

- [導入](https://gitlab.com/gitlab-org/gitlab/-/issues/242014) in GitLab 15.7では、GitLab UIは、日付と時刻をUTCの代わりにユーザーのローカルタイムゾーンで表示します。

{{< /history >}}

監査イベントに使用されるタイムゾーンは、表示場所によって異なります:

- GitLab UIでは、ローカルタイムゾーンが使用されます。
- [監査イベントAPI](../../api/audit_events.md)は、デフォルトでUTCの日付と時刻、またはGitLabセルフマネージドの[構成済みのタイムゾーン](../../administration/timezone.md)で日付と時刻を返します。
- CSVエクスポートでは、UTCが使用されます。

## 既知の問題 {#known-issues}

監査イベントインターフェースには、検索機能が制限されています。監査イベントの詳細でのテキストベースの検索はサポートされていません。監査イベントは以下でのみ絞り込むことができます:

- メンバーイベント: アクションを実行した作成者。
- 日付範囲: 最大30日間のローリング期間。

監査イベントレポートのユーザービリティの展開は、[エピック418](https://gitlab.com/groups/gitlab-org/-/epics/418)で提案されています。

監査イベントの高度な検索と分析については、包括的なテキスト検索と分析を実行できる外部の場所に[ストリーミング監査イベント](audit_event_streaming.md)を検討してください。

## 監査イベントにコントリビュートする {#contribute-to-audit-events}

いずれかのエピックに必要なイベントが表示されない場合は、次のいずれかを実行できます:

- 監査イベント提案イシューテンプレートを使用して、[イシューを作成](https://gitlab.com/gitlab-org/gitlab/-/issues/new?issuable_template=Audit%20Event%20Proposal)してリクエストします。
- GitLabにコントリビュートして、イベントを追加します。

## 管理者トピックの管理 {#administer-topics}

インスタンスの管理者は、**管理者**エリアから[管理者監査イベントを管理](../../administration/compliance/audit_event_reports.md)できます。
