---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 強化 - 一般的な概念
---

一般的な強化のガイドラインは、[main hardening documentation](hardening.md)に概説されています。

次のドキュメントでは、GitLabインスタンスの強化に関する、いくつかの基本的な考え方をまとめています。多くの場合、これらはすべてのコンピューターシステムに実際に適用できます。

## 多層防御 {#layered-security}

セキュリティを実装する方法が2つある場合は、1つだけではなく、両方の方法を実装する必要があります。簡単な例として、アカウントセキュリティがあります:

- アカウントには、長く、複雑で、ユニークなパスワードを使用します。
- セキュリティを強化するために、認証プロセスに第2の要素を実装します。
- ハードウェアトークンを第2の要素として使用します。
- 認証に失敗した場合、アカウントを（少なくとも一定期間）ロックアウトします。
- 特定の期間使用されていないアカウントは無効にする必要があります。自動化または定期的な監査のいずれかでこれを適用します。

リストの1つまたは2つの項目のみを使用する代わりに、できるだけ多く使用します。この考え方は、アカウントセキュリティ以外の分野にも適用でき、可能なすべての分野に適用する必要があります。

## 曖昧さ回避によるセキュリティの排除 {#eliminate-security-through-obscurity}

曖昧さ回避によるセキュリティとは、潜在的な攻撃者が攻撃を考案するためにこれらの詳細を使用する可能性があるという恐れから、システム、サービス、またはプロセスの特定の要素について議論しないことを意味します。代わりに、システムの設定に関する詳細が公開されても、システムができる限り安全であるように、システムを保護する必要があります。本質的に、攻撃者がコンピューターシステムの設定の詳細を知っても、それらに有利になることはありません。曖昧さ回避によるセキュリティの欠点の1つは、システムの管理者がシステムが実際よりも安全であると考えているため、潜在的に誤ったセキュリティ意識につながる可能性があることです。

この例として、標準外のTCPポートでサービスを実行することがあります。たとえば、サーバー上のデフォルトのSSHデーモンポートはTCPポート22ですが、TCPポート2222などの別のポートで実行するように設定できます。これを設定した管理者は、システムのセキュリティが向上すると考えるかもしれませんが、攻撃者がシステムをポートスキャンしてすべてのオープンポートを検出し、SSHサービスを迅速に発見し、認識されているセキュリティ上の利点を排除することは非常に一般的です。

GitLabはオープンコアシステムであり、すべての設定オプションは十分に文書化されており、公開されている情報であるため、曖昧さ回避によるセキュリティの考え方は、GitLabのコアバリューである透明性に反します。これらの強化に関する推奨事項は、曖昧さ回避によるセキュリティを排除するために、公開されることを目的としています。

## アタックサーフェスの削減 {#attack-surface-reduction}

GitLabは、多くのコンポーネントを備えた大規模なシステムです。セキュリティに関する一般的なルールとして、未使用のシステムを無効にすると役立ちます。これにより、潜在的な攻撃者が攻撃に使用できる利用可能な「アタックサーフェス」が排除されます。これにより、利用可能なシステムリソースを増やすという追加の利点もあります。

例として、5分ごとに入力のキューを起動してチェックし、チェックを実行しながら複数のサブプロセスにクエリを実行するシステム上のプロセスがあります。そのプロセスを使用していない場合は、それを設定する理由がなく、無効にする必要があります。攻撃者がこのプロセスを使用する脅威ベクターを把握している場合、組織がそれを使用していなくても、攻撃者はそれを悪用する可能性があります。一般的なルールとして、使用されていないサービスはすべて無効にする必要があります。

## 外部システム {#external-systems}

より大規模で、それでも強化されたデプロイでは、複数のノードが、GitLabデプロイに必要な負荷を処理するために使用されることがよくあります。そのような場合は、ファイアウォールルールに、外部、オペレーティングシステム、および設定オプションの組み合わせを使用します。制限を使用するオプションは、サブシステムが機能するのに十分な範囲でのみ開く必要があります。可能な限り、ネットワークトラフィックにTLS暗号化を使用します。
