# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Gitlab::BackgroundMigration::BackfillOccurrenceIdToVulnerabilitySeverityOverrides, feature_category: :vulnerability_management do
  it_behaves_like 'backfills occurrence id from vulnerabilities' do
    let(:batch_table) { :vulnerability_severity_overrides }
    let!(:record) do
      model.create!(
        created_at: now,
        updated_at: now,
        author_id: user.id,
        vulnerability_id: vulnerability.id,
        project_id: project.id,
        original_severity: 1,
        new_severity: 2
      )
    end
  end
end
