# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    class BackfillOccurrenceIdToVulnerabilityAssociations < BatchedMigrationJob
      feature_category :vulnerability_management

      def perform
        each_sub_batch do |sub_batch|
          connection.exec_update(update_sql(sub_batch))
        end
      end

      def update_sql(sub_batch)
        <<~SQL
        UPDATE
          #{batch_table}
        SET
          vulnerability_occurrence_id = vulnerabilities.finding_id
        FROM
          vulnerabilities
        WHERE
          vulnerabilities.id IN (#{sub_batch.select(:vulnerability_id).to_sql}) AND
          vulnerabilities.id = #{batch_table}.vulnerability_id AND
          #{batch_table}.vulnerability_occurrence_id IS NULL
        SQL
      end
    end
  end
end
