---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Vulnerability management policy
description: Define and enforce vulnerability management policies in GitLab to auto-resolve vulnerabilities, reduce triage workload, and ensure consistent remediation
---

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/5708) support for enforcing policies on projects in GitLab 17.7 [with a flag](../../../administration/feature_flags/_index.md) named `vulnerability_management_policy_type`. Enabled by default.
- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/15697) support for enforcing policies on groups in GitLab 17.8 for the group-level [with a flag](../../../administration/feature_flags/_index.md) named `vulnerability_management_policy_type_group`. Enabled by default.
- [Generally available](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178031) in GitLab 17.9. Feature flags `vulnerability_management_policy_type` and `vulnerability_management_policy_type_group` removed.

{{< /history >}}

Use a vulnerability management policy to automatically resolve vulnerabilities that are no longer
detected. This can help reduce the workload of triaging vulnerabilities.

When a scanner detects a vulnerability on the default branch, the scanner creates a vulnerability
record with the status **Needs triage**. After the vulnerability has been remediated and the next
security scan runs, the scan adds **No longer detected** to the record's activity log but the
record's status does not change. You can change the status to **Resolved** either
[manually](../vulnerabilities/_index.md#change-the-status-of-a-vulnerability) or by using a
vulnerability management policy.

Using a vulnerability management policy ensures rules are applied consistently. For example, you can
create a policy that marks as resolved those vulnerabilities that are no longer detected on the default
branch, but only those created by SAST and are of low risk. The vulnerability management policy
only affects vulnerabilities with the status **Needs triage** or **Confirmed**.

The vulnerability management policy is applied when a pipeline runs against the default branch.
For each vulnerability that is no longer detected by the same scanner and matches the policy's rules:

- The vulnerability record's status is set to **Resolved** by the **GitLab Security Policy Bot**
  user.
- A note about the status change is added to the vulnerability's record.

To limit the pipeline load and duration, a maximum of 1,000 vulnerabilities per pipeline are set to
status **Resolved**. This repeats in each pipeline until all vulnerabilities that are no longer
detected are marked **Resolved**.

## Restrictions

- You can assign a maximum of five rules to each policy.
- You can assign a maximum of five vulnerability management policies to each security policy project.
- When a secret detection scan finds that a previously detected secret key is no longer detected,
  the vulnerability is not auto-resolved. Instead, it remains in **Needs Triage** because the removed
  secret key has already been exposed. The vulnerability status should be manually resolved only after
  the secret key is revoked or rotated.

## Create a vulnerability management policy

Create a vulnerability management policy to automatically resolve vulnerabilities matching specific
criteria.

Prerequisites:

- By default, only group, subgroup, or project Owners have the permissions required to create or
  assign a security policy project. This can be changed using
  [custom roles](../../custom_roles/_index.md).

To create a vulnerability management policy:

1. On the top bar, select **Search or go to** and find your project.
1. Go to **Secure** > **Policies**.
1. Select **New policy**.
1. In **Vulnerability management policy**, select **Select policy**.
1. Complete the fields and set the policy's status to **Enabled**.
1. Select **Create policy**.
1. Review and merge the merge request.

After the vulnerability management policy has been created, the policy rules are applied to
pipelines on the default branch.

## Edit a vulnerability management policy

Edit a vulnerability management policy to change its rules.

1. On the top bar, select **Search or go to** and find your project.
1. Go to **Secure** > **Policies**.
1. In the policy's row, select **Edit**.
1. Edit the policy's details.
1. Select **Save changes**.
1. Review and merge the merge request.

The vulnerability management policy has been updated. When a pipeline next runs against the default
branch, the policy's rules are applied.

### Schema

When a vulnerability management policy is created or edited, it's checked against the
[vulnerability management policy schema](vulnerability_management_policy_schema.md) to confirm it's
valid.
