---
stage: ModelOps
group: MLOps
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 機械学習モデル検証
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.11で[導入](https://gitlab.com/groups/gitlab-org/-/epics/9341)されました。
- GitLab 17.8で[一般提供](https://gitlab.com/groups/gitlab-org/-/epics/9341)になりました。

{{< /history >}}

機械学習モデルを作成する際に、モデルのパフォーマンスを向上させるために、さまざまなパラメータ、設定、および特徴量エンジニアリングを試す可能性があります。後で実験をレプリケートするには、メタデータとアーティファクトを効果的に追跡する必要があります。GitLabのモデル検証を使用して、パラメータ、メトリクス、およびアーティファクトをGitLabに直接追跡およびログ記録します。

## 実験とは何ですか？ {#what-is-an-experiment}

プロジェクトでは、実験は、比較可能なモデル実行のコレクションです。実験は、長期にわたる場合（たとえば、ユースケースを表す場合）や、短期的な場合（マージリクエストによってトリガーされるハイパーパラメータ調整の結果）がありますが、通常は、同じメトリクスによって測定される同様のパラメータセットを持つモデル実行を保持します。

![モデルとその実行回数、作成者、最終アクティビティーを示すモデル検証。](img/experiments_v17_9.png)

## モデル実行 {#model-run}

モデル実行とは、機械学習モデルのトレーニングのバリエーションであり、最終的にはモデルのバージョンにプロモートできます。

![ジョブID、作成タイムスタンプ、作成者名、ステータスを含む実験リストチャート。](img/runs_v17_9.png)

データサイエンティストの目標は、特定のメトリクスによって示されるように、パラメータ値が最高のモデルパフォーマンスにつながるモデル実行を見つけることです。

![MLflow実行ID、ソース情報、およびパラメータを示す実験およびメタデータページ。](img/run_v17_9.png)

いくつかのパラメータの例:

- アルゴリズム（線形回帰や決定木など）。
- アルゴリズムのハイパーパラメータ（学習率、ツリーの深さ、エポック数）。
- 含まれるフィーチャ。

## 新しい実験と実行を追跡する {#track-new-experiments-and-runs}

実験とトライアルは、[MLflow](https://www.mlflow.org/docs/latest/tracking.html)クライアントの互換性を通じてのみ追跡できます。GitLabをMLflowクライアントのバックエンドとして使用する方法の詳細については、[MLflowクライアントの互換性](mlflow_client.md)を参照してください。

## モデル実行を調査する {#explore-model-runs}

現在アクティブな実験を一覧表示するには、`https/-/ml/experiments`に移動するか、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **分析** > **モデル検証**を選択します。
1. ログに記録されたすべての実行を、そのメトリクス、パラメータ、およびメタデータとともに表示するには、実験を選択します。
1. 実行の詳細を表示するには、**詳細**を選択します。

## ログアーティファクトを表示する {#view-log-artifacts}

トライアルアーティファクトはパッケージとして保存されます。実行用にアーティファクトがログに記録された後、実行用にログに記録されたすべてのアーティファクトはパッケージレジストリにリストされます。実行のパッケージ名は`ml_experiment_<experiment_id>`です。ここで、バージョンは実行IIDです。アーティファクトへのリンクは、**Experiment Runs**リストまたは**Run detail**からもアクセスできます。

## CI情報を表示する {#view-ci-information}

実行をそれらを作成したCIジョブに関連付けることができ、マージリクエスト、パイプライン、およびパイプラインをトリガーしたユーザーへのクイックリンクを許可します:

![関連付けられたCIジョブ、パイプライン、およびユーザー情報を表示する実行詳細ページ。](img/run_detail_ci_v17_9.png)

## ログに記録されたメトリクスを表示する {#view-logged-metrics}

実験を実行すると、GitLabは、そのメトリクス、パラメータ、およびメタデータを含む、特定の関連データを記録します。分析のためにチャートでメトリクスを表示できます。

ログに記録されたメトリクスを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **分析** > **モデル検証**を選択します。
1. 表示する実験を選択します。
1. **パフォーマンス**タブを選択します。

![実験のパフォーマンスのグラフ](img/metrics_v17_10.png)
