---
stage: Application Security Testing
group: Secret Detection
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'チュートリアル: パイプラインのシークレット検出でプロジェクトを保護する'
---

<!-- vale gitlab_base.FutureTense = NO -->

アプリケーションが外部リソースを使用する場合、通常、トークンやキーなどのシークレットでアプリケーションを認証する必要があります。シークレットがリモートリポジトリにプッシュされると、そのリポジトリへのアクセス権を持つすべての人が、あなたまたはあなたのアプリケーションになりすますことができます。

パイプラインシークレット検出は、CI/CDジョブを使用して、GitLabプロジェクトのシークレットをチェックします。このチュートリアルでは、プロジェクトを作成し、パイプラインシークレット検出を設定し、その結果を分析する方法を学習します:

1. [プロジェクトを作成する](#create-a-project)
1. [ジョブの出力を確認](#check-the-job-output)
1. [マージリクエストパイプライン](#enable-merge-request-pipelines)を有効にするには
1. [偽のシークレットを追加](#add-a-fake-secret)
1. [シークレットをトリアージする](#triage-the-secret)
1. [リークを修正する](#remediate-a-leak)

## はじめる前 {#before-you-begin}

このチュートリアルを開始する前に、以下を確認してください:

- GitLab.comアカウント。パイプラインシークレット検出のすべての機能を活用するには、Ultimateプランのアカウントを使用してください。
- CI/CDに関するある程度の知識。

## プロジェクトを作成する {#create-a-project}

まず、プロジェクトを作成し、シークレット検出を有効にします:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）> **新規プロジェクト/リポジトリ**を選択します。
1. **空のプロジェクトの作成**を選択します。
1. プロジェクトの詳細を入力します:
   1. 名前とプロジェクトslugを入力します。
   1. **プロジェクトのデプロイ先(オプション)**ドロップダウンリストから、**デプロイ計画がありません**を選択します。
   1. **リポジトリを初期化しREADMEファイルを生成する**チェックボックスを選択します。これにより、後でプロジェクトにコンテンツを追加する場所が提供されます。
   1. **シークレット検出を有効にする**チェックボックスを選択します。
1. **プロジェクトを作成**を選択します。

新しいプロジェクトが作成され、Readmeと`.gitlab-ci.yml`ファイルで初期化されます。CI/CD設定には、`Security/Secret-Detection.gitlab-ci.yml`テンプレートが含まれており、プロジェクトでパイプラインシークレット検出を有効にします。

## ジョブの出力を確認 {#check-the-job-output}

パイプラインシークレット検出は、`secret_detection`CI/CDジョブで実行されます。スキャンの結果は、CI/CDジョブログに書き込まれます。各スキャンでは、ジョブアーティファクトとして包括的なレポートも生成されます。

最新のスキャンの結果を確認するには、次の手順に従います:

1. 左側のサイドバーで、**ビルド** > **ジョブ**を選択します。
1. 最新の`secret_detection`ジョブを選択します。新しいパイプラインを実行していない場合は、ジョブは1つだけです。
1. ジョブログで、次の出力を確認します:
   - アナライザーのバージョンやルールセットなど、スキャンに関する情報。プロジェクトでは、シークレット検出を自動的に有効にしたため、デフォルトのルールセットが使用されます。
   - シークレットが検出されたかどうか。`no leaks found`と表示されるはずです。
1. 完全なレポートをダウンロードするには、**ジョブのアーティファクト**で**ダウンロード**を選択します。

## マージリクエストパイプラインを有効にする {#enable-merge-request-pipelines}

これまでのところ、パイプラインシークレット検出を使用して、デフォルトブランチのコミットをスキャンしました。ただし、デフォルトブランチにマージする前に、マージリクエスト内のコミットを分析するには、マージリクエストパイプラインを有効にする必要があります。

これを行うには、次の手順を実行します:

1. `.gitlab-ci.yml`ファイルに次の行を追加します:

   ```yaml
   variables:
     AST_ENABLE_MR_PIPELINES: "true"
   ```

1. 変更を保存し、プロジェクトの`main`ブランチにコミットします。

## 偽のシークレットを追加 {#add-a-fake-secret}

次に、マージリクエストで偽のシークレットを「リーク」して、ジョブの出力を複雑にしてみましょう:

1. 新しいブランチをチェックアウトします:

   ```shell
   git checkout -b pipeline-sd-tutorial
   ```

1. プロジェクトのReadmeを編集し、次の行を追加します。パーソナルアクセストークンの正確な形式に合わせるには、`-`の前後のスペースを必ず削除してください:

   ```markdown
   # To make the example work, remove
   # the spaces before and after the dash:
   glpat - 12345678901234567890
   ```

1. 変更をコミットしてプッシュし、マージするためにマージリクエストを開いてデフォルトブランチにマージします。

   マージリクエストパイプラインが自動的に実行されます。
1. パイプラインが完了するのを待ってから、ジョブログを確認します。`WRN leaks found: 1`と表示されるはずです。
1. ジョブアーティファクトをダウンロードし、次の情報が含まれていることを確認します:
   - シークレットの種類。この例では、タイプは`"GitLab personal access token"`です。
   - シークレットの使用目的の説明と、リークを修正するために実行できる手順。
   - 脆弱性の重大度。パーソナルアクセストークンはGitLab.comでユーザーになりすますために使用できるため、このリークは`Critical`です。
   - シークレットのrawテキスト。
   - シークレットの場所に関する情報:

     ```json
     "file": "README.md",
     "line_start": 97,
     "line_end": 97,
     ```

     この例では、シークレットはファイル`README.md`の97行目にあります。

### マージリクエストのセキュリティウィジェットを使用します {#using-the-merge-request-security-widget}

{{< details >}}

- プラン: Ultimate

{{< /details >}}

デフォルト以外のブランチで検出されたシークレットは、「検出結果」と呼ばれます。検出結果がデフォルトブランチにマージされると、「脆弱性」になります。

マージリクエストウィジェットには、マージリクエストがマージされた場合に脆弱性になる可能性のある検出結果のリストが表示されます。

ウィジェットを表示するには:

1. 前の手順で作成したマージリクエストを選択します。
1. マージリクエストウィジェットを見つけます。これは、**セキュリティスキャン**から始まります。
1. ウィジェットで、**詳細を表示**（{{< icon name="chevron-down" >}}）を選択します。
1. 表示された情報を確認します。**Secret detection detected 1 new potential vulnerability**（シークレット検出で1つの新しい潜在的な脆弱性が検出されました）が表示されます。

マージリクエスト内のすべての検出結果の詳細なビューについては、**すべてのパイプラインの検証結果を表示する**を選択します。

## シークレットをトリアージする {#triage-the-secret}

{{< details >}}

- プラン: Ultimate

{{< /details >}}

GitLab Ultimateプランでは、ジョブの出力は次にも書き込まれます:

- パイプラインの**セキュリティ**タブ。
- 検出結果が脆弱性になった場合は、脆弱性レポート。

UIを使用してシークレットをトリアージする方法を示すために、脆弱性を作成し、脆弱性レポートでそのステータスを変更してみましょう:

1. 最後の手順で作成したマージリクエストをマージし、パイプラインが完了するのを待ちます。

   偽のシークレットが`main`に追加され、これにより検出結果が脆弱性になります。
1. 左側のサイドバーで、**セキュリティ**>**脆弱性レポート**を選択します。
1. 脆弱性の**説明**を選択して表示します:
   - シークレットの種類の詳細。
   - 修正ガイダンス。
   - 脆弱性がいつ、どこで検出されたかに関する情報。
1. **脆弱性を編集**>**ステータスの変更**を選択します。
   1. **ステータス**ドロップダウンリストから、**[無視する...]を選択します。[テストで使用]**。
   1. プロジェクトに偽のシークレットを追加した理由を説明するコメントを追加します。
   1. **ステータスの変更**を選択します。

脆弱性は、脆弱性レポートのフロントページに表示されなくなります。

## リークを修正する {#remediate-a-leak}

シークレットをリモートリポジトリに追加すると、そのシークレットは安全ではなくなり、できるだけ早く失効する必要があります。シークレットを失効して置き換える必要があります。これらがデフォルトブランチにマージされていない場合でも同様です。

リークを修正するために実行する正確な手順は、組織のセキュリティポリシーによって異なりますが、少なくとも次のことを行う必要があります:

1. シークレットを失効します。シークレットが失効されると、有効ではなくなり、正当なアクティビティーを偽装するために使用できなくなります。
1. リポジトリからシークレットを削除します。

特定の修正ガイダンスは、`secret-detection`ジョブのジョブログに書き込まれ、脆弱性レポートの詳細ページで確認できます。
