# frozen_string_literal: true

require 'spec_helper'
require_migration!

RSpec.describe QueueDeleteOrphanedSbomOccurrences, migration: :gitlab_sec, feature_category: :software_composition_analysis do
  let(:migration) { described_class.new }
  let(:batched_migration) { described_class::MIGRATION }

  it 'schedules a new batched migration' do
    reversible_migration do |migration|
      migration.before -> {
        expect(batched_migration).not_to have_scheduled_batched_migration
      }

      migration.after -> {
        expect(batched_migration).to have_scheduled_batched_migration(
          gitlab_schema: :gitlab_sec,
          table_name: :sbom_occurrences,
          column_name: :id,
          batch_size: described_class::BATCH_SIZE,
          sub_batch_size: described_class::SUB_BATCH_SIZE,
          max_batch_size: described_class::MAX_BATCH_SIZE
        )
      }
    end
  end
end
