# frozen_string_literal: true

require 'spec_helper'
require_migration!

RSpec.describe QueueRemoveOrphanedVulnerabilityNotesBatchedMigration, migration: :gitlab_main, feature_category: :vulnerability_management do
  let(:migration) { described_class.new }
  let(:batched_migration) { described_class::MIGRATION }

  it 'schedules a new batched migration' do
    reversible_migration do |migration|
      migration.before -> {
        expect(batched_migration).not_to have_scheduled_batched_migration
      }

      migration.after -> {
        expect(batched_migration).to have_scheduled_batched_migration(
          gitlab_schema: :gitlab_main,
          table_name: :notes,
          column_name: :id,
          interval: described_class::DELAY_INTERVAL,
          batch_size: described_class::BATCH_SIZE,
          sub_batch_size: described_class::SUB_BATCH_SIZE
        )
      }
    end
  end

  it 'uses the correct migration class' do
    expect(described_class::MIGRATION).to eq('RemoveOrphanedVulnerabilityNotesBatchedMigration')
  end

  it 'sets the correct delay interval' do
    expect(described_class::DELAY_INTERVAL).to eq(2.minutes)
  end

  it 'sets the correct batch size' do
    expect(described_class::BATCH_SIZE).to eq(1000)
  end

  it 'sets the correct sub-batch size' do
    expect(described_class::SUB_BATCH_SIZE).to eq(100)
  end
end
