# frozen_string_literal: true

module QA
  RSpec.describe 'Software Supply Chain Security', :orchestrated, :oauth, feature_category: :system_access do
    describe 'OAuth' do
      it 'connects and logs in with GitHub OAuth',
        testcase: 'https://gitlab.com/gitlab-org/gitlab/-/quality/test_cases/402405' do
        Runtime::Browser.visit(:gitlab, Page::Main::Login)

        Page::Main::Login.perform(&:sign_in_with_github)

        Vendor::Github::Page::Login.perform(&:login)

        expect(page).to have_content('Welcome to GitLab')
      end
    end
  end
end
