---
stage: none
group: none
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
noindex: true
title: Breaking change deployments on GitLab.com
---

Changes are deployed continuously to GitLab.com. However, breaking changes
can require more time to prepare for.

In the month before the GitLab 18.0 release, breaking changes will be deployed
during three time windows. The following tables list when each breaking change will be deployed.

<!--
Do not edit this page directly.
This page is generated by lib/tasks/gitlab/docs/compile_windows.rake and
from the yaml files in /data/deprecations.
To update this file, run: bin/rake gitlab:docs:compile_windows
-->
## Window 1

This window takes place on April 21 - 23, 2025 from 09:00 UTC to 22:00 UTC.

| Deprecation | Impact | Stage | Scope | Check potential impact |
|-------------|--------|-------|-------|------------------------|
| [CI/CD job token - **Authorized groups and projects** allowlist enforcement](deprecations.md#cicd-job-token---authorized-groups-and-projects-allowlist-enforcement) | High | Software supply chain security | Project | Refer to the [Understanding this change](https://gitlab.com/gitlab-org/gitlab/-/issues/383084#understanding-this-change) section for details. |
| [Deprecation of `name` field in `ProjectMonthlyUsageType` GraphQL API](deprecations.md#deprecation-of-name-field-in-projectmonthlyusagetype-graphql-api) | Low | Fulfillment | Project |  |
| [Deprecation of `STORAGE` enum in `NamespaceProjectSortEnum` GraphQL API](deprecations.md#deprecation-of-storage-enum-in-namespaceprojectsortenum-graphql-api) | Low | Fulfillment | Group |  |
| [DAST `dast_devtools_api_timeout` will have a lower default value](deprecations.md#dast-dast_devtools_api_timeout-will-have-a-lower-default-value) | Low | Application security testing | Project |  |
| [API Discovery will use branch pipelines by default](deprecations.md#api-discovery-will-use-branch-pipelines-by-default) | Low | Application_security_testing | Project |  |
| [Application Security Testing analyzers major version update](deprecations.md#application-security-testing-analyzers-major-version-update) | Low | Application security testing | Project |  |

## Window 2

This window takes place on April 28 - 30, 2025 from 09:00 UTC to 22:00 UTC.

| Deprecation | Impact | Stage | Scope | Check potential impact |
|-------------|--------|-------|-------|------------------------|
| [Replace `add_on_purchase` GraphQL field with `add_on_purchases`](deprecations.md#replace-add_on_purchase-graphql-field-with-add_on_purchases) | Low | Fulfillment | Instance, group |  |
| [Replace namespace `add_on_purchase` GraphQL field with `add_on_purchases`](deprecations.md#replace-namespace-add_on_purchase-graphql-field-with-add_on_purchases) | Low | Fulfillment | Instance, group |  |
| [Limit number of scan execution policy actions allowed per policy](deprecations.md#limit-number-of-scan-execution-policy-actions-allowed-per-policy) | Low | Security risk management | Instance, group, project |  |

## Window 3

This window takes place on May 5 - 7, 2025 from 09:00 UTC to 22:00 UTC.

| Deprecation | Impact | Stage | Scope | Check potential impact |
|-------------|--------|-------|-------|------------------------|
| [CI/CD job token - **Limit access from your project** setting removal](deprecations.md#cicd-job-token---limit-access-from-your-project-setting-removal) | High | Software supply chain security | Project | Refer to the [Understanding this change](https://gitlab.com/gitlab-org/gitlab/-/issues/395708#understanding-this-change) section for details. |
| [Deprecate Terraform CI/CD templates](deprecations.md#deprecate-terraform-cicd-templates) | Medium | Deploy | Project |  |
| [Deprecate license metadata format V1](deprecations.md#deprecate-license-metadata-format-v1) | Low | Secure | Instance |  |
| [The `direction` GraphQL argument for `ciJobTokenScopeRemoveProject` is deprecated](deprecations.md#the-direction-graphql-argument-for-cijobtokenscoperemoveproject-is-deprecated) | Low | Govern | Project |  |
| [Behavior change for Upcoming and Started milestone filters](deprecations.md#behavior-change-for-upcoming-and-started-milestone-filters) | Low | Plan | Group, project |  |
| [Dependency Proxy token scope enforcement](deprecations.md#dependency-proxy-token-scope-enforcement) | High | Package | Group |  |
| [Remove duoProAssignedUsersCount GraphQL field](deprecations.md#remove-duoproassigneduserscount-graphql-field) | Low | Plan | Group, project |  |
