---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Understand merge conflicts, and learn how to fix them in Git projects.
title: マージコンフリクト
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

マージコンフリクトは、マージリクエスト内の2つのブランチ（ソースとターゲット）で、同じコード行に対し異なる変更が加えられている場合に発生します。ほとんどの場合、GitLabは変更をまとめてマージできますが、コンフリクトが発生した場合は、どちらの変更を保持するのかを決定する必要があります。

![マージコンフリクトが原因でマージリクエストがブロックされた](img/conflicts_v16_7.png)

コンフリクトが発生したマージリクエストを解決するには、次のいずれかを行う必要があります。

- マージコミットを作成します。
- リベースによってコンフリクトを解決します。

GitLabは、ターゲットブランチにマージせずに、ソースブランチにマージコミットを作成することでコンフリクトを解決します。その後、マージコミットを確認してテストし、意図しない変更が含まれていないこと、およびビルドが壊れていないことを検証できます。

## コンフリクトブロックについて

Gitがユーザーによる決定を必要とするコンフリクトを検出すると、コンフリクトマーカーでコンフリクトブロックの開始と終了をマークします。

- `<<<<<<< HEAD`は、コンフリクトブロックの開始を示します。
- 変更内容が表示されます。
- `=======`は、変更内容の終了を示します。
- ターゲットブランチの最新の変更が表示されます。
- `>>>>>>>`は、コンフリクトの終了を示します。

コンフリクトを解決するには、以下を削除します。

1. コンフリクトしている行の保持しないバージョンを削除する。
1. 3つのコンフリクトマーカー（開始、終了、2つのバージョンの間の`=======`行）を削除する。

## ユーザーインターフェースで解決できるコンフリクト

コンフリクトしているファイルが次の条件を満たす場合、GitLab UIでマージコンフリクトを解決できます。

- バイナリではないテキストファイルである。
- 追加されたコンフリクトマーカーを含めて、サイズが200 KB未満である。
- UTF-8互換のエンコードを使用している。
- コンフリクトマーカーが含まれていない。
- 両方のブランチで同じパスに存在する。

ファイルがこれらの条件を満たしていない場合は、コンフリクトを手動で解決する必要があります。

## コンフリクトの解決方法

GitLabは、ユーザーインターフェースで[解決を利用できるコンフリクト](#conflicts-you-can-resolve-in-the-user-interface)を表示します。また、次の方法でコンフリクトを解決することもできます。

- **インタラクティブモード**: 保持する行のバージョンを選択するだけで済むコンフリクトに最適です。
- **インラインエディタ**: 手動編集で変更点を組み合わせる必要がある、複雑なコンフリクトに適しています。
- **コマンドライン**: 複雑なコンフリクトを完全に制御できます。詳細については、[コマンドラインからコンフリクトを解決する](../../../topics/git/git_rebase.md#resolve-conflicts-from-the-command-line)を参照してください。

### インタラクティブモード

インタラクティブモードでは、選択した変更を加えて、ターゲットブランチをソースブランチにマージします。

インタラクティブモードでマージコンフリクトを解決するには、次の手順を実行します。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. **概要**を選択し、マージリクエストレポートセクションまでスクロールします。
1. マージコンフリクトメッセージを見つけ、**コンフリクトを解決**を選択します。GitLabにマージコンフリクトのあるファイルの一覧が表示されます。コンフリクトしている行が強調表示されます。

1. コンフリクトごとに、**oursを使用**または**theirsを使用**を選択して、コンフリクトのある行のうち保持するバージョンをマークします。この決定を「コンフリクトの解決」と呼びます。
1. すべてのコンフリクトを解決したら、**コミットメッセージ**を入力します。
1. **ソースブランチにコミット**を選択します。

### インラインエディタ

一部のマージコンフリクトはより複雑であるため、行を手動で編集して解決する必要があります。

マージコンフリクトの解決エディタは、GitLabでこれらのコンフリクトを解決するのに役立ちます。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. **概要**を選択し、マージリクエストレポートセクションまでスクロールします。
1. マージコンフリクトメッセージを見つけ、**コンフリクトを解決**を選択します。GitLabにマージコンフリクトのあるファイルの一覧が表示されます。
1. 手動で編集するファイルを見つけ、コンフリクトブロックまでスクロールします。
1. そのファイルのヘッダーで、**インラインで編集**を選択してエディタを開きます。この例では、コンフリクトブロックの開始は1350行目で、終了は1356行目です。

   ![マージコンフリクトエディタ](img/merge_conflict_editor_v16_7.png)

1. コンフリクトを解決したら、**コミットメッセージ**を入力します。
1. **ソースブランチにコミット**を選択します。

## リベース

マージリクエストが`Checking ability to merge automatically`メッセージで停止している場合は、以下を実行できます。

- マージリクエストのコメントで、`/rebase`[クイックアクション](../quick_actions.md#issues-merge-requests-and-epics)を実行します。
- マージウィジェットで、**ソースブランチをリベース**を選択します。
- [Gitでリベースします](../../../topics/git/git_rebase.md#rebase)。

CI/CDパイプラインの問題のトラブルシューティングについては、[CI/CDパイプラインのデバッグ](../../../ci/debugging.md)を参照してください。

### GitLab UIでのリベース

GitLab UIからリベースをトリガーするには、`/rebase`[クイックアクション](../quick_actions.md)またはマージリクエストウィジェットのリベースオプションを使用します。

前提要件:

- マージコンフリクトが存在しない。
- ソースプロジェクトの[デベロッパー以上のロール](../../permissions.md)が必要。
- マージリクエストがフォーク内にある場合、フォークは[アップストリームプロジェクトのメンバーからの](allow_collaboration.md)コミットを許可する必要がある。

GitLab UIからマージリクエストのブランチをリベースするには、次の手順を実行します。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. 次のいずれかの操作を行います。
   - **概要**タブで、マージリクエストウィジェットまでスクロールし、**ソースブランチをリベース**を選択します。
   - コメントで`/rebase`を入力し、**コメント**を選択します。

GitLabは、スケジュールを設定し、デフォルトブランチに対してブランチのリベースを実行します。GitLabは、完了したリベースをシステムノートとして表示します。

## 関連トピック

- [コンフリクトのリベースと解決](../../../topics/git/git_rebase.md)
- [Gitリベースと強制プッシュの概要](../../../topics/git/git_rebase.md)
- [Gitワークフローを視覚化するためのGitアプリケーション](https://git-scm.com/downloads/guis)
- [`git rerere`を使用した自動コンフリクト解決](https://git-scm.com/book/en/v2/Git-Tools-Rerere)
