---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Read through the GitLab installation methods.
title: GitLabをインストールする
---

GitLabは、ほとんどのGNU/Linuxディストリビューションをはじめ、様々なクラウドプロバイダーやKubernetesクラスターにインストールできます。最大限活用するには、パフォーマンス、信頼性、管理のしやすさ（バックアップ、アップグレード、およびトラブルシューティング）と、ホスティングにかかるコストとのバランスを取る必要があります。

<!-- markdownlint-disable MD044 -->

| | | |
|--|--|--|
| [**インストール要件**](requirements.md)<br>インストールに必要な前提要件 | [**インストール方法**](install_methods.md)<br>Linux、Helm、Docker、Operator、ソース、またはスクリプト | [**クラウドプロバイダーにGitLabをインストールする**](cloud_providers.md)<br>AWS、Google Cloud Platform、Azure |
| [**オフラインGitLab**](../topics/offline/_index.md)<br>隔離環境でのインストール | [**リファレンスアーキテクチャ**](../administration/reference_architectures/_index.md)<br>大規模環境向け推奨デプロイ | [**GitLabをアップグレードする**](../update/_index.md)<br>最新バージョンの手順 |
| [**GitLab Runnerをインストールする**](https://docs.gitlab.com/runner/install/)<br>CI/CDジョブ用ソフトウェア | [**GitLab Runnerを設定する**](https://docs.gitlab.com/runner/configuration/)<br>`Config.toml`、証明書、自動スケール、プロキシ設定 | [**GitLab AIゲートウェイをインストールする**](install_ai_gateway.md)<br>Dockerイメージの使用、Helmチャートの使用 |

<!-- markdownlint-enable MD044 -->
