package server

import (
	"github.com/go-chi/chi/v5"
	"github.com/go-chi/chi/v5/middleware"
	auth_middleware "gitlab.com/gitlab-org/gitlab-zoekt-indexer/internal/middleware/auth"
	"gitlab.com/gitlab-org/gitlab-zoekt-indexer/internal/middleware_logger"
)

func (s *IndexServer) Router() *chi.Mux {
	r := chi.NewRouter()
	logger := middleware_logger.SetUpLogger()
	r.Use(middleware_logger.SlogMiddleware(logger))
	r.Use(middleware.Heartbeat(s.getPath("/health")))

	// Add JWT authentication middleware if enabled
	if s.JWTEnabled && s.Auth != nil {
		authConfig := &auth_middleware.Config{
			Auth:          s.Auth,
			Logger:        logger,
			ExcludedPaths: []string{s.getPath("/health"), s.getPath("/metrics")},
			Enabled:       true,
		}
		r.Use(authConfig.Middleware())
	}

	r.Get(s.getPath("/index/{id}"), s.handleStatus())
	r.Delete(s.getPath("/index/{id}"), s.handleDelete())
	r.Post(s.getPath("/index"), s.handleIndex())
	r.Post(s.getPath("/truncate"), s.handleTruncate())
	r.Get(s.getPath("/metrics"), s.handleMetrics())
	r.Get(s.getPath("/debug/ls"), s.handleDebugLs())

	return r
}

func (s *IndexServer) getPath(path string) string {
	return s.PathPrefix + path
}
