package search

import (
	"testing"

	"github.com/sourcegraph/zoekt"
)

func TestCalculateStats(t *testing.T) {
	tests := []struct {
		name                   string
		result                 Result
		expectFiles            uint64
		expectLines            uint64
		expectTotalFileMatches uint64
		expectTotalLineMatches uint64
	}{
		{
			name: "no files",
			result: Result{
				Files:      nil,
				FileCount:  0,
				MatchCount: 0,
			},
			expectFiles:            0,
			expectLines:            0,
			expectTotalFileMatches: 0,
			expectTotalLineMatches: 0,
		},
		{
			name: "one file, no matches",
			result: Result{
				Files:      []zoekt.FileMatch{{}},
				FileCount:  1,
				MatchCount: 0,
			},
			expectFiles:            1,
			expectLines:            0,
			expectTotalFileMatches: 1,
			expectTotalLineMatches: 0,
		},
		{
			name: "multiple files and matches",
			result: Result{
				Files: []zoekt.FileMatch{
					{LineMatches: []zoekt.LineMatch{{}, {}}},
					{LineMatches: []zoekt.LineMatch{{}}},
				},
				FileCount:  2,
				MatchCount: 3,
			},
			expectFiles:            2,
			expectLines:            3,
			expectTotalFileMatches: 2,
			expectTotalLineMatches: 3,
		},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			r := tt.result
			r.CalculateStats()
			if r.FileMatchCount != tt.expectFiles {
				t.Errorf("FileMatchCount = %d, want %d", r.FileMatchCount, tt.expectFiles)
			}
			if r.LineMatchCount != tt.expectLines {
				t.Errorf("LineMatchCount = %d, want %d", r.LineMatchCount, tt.expectLines)
			}
			if r.TotalFileMatchCount != tt.expectTotalFileMatches {
				t.Errorf("TotalFileMatchCount = %d, want %d", r.TotalFileMatchCount, tt.expectTotalFileMatches)
			}
			if r.TotalLineMatchCount != tt.expectTotalLineMatches {
				t.Errorf("TotalLineMatchCount = %d, want %d", r.TotalLineMatchCount, tt.expectTotalLineMatches)
			}
		})
	}
}
