// Package projectpath provides a way to determine the root directory of the project at runtime.
// It uses runtime.Caller to find the location of the current file and then calculates
// the project root relative to this file's location. This is useful for accessing
// project resources with absolute paths regardless of the working directory.
package projectpath

import (
	"path/filepath"
	"runtime"
)

var (
	_, b, _, _ = runtime.Caller(0)

	// Root folder of this project
	Root = filepath.Join(filepath.Dir(b), "../..")
)
