// Copyright 2016 Google Inc. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Command zoekt-webserver responds to search queries, using an index generated
// by another program such as zoekt-indexserver.

package main

import (
	"log"
	"os"

	"gitlab.com/gitlab-org/gitlab-zoekt-indexer/internal/mode/webserver"
)

var (
	// Overriden in the makefile
	Version   = "dev"
	BuildTime = ""
)

func main() {
	options, err := webserver.ParseFlags()
	if err != nil {
		log.Fatalf("program aborted: %v", err)
		os.Exit(1)
	}

	err = webserver.Run(options, Version, BuildTime)
	if err != nil {
		log.Fatalf("program aborted: %v", err)
		os.Exit(1)
	}
}
