package main

import (
	"log/slog"
	"os"

	"gitlab.com/gitlab-org/gitlab-zoekt-indexer/internal/mode/indexer"
)

var (
	// Overriden in the makefile
	Version   = "dev"
	BuildTime = ""
)

func main() {
	options, err := indexer.ParseFlags()
	if err != nil {
		slog.Error("program aborted", "error", err)
		os.Exit(1)
	}

	err = indexer.Run(options, Version, BuildTime)
	if err != nil {
		slog.Error("program aborted", "error", err)
		os.Exit(1)
	}
}
