package gitaly

import (
	"context"
	"fmt"
)

type MockGitalyReader struct {
	bulkIndexFiles  []File
	bulkDeletePaths []string
}

func NewMockGitalyReader(bulkIndexFiles []File, bulkDeletePaths []string) *MockGitalyReader {
	return &MockGitalyReader{
		bulkIndexFiles:  bulkIndexFiles,
		bulkDeletePaths: bulkDeletePaths,
	}
}

func (gc *MockGitalyReader) Close() error {
	return nil
}

func (gc *MockGitalyReader) EachFileChangeBatched(ctx context.Context, bulkPut BulkPutFunc, bulkDel BulkDelFunc, indexBatchSize int) error {
	if err := bulkPut(ctx, gc.bulkIndexFiles); err != nil {
		return fmt.Errorf("bulkPut: %w", err)
	}

	if err := bulkDel(ctx, gc.bulkDeletePaths); err != nil {
		return fmt.Errorf("bulkDel: %w", err)
	}

	return nil
}
