package types

import (
	"strings"
)

// File represents a file to be chunked
type File struct {
	Path    string `json:"path"`
	Content string `json:"content"`
	OID     string `json:"oid"` // this is the blob id
}

func (f *File) GetFilename() string {
	filename := f.Path
	lastSlashIndex := strings.LastIndex(filename, "/")

	if lastSlashIndex != -1 {
		filename = filename[lastSlashIndex+1:]
	}

	return filename
}
