package chunker

import (
	"fmt"
)

// ContentType represents the type of content in a chunk
type ContentType int

// Set file content type as 1 for now
// Later on, we will get this value from a map coming from Ruby
const (
	FileContentType ContentType = 1
)

// Set the default chunk size to 1000
const DefaultChunkSize = 1000

// ChunkOptions contains configuration for the chunking process
type ChunkOptions struct {
	ChunkSize    uint16 `json:"chunk_size"`
	ChunkOverlap uint16 `json:"chunk_overlap"`
}

// Chunk represents a chunk of content from a file
type Chunk struct {
	Path      string      `json:"path"`
	Type      ContentType `json:"type"`
	Name      string      `json:"name"`
	Language  string      `json:"language"`
	Content   string      `json:"content"`
	OID       string      `json:"oid"`
	StartByte int         `json:"start_byte"`
	Length    int         `json:"length"`
	StartLine int         `json:"start_line"`
}

func (c *Chunk) GetSource() string {
	return fmt.Sprintf("%s::%d:%d::%d", c.OID, c.StartByte, c.Length, c.StartLine)
}
