package code

import (
	"context"
	"testing"

	"github.com/stretchr/testify/require"
	"gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/mode/chunk/chunker"
	"gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/mode/chunk/types"
)

func TestChunker(t *testing.T) {
	t.Parallel()

	t.Run("New", func(t *testing.T) {
		t.Parallel()

		options := chunker.ChunkOptions{
			ChunkSize: 200,
		}

		c, err := New(options)

		require.NoError(t, err)
		require.Implements(t, (*chunker.Chunker)(nil), c)
	})

	t.Run("New_zero_chunk_size", func(t *testing.T) {
		t.Parallel()

		options := chunker.ChunkOptions{
			ChunkSize: 0,
		}

		files := []types.File{
			{
				Path:    "file1.txt",
				Content: "This is a short file",
			},
		}

		c, err := New(options)
		require.NoError(t, err)

		chunks, err := c.ChunkFiles(context.Background(), files)
		require.NoError(t, err)
		require.Len(t, chunks, 1)
	})

	t.Run("ChunkFiles", func(t *testing.T) {
		t.Parallel()

		options := chunker.ChunkOptions{
			ChunkSize: 200,
		}

		files := []types.File{
			{
				Path: "foo.rb",
				Content: `module Thing
  class Foo
    def bar
      puts("Hello, world!")
    end
  end
end
`,
			},
		}

		c, err := New(options)
		require.NoError(t, err)

		chunks, err := c.ChunkFiles(context.Background(), files)
		require.NoError(t, err)
		require.Len(t, chunks, 1)
		require.Equal(t, "ruby", chunks[0].Language)
		require.Equal(t, 1, chunks[0].StartLine)
	})
}
