package git

import (
	"context"
	"gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/shared/gitaly"
)

// Repository defines the interface for git repository operations
type Repository interface {
	EachFileChangeBatched(ctx context.Context, bulkPut gitaly.BulkPutFunc, bulkDel gitaly.BulkDelFunc, indexBatchSize int) error
	EachCommit(f gitaly.CommitFunc) error
	GetLimitFileSize() int64
	GetFromHash() string
	GetToHash() string
}

// GitalyConnectionInfo represents the connection configuration for Gitaly
type GitalyConnectionInfo struct {
	Address       string `json:"address"`
	Token         string `json:"token"`
	StorageName   string `json:"storage"`
	RelativePath  string `json:"relative_path"`
	ProjectPath   string `json:"project_path"`
	LimitFileSize int64  `json:"limit_file_size"`
	TokenVersion  int    `json:"token_version"`
}

// ToGitalyConfig converts the GitalyConnectionInfo to gitaly.StorageConfig format
func (gci *GitalyConnectionInfo) ToGitalyConfig() (*gitaly.StorageConfig, int64) {
	return &gitaly.StorageConfig{
		Address:      gci.Address,
		Token:        gci.Token,
		StorageName:  gci.StorageName,
		RelativePath: gci.RelativePath,
		ProjectPath:  gci.ProjectPath,
		TokenVersion: gci.TokenVersion,
	}, gci.LimitFileSize
}
