package dev_debug_test

import (
	"testing"

	"github.com/stretchr/testify/require"
	"gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/dev_debug"
)

func TestIsEnabled(t *testing.T) {
	testCases := []struct {
		isSet    bool
		value    string
		expected bool
	}{
		{isSet: false, value: "", expected: false},
		{isSet: true, value: "", expected: false},
		{isSet: true, value: "true", expected: true},
		{isSet: true, value: "false", expected: false},
		{isSet: true, value: "1", expected: true},
	}

	for _, tc := range testCases {
		if tc.isSet {
			t.Setenv("GITLAB_INDEXER_DEBUG_LOGGING", tc.value)
		}

		require.Equal(t, tc.expected, dev_debug.IsEnabled())
	}
}
