#!/bin/bash
set -euo pipefail

# Check if any files were passed as arguments
if [ $# -eq 0 ]; then
  # If no files specified, check all Go files
  files=$(find . -name "*.go" | grep -v vendor)
else
  # Otherwise use the provided files
  files="$@"
fi

# Find unformatted Go files
unformatted=$(gofmt -l $files)

# If there are unformatted files, print them and exit with error
if [ -n "$unformatted" ]; then
  echo "The following files are not properly formatted:"
  echo "$unformatted"
  echo ""
  echo "Run 'gofmt -w .' to fix formatting issues"
  exit 1
fi

exit 0
