package types

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestGetFileName(t *testing.T) {
	t.Parallel()

	fileWithPath := File{
		Path:    "root_dir/dir/file_with_path.txt",
		Content: "some content",
	}
	fileWithoutPath := File{
		Path:    "file_without_path.txt",
		Content: "some content",
	}

	require.Equal(t, "file_with_path.txt", fileWithPath.GetFilename())
	require.Equal(t, "file_without_path.txt", fileWithoutPath.GetFilename())
}
