package indexer

import "gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/mode/chunk/chunker"

// CreateTestChunk creates a test chunk with the given parameters.
// This is a helper function for testing purposes only.
func CreateTestChunk(path, content, oid string, startByte int) chunker.Chunk {
	return chunker.Chunk{
		Path:      path,
		Type:      chunker.FileContentType,
		Name:      "test.txt",
		Language:  "",
		Content:   content,
		OID:       oid,
		StartByte: startByte,
		Length:    len(content),
	}
}
