package indexer_test

import (
	"testing"

	"github.com/stretchr/testify/require"
	"gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/mode/chunk/indexer"
)

func TestGenerateChunkID(t *testing.T) {
	projectID := uint64(123)
	path := "test.txt"
	content := "test content"

	id1 := indexer.GenerateChunkID(projectID, path, content)
	id2 := indexer.GenerateChunkID(projectID, path, content)

	// Same inputs should generate same ID
	require.Equal(t, id1, id2)

	// Different content should generate different ID
	id3 := indexer.GenerateChunkID(projectID, path, "different content")
	require.NotEqual(t, id1, id3)

	// Different project should generate different ID
	id4 := indexer.GenerateChunkID(456, path, content)
	require.NotEqual(t, id1, id4)
}

func TestBuildChunkDocument(t *testing.T) {
	chunk := indexer.CreateTestChunk("test.txt", "test content", "abc123", 10)
	projectID := uint64(123)

	doc := indexer.BuildChunkDocument(chunk, projectID, false)

	require.Equal(t, projectID, doc.ProjectID)
	require.Equal(t, chunk.Path, doc.Path)
	require.Equal(t, chunk.Type, doc.Type)
	require.Equal(t, chunk.Content, doc.Content)
	require.Equal(t, chunk.Name, doc.Name)
	require.Equal(t, chunk.Language, doc.Language)
	require.Equal(t, chunk.GetSource(), doc.Source)
	require.False(t, doc.Reindexing)
	require.NotEmpty(t, doc.ID)
}
