package postgresql_test

import (
	"testing"

	"github.com/stretchr/testify/require"
	"gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/mode/chunk/client/postgresql"
	"gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/mode/chunk/types"
)

func TestNewPostgreSQLClient(t *testing.T) {
	t.Parallel()

	// Test with minimal connection details
	conn := types.PostgreSQLConnection{
		Host: "localhost",
	}
	pgClient := postgresql.New(conn)
	require.NotNil(t, pgClient)
	require.Equal(t, conn, pgClient.Conn)

	// Test with complete connection details
	conn = types.PostgreSQLConnection{
		Host:     "pg.example.com",
		Port:     5432,
		User:     "gitlab",
		Password: "password",
		Database: "gitlab",
		Table:    "embeddings",
	}
	pgClient = postgresql.New(conn)
	require.NotNil(t, pgClient)
	require.Equal(t, conn, pgClient.Conn)
}

func TestPostgreSQLClientConnect(t *testing.T) {
	t.Parallel()

	conn := types.PostgreSQLConnection{
		Host:     "localhost",
		Port:     5432,
		User:     "postgres",
		Password: "password",
		Database: "gitlab",
		Table:    "embeddings",
	}

	pgClient := postgresql.New(conn)
	require.NotNil(t, pgClient)
}
