package elasticsearch_test

import (
	"context"
	"testing"

	"github.com/stretchr/testify/require"
	"gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/mode/chunk/client/elasticsearch"
	"gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/internal/mode/chunk/types"
)

func TestNewElasticsearchClient(t *testing.T) {
	t.Parallel()

	// Test with empty URL list
	conn := types.ElasticsearchConnection{
		URL: []string{},
	}
	esClient := elasticsearch.New(conn)
	require.NotNil(t, esClient)
	require.Equal(t, conn, esClient.Conn)

	// Test with single URL
	conn = types.ElasticsearchConnection{
		URL: []string{"http://localhost:9200"},
	}
	esClient = elasticsearch.New(conn)
	require.NotNil(t, esClient)
	require.Equal(t, conn, esClient.Conn)

	// Test with multiple URLs
	conn = types.ElasticsearchConnection{
		URL: []string{"http://es1:9200", "http://es2:9200", "http://es3:9200"},
	}
	esClient = elasticsearch.New(conn)
	require.NotNil(t, esClient)
	require.Equal(t, conn, esClient.Conn)
}

func TestElasticsearchClientConnect(t *testing.T) {
	t.Run("empty URL list should fail", func(t *testing.T) {
		t.Parallel()

		conn := types.ElasticsearchConnection{
			URL: []string{},
		}
		esClient := elasticsearch.New(conn)

		ctx := context.Background()
		err := esClient.Connect(ctx)
		require.Error(t, err)
		require.Contains(t, err.Error(), "failed to create Elasticsearch client: no URLs provided")
	})
}

func TestElasticsearchClientClose(t *testing.T) {
	t.Parallel()

	conn := types.ElasticsearchConnection{
		URL: []string{"http://localhost:9200"},
	}
	esClient := elasticsearch.New(conn)
	require.NotNil(t, esClient)

	err := esClient.Close()
	require.NoError(t, err)
}
