package chunker

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestGetSource(t *testing.T) {
	t.Parallel()

	chunk := Chunk{
		Path:      "some/path/file.py",
		Type:      FileContentType,
		Name:      "file.py",
		Language:  "python",
		Content:   "some python code",
		OID:       "abc123",
		StartByte: 100,
		Length:    1234,
		StartLine: 56,
	}

	require.Equal(t, "abc123::100:1234::56", chunk.GetSource())
}
