# GitLab Elasticsearch Indexer development process

## Maintainers

GitLab Elasticsearch Indexer has the following maintainers:

- Dylan Griffith `@DylanGriffith`
- Dmitry Gruzd `@dgruzd`
- Terri Chu `@terrichu`
- John Mason `@johnmason`

This list is defined at https://about.gitlab.com/team/

### How to become a maintainer

GitLab Elasticsearch Indexer follows a maintainership process based on the [smaller project
template](https://about.gitlab.com/handbook/engineering/workflow/code-review/#maintainership-process-for-smaller-projects).

Anyone may nominate themselves as a trainee by opening a tracking issue using the [`gitlab-elasticsearch-indexer` trainee maintainer template](https://gitlab.com/gitlab-com/www-gitlab-com/-/issues/new?issuable_template=trainee-gitlab-elasticsearch-indexer-maintainer&issue[title]=gitlab-elasticsearch-indexer%20Trainee%20Maintainer%3A%20%5BFull%20Name%5D). It's normally a good idea to check with at least one maintainer or your manager before creating the issue, but it's not required.

## Merging and reviewing contributions

Contributions must be reviewed by at least one maintainer. The final merge must
be performed by a maintainer.

## Releases

> **WARNING**: Tags are mirrored on the [security repository](https://gitlab.com/gitlab-org/security/gitlab-elasticsearch-indexer/-/tags) and [dev repository](https://dev.gitlab.org/gitlab/gitlab-elasticsearch-indexer/-/tags).
Deleting tags will not propagate through mirroring. If you need to delete a tag, you must manually remove it from all mirrored repositories.

### Release process

We use [`git-cliff`](https://github.com/orhun/git-cliff) and [`glab`](https://docs.gitlab.com/editor_extensions/gitlab_cli/) to automate our release workflow.
`git-cliff` handles [`CHANGELOG.md`](../CHANGELOG.md) generation and version bumping in the `VERSION` file and `glab` handles creating merge
requests for a release.

#### Automated weekly releases

1. **Scheduled pipeline:** Every week, a [scheduled pipeline](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/-/pipeline_schedules) runs with the `SCHEDULE_TYPE=weekly_release` variable.
2. **Change detection:** The `release_create_mr` job automatically checks if there are changes since the last release:
    - Uses `git-cliff` to determine if conventional commits warrant a version bump
    - Skips release creation if no version bump is detected
3. **Automated release MR:** When changes are detected, the job will:
    * Update the [`VERSION`](../VERSION) file
    * Generate/update the [`CHANGELOG.md`](../CHANGELOG.md) file
    * Create a unique release branch (format: `release_v{version}_{timestamp}_{short_sha}`)
    * Create a merge request with detailed change summary
4. **Manual review:** Maintainers review and merge the automated release MR
5. **Tag creation:** The `version_tag` job automatically tags the new release.
6. **Update indexer version in `gitlab-org/gitlab`:** After the tag is created, [`renovate-gitlab-bot`](https://gitlab.com/gitlab-org/frontend/renovate-gitlab-bot/-/blob/c15f294582549a3700579ce1a1a1094d24504e9d/renovate/gitlab/indexer.config.js)
   will open a merge request to `gitlab-org/gitlab` to update the version reference in [`GITLAB_ELASTICSEARCH_INDEXER_VERSION`](https://gitlab.com/gitlab-org/gitlab/-/blob/master/GITLAB_ELASTICSEARCH_INDEXER_VERSION).

## Backports

Backports may be required when fixes need to be applied to older versions. Choose the appropriate approach:

### Scenario 1: No Major Version Changes

When the current version and the version needing a fix are within the same major version:

**Example:** GitLab 18.5 uses `v5.9.1` (has bug), GitLab 18.6 uses `v5.9.2`

1. Base your fix off the current `main` branch (contains `5.9.2` changes)
2. Use the scheduled pipeline to release a new version. The pipeline will create a merge request. Verify the next version is a patch version (`5.9.3`)
3. A new tag will be created automatically after the merge requested is merged.
4. Opened a backport merge request to `gitlab-org/gitlab` stable release branch for GitLab `18.5`. In that MR, update `GITLAB_ELASTICSEARCH_INDEXER` to the patch version (`v5.9.3`).
5. Renovate will open a merge request to update the current version of GitLab.

### Scenario 2: Major Version Changes Present

When there's a major version bump between the version needing a fix and the current version:

**Example:** GitLab 18.5 uses `v5.9.1` (has bug), GitLab 18.6 uses `v6.0.1`

1. Create a branch (if one does not already exist) from the version with the bug: `git checkout v5.9.1 && git checkout -b patch/5.9.x`
2. Apply the fix to this branch
3. Update `CHANGELOG` with `git-cliff --bump --output CHANGELOG`
4. Update `VERSION` file to next patch (e.g., `5.9.2`)
5. Tag as `v5.9.2` (following semver)
6. Open backport  merge request to GitLab's stable release branch for GitLab `18.5`. Update `GITLAB_ELASTICSEARCH_INDEXER` to the patch version (`v5.9.2`)

## Versioning

GitLab Elasticsearch Indexer uses a variation of SemVer. We don't use
"normal" SemVer because we have to be able to integrate into GitLab stable
branches.

A version has the format MAJOR.MINOR.PATCH.

- Major and minor releases are tagged on the `main` branch
- If the change is backwards compatible, increment the MINOR counter
- If the change breaks compatibility, increment MAJOR and set MINOR to `0`
- Patch release tags must be made on stable branches
- Only make a patch release when targeting a GitLab stable branch

This means that tags that end in `.0` (e.g. `8.5.0`) must always be on
the main branch, and tags that end in anything other than `.0` (e.g.
`8.5.2`) must always be on a stable branch.

> The reason we do this is that SemVer suggests something like a
> refactoring constitutes a "patch release", while the GitLab stable
> branch quality standards do not allow for back-porting refactorings
> into a stable branch.
