package streamer

type IndexerVersionInfo struct {
	Version   string
	BuildTime string
}

func (c *IndexerVersionInfo) Type() RecordType {
	return IndexerVersionInfoType
}

func (c *IndexerVersionInfo) Header() []string {
	return []string{"version", "build_time"}
}

func (c *IndexerVersionInfo) Values() []string {
	return []string{
		c.Version,
		c.BuildTime,
	}
}

type IndexedChunkInfo struct {
	ID string
}

func (c *IndexedChunkInfo) Type() RecordType {
	return IndexedChunkInfoType
}

func (c *IndexedChunkInfo) Header() []string {
	return []string{"id"}
}

func (c *IndexedChunkInfo) Values() []string {
	return []string{
		c.ID,
	}
}
