# GitLab Elasticsearch Indexer

## [5.10.1](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.10.0...v5.10.1) (2025-11-17)

### Dependencies

- Update module gitlab.com/gitlab-org/labkit to v1.32.0 ([1828cf8](1828cf804b1e0ad21f27501c37c55a662a9da912))

### Refactor

- Rename delete operation for chunk mode ([d419e30](d419e30e360f08308a4647ec3d925d6efa892f40))

## [5.10.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.9.4...v5.10.0) (2025-11-12)

[aff4eb4](aff4eb4cddbff0f2c8cef1c56bb44a561152ab6c)...[242a8db](242a8dbf1c40c3d49d3276f3f6680f8484cf6398)

### Bug Fixes

- Fix icu4c pkg-config for all make targets on macos ([ef05372](ef053722db86530f9f6fa8f357f8d43f449877f5))
- Prevent overlimit errors with bulk size tracking ([62eb547](62eb5478e434db8ced476175a35b2d1aa3889b97))

### Dependencies

- Update module gitlab.com/gitlab-org/labkit to v1.31.3 ([e15830e](e15830e11c84a54415949441bf065c91d9c1c270))
- Update module gitlab.com/gitlab-org/labkit to v1.31.4 ([41c5037](41c5037440ca05881bdbf45080a810e70183cd4f))
- Update module gitlab.com/gitlab-org/labkit to v1.31.5 ([6fa97e0](6fa97e01f4f10ff48dc895d461f97f9631fe91ab))
- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.20.0 ([d8df84c](d8df84c17ee88ff3e6a8b49e3bc11cc1f4eddbd6))
- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.20.0 ([6c0108c](6c0108c6de76081478cf402c0346b0bd8347227e))
- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.20.1 ([59ccc87](59ccc87d9d4adeb7a776c0a47d13cc896a70c38c))
- Update dependency node to v22.21.0 ([4e7eddf](4e7eddf217f928d1752183482a2075bcc75397c4))
- Update dependency node to v22.21.1 ([04e453e](04e453e8514e93889e8a1dfcb268b4de8e2a8aac))
- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.20.2 ([228403a](228403ae787b707e7ac0894459a511993a53ec69))

### Documentation

- Add Go style guide with error handling conventions ([f049d90](f049d901135aabc892efd5327dcbaa4835ec796b))

### Features

- Add chunk_strategy option ([d97b897](d97b8976b30fe497fa9972565127d86f40110e1b))
- Add code pre-bert token size limit chunker strategy ([0db88bb](0db88bbd0debc1383e1d4ca8ba62ffe8a6dba056))
- Add project deletion for chunk mode ([185b551](185b551094fd17db088186039e7715d69d0496cb))

### Miscellaneous Tasks

- Add chunk strategies to readme ([fa319c2](fa319c2428f72021f7ba710c5e3cd70d6f13c070))
- Remove node from .tool-versions ([31805c5](31805c521c0d5ffc403ed44437594d998ff1e07a))
- Automated weekly release v5.10.0 ([bcc4684](bcc468438f0217283f98c0de03685bf1d29c51c6))

## [5.9.4](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.9.3...v5.9.4) (2025-10-10)

[112286b](112286be50c97a1104aab497577a4b86e835ff44)...[aff4eb4](aff4eb4cddbff0f2c8cef1c56bb44a561152ab6c)

### Dependencies

- Update dependency node to v22.20.0 ([13ed0b3](13ed0b3c893c79f27b1c5decf3c19bdb48559904))
- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.19.0 ([bd9817f](bd9817faf653700c09422471cfd591c83a5d8b24))
- Update module gitlab.com/gitlab-org/labkit to v1.30.0 ([6f5832d](6f5832d0a8e6116e3f06c97977aa01b9681e3410))
- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.19.3 ([2b27f46](2b27f46a0f4af23a0b15f5bf227fbe466c00a93d))
- Update module gitlab.com/gitlab-org/labkit to v1.31.0 ([0068f6e](0068f6e02cde30c2c1c94697b1463cce9f7d7b7a))
- Update module gitlab.com/gitlab-org/labkit to v1.31.2 ([b9621ed](b9621ed6a49421cec5daac0ebad9ee91c053dcf6))

### Documentation

- Update documentation on backports ([ebb202d](ebb202dc6ddd02d3491b4f6dde8e9a630ee4048a))

### Miscellaneous Tasks

- Add '.md' extension to CHANGELOG ([dab8ac7](dab8ac7f369812a661c453b14d0b876af942a40d))
- Automated weekly release v5.9.4 ([1683a29](1683a29c744788a59a6d76c84f117f4a697b2fb4))

## [5.9.3](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.9.2...v5.9.3) (2025-09-22)

[5c685ef](5c685efc8844d52290b1d04db085742edca5421a)...[112286b](112286be50c97a1104aab497577a4b86e835ff44)

### Bug Fixes

- Prevent data integrity issues in ResolveReindexing, add logs ([32f383e](32f383e45d0bee08c092629e91f9a4e0ff0acad1))

### Dependencies

- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.18.1 ([461f808](461f8086f9e65d5acaeee40bcf127ef82f411b83))

### Miscellaneous Tasks

- Add chunking benchmark ([ea26682](ea26682c113775fc51f84af6604a9b0336a8fd4a))
- Fix dependency proxy address for project pats ([2da60ed](2da60edde173cfe21eb8e3141f421f3d7087cdac))
- Automated weekly release v5.9.3 ([4b1322f](4b1322f6a32f8f67141d22de5d5fbf44d10eee05))

### Performance

- Reuse chunk buffer in code chunker ([fec8a61](fec8a612fadb660a8447976eaed90dd0d8037567))

## [5.9.2](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.9.1...v5.9.2) (2025-09-17)

[a1754a4](a1754a4b3d79a57894944ac5776ed3b37dc65c33)...[5c685ef](5c685efc8844d52290b1d04db085742edca5421a)

### Dependencies

- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.17.0 ([3ad7e42](3ad7e4210ea9c4b4b396f60ed03de9698a70263d))
- Update dependency node to v22.19.0 ([6c2dbbd](6c2dbbdf2e83961e3d972398748a85c65e317c8f))
- Update module gitlab.com/gitlab-org/labkit to v1.27.0 ([7c50146](7c5014697ea6e650a54c740cf4e706cfb2339c87))
- Update module gitlab.com/gitlab-org/labkit to v1.27.1 ([d792148](d7921480c1f4c5676bd214a3aa2b927fe1e857a7))
- Update module gitlab.com/gitlab-org/labkit to v1.28.0 ([07fb862](07fb862ec9116f9c248997c6e993c27e1c025214))
- Update module google.golang.org/grpc to v1.75.1 ([a0f8655](a0f86557b6a4ed356a1f457eb86c59c8c6823edc))
- Update module gitlab.com/gitlab-org/labkit to v1.29.0 ([bb73208](bb73208dcbcfbbea25ad899dca978fb869f652f0))
- Update module github.com/stretchr/testify to v1.11.1 ([00adbbc](00adbbc2257b98a898d990a36f614cca3feb9a1c))
- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.18.0 ([8f66b0c](8f66b0ca6491aa32551e030c1906484ef7c43076))
- Update module github.com/jackc/pgx/v5 to v5.7.6 ([f4d28c0](f4d28c06393eb5a69490cc0217eb057b82b799c1))

### Miscellaneous Tasks

- Add .gitlab-ci.yml validation script ([c464f07](c464f0741da30fc73d9f9e8f6412cfaac8431aa3))
- Remove search-curation flag ([fe76e9a](fe76e9aa7b04f26c48a57b883a75529a23158d98))
- Move releases to weekly scheduled pipeline ([f1d7ce8](f1d7ce866d0dcd3334ea6f0c5e19e7f4b8d25c83))
- Automated weekly release v5.9.2 ([566d731](566d731c228ca1869f9941c6a018fc5d3d727f4c))

## [5.9.1](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.9.0...v5.9.1) (2025-09-02)

[385ac4d](385ac4da69503b17daa3c0757fe8108c112d5646)...[a1754a4](a1754a4b3d79a57894944ac5776ed3b37dc65c33)

### Bug Fixes

- Use interface directly instead of pointer to interface ([b0e673a](b0e673a494eee7b707ebaa0d1275c00ecb393b5b))

### Miscellaneous Tasks

- Improve check-go-build-version script ([cf4fdba](cf4fdbaf03c4424aebe66618c128c16a206c87b6))
- Split CI to use independent stages ([3a636ee](3a636ee05d7bcb736b51afdf33a96fd29369b2d5))
- Release v5.9.1 ([9703032](97030321171ae34a3a33e0c0504b90454dbc73f2))

## [5.9.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.8.0...v5.9.0) (2025-08-28)

[2723581](2723581471ed60fb5d0f0aa82eb33853d622b181)...[385ac4d](385ac4da69503b17daa3c0757fe8108c112d5646)

### Dependencies

- Update module gitlab.com/gitlab-org/rust/gitlab-code-parser/bindings/go to v0.16.1 ([5e1942d](5e1942d47cec4dca1ee544d2519d3c5242130a78))
- Update module google.golang.org/grpc to v1.75.0 ([0281b1a](0281b1af8d4186142853fa6798476e2966682627))

### Features

- Handle force reindex ([6b02de1](6b02de1db962e281bc985431e6337801526fb4c0))

### Miscellaneous Tasks

- Simplify .golangci.yml ([3d94826](3d94826f3f4bbaaff67310e73679b6891f20046c))
- Release v5.9.0 ([390a139](390a1394cb3a50bf91d9389e48a81b9975210c43))

## [5.8.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.7.0...v5.8.0) (2025-08-19)

[740bfe1](740bfe1be1e406362a9b01c20a61e07fb266225f)...[2723581](2723581471ed60fb5d0f0aa82eb33853d622b181)

### Bug Fixes

- Update client name ([4d2940f](4d2940fabed9119b2a6a9c0cfccbc77e23f0a2ab))

### Dependencies

- Update dependency node to v22.17.1 ([440db82](440db823bab42e3c23228373e3491c6e72effcfd))
- Update module google.golang.org/grpc to v1.74.0 ([6b2dc20](6b2dc2037d96c0698cbd7a905eaef3f625e67e82))
- Update module google.golang.org/grpc to v1.74.1 ([05c909d](05c909d818aab9d6b65b54d90404a9d3a8c875ad))
- Update module golang.org/x/net to v0.42.0 ([345cb55](345cb55664e06541527176e14a0d75e3f72e0c1a))
- Update module golang.org/x/tools to v0.35.0 ([95c3e4e](95c3e4ec071594f330d83ddb59c85e7549eeb45c))
- Update dependency node to v22.18.0 ([0ef4ada](0ef4adab775b4808319ffb3bade36cc873aae83f))
- Update module golang.org/x/tools to v0.36.0 ([c9865a3](c9865a3aecf313a855abfdb1d677815f6c99f9d4))
- Update module gitlab.com/gitlab-org/labkit to v1.25.0 ([4c1fd2b](4c1fd2b2ea88456edda19504e06162006c4b9700))

### Features

- Detect svg as binary files ([442639f](442639f0f32d49d850e12045c576238d67440176))
- Switch to using shared gitaly package ([39b2b11](39b2b11e12eb2a5d1e8af45ca97472a467131110))
- Add code parsing chunker ([25d9bf6](25d9bf646368252d434cd6f408f54c47519aaf79))
- Add start line to chunk source ([614f1b7](614f1b70c95a942a7eec2fb852ca1527a3c1205a))
- Add default reindexing value ([107d1a5](107d1a517175e41f727b6991a8a1c5c79a16c7ae))

### Miscellaneous Tasks

- Update golang version to 1.24.5 ([607f1a9](607f1a9c5174c3bf8cf7dca99a36e408c2964c3e))
- Release v5.8.0 ([3a49832](3a4983254942ddbeb34f4bf7dd302554e5023484))
- Add Go 1.25 to tests-elasticsearch matrix ([c156f14](c156f14f3d3134776affdf574237d26841d96e96))
- Release v5.8.0 ([ea73e78](ea73e78441c9885eed572f0f95f74bc36cb184b3))

### Refactor

- Move cli chunk configuration ([afdeb31](afdeb31b3658d72ecd9df04309cdfb9e365a4824))
- Improve indexer test coverage ([d67c54b](d67c54b3ea819f7a2e92a94b5f8b301a4c345edf))
- Improve chunk tests with tables ([ebdf2d4](ebdf2d48f59920db882ea2e32244cb8baf53b4a8))
- Fix chunk test when elastic is not available ([19ca729](19ca729b382c16458ca15a5b743958f174b1418f))

## [5.7.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.6.0...v5.7.0) (2025-07-10)

[4e6fecc](4e6fecc4a6d259dd989c6a7eda1b7f56a9564b4e)...[740bfe1](740bfe1be1e406362a9b01c20a61e07fb266225f)

### Bug Fixes

- Elasticsearch indexer streaming and flushing ([dfe0609](dfe06097b467a0db1ad2a3e1b8c99075840e84ef))

### Dependencies

- Update module gitlab.com/gitlab-org/labkit to v1.24.1 ([211fce4](211fce44954251bf8e88210f1adca824e94b17d4))
- Update dependency node to v22.17.0 ([6ce0fe2](6ce0fe2530456a5924c628b805f3318b22cdf54f))

### Features

- Add vector store indexer for Elasticsearch ([81dee24](81dee2413011131151fb10e8666c0766b16845bb))
- Add gitaly files reader module ([24a9c93](24a9c93dcf28c4d63b82b5e9d36039043c1f5f9d))
- Elasticsearch indexer handles orphaned data ([103d6be](103d6bef7788804f657a6535d340c5a763c8f476))
- Elasticsearch indexer store id ([05964a3](05964a35145d73732374b6445db496c4a2fa9121))
- Add binary file detection to chunk mode indexing ([026b40c](026b40c274d326bcda1d84b3a40331876257b4e7))
- Add elasticsearch chunk indexer tests ([e01c3c7](e01c3c770e1ff7e89531fc87624e5358d925ac76))

### Miscellaneous Tasks

- Use --unreleased arg for dry_run ([0628a25](0628a253f32386988b645db388a7d935e168a3ee))
- Update go version to 1.24.3 ([c71fa95](c71fa955d27a4baca645efb18d95f45bba77f73e))
- Add OpenSearch 3 to CI matrix ([744d942](744d9420b8d3fd2d354b908f41bf4f73e14b54c9))
- Release v5.7.0 ([cca15d1](cca15d1a1c7dfca6a05452c048ffe453a9a2deff))

### Refactor

- Add context cancellation for GetRawChanges ([733c08e](733c08e397389322f179b15077a801ac5b57fb87))
- Add GetSource function to Chunk type ([9deb0fd](9deb0fd76acdb26b4737e7b059bd0b822902f36c))
- Update chunk.Run for better maintainability ([881dcfd](881dcfd3e2a10a07fa689f009cd56500d88c16af)), refactor:pass context to the bulkDel and bulkPut functions, refactor:refactor bulk indexing calls
- Update streamer close ([234b5ae](234b5aeff9ffaac75a87c87a90eb8443ab302f9b))
- Apply review suggestions ([8ed02d1](8ed02d16590dc41b3253cd158a58b0ec9a43247a))
- Apply review suggestions, avoid lint errors ([a37ff3a](a37ff3ac8800001b17b9e69c6ef240dfa40252a0))
- Update error messages, use NewChunk ([c5d552b](c5d552b4392e1b7f5acfe4b8892b5a0edd0c1527))
- Use ChunkIndexer instead of Chunk ([e58a9b4](e58a9b45d7ba6ae9547ea391d697dcc0dd55f554))

## [5.6.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.5.1...v5.6.0) (2025-06-10)

[204aaa1](204aaa1f901131ddda0d967d7d94bea9d656eb29)...[4e6fecc](4e6fecc4a6d259dd989c6a7eda1b7f56a9564b4e)

### Bug Fixes

- Fix makefile & extract env var name to const ([15ee572](15ee572c17c4fd366ec32772ce65e94c4ea37ce1))
- Linter failure ([ed34a06](ed34a06202b4f28a90fed6d127eb7212a00531a7))
- Resolve infinite loop error ([982ac59](982ac5939e8490f4857c4bdfab2beb38b52276fa))

### Dependencies

- Update Gitaly client dependency ([48f93ef](48f93ef169c5109e1c74190583394f06e1aea5e5))
- Update dependency golangci-lint to v2.1.5 ([776ab0d](776ab0d91332cc407a3dc1690df336c550f75059))
- Update dependency golangci-lint to v1.64.8 ([d6f8918](d6f8918c7037497fcbfa367c0d02b7de9e909f0a))
- Update module github.com/gin-gonic/gin to v1.10.0 ([1ebd133](1ebd13347f3277d564fa4133867eeb0d72c5ff42))
- Update module golang.org/x/net to v0.40.0 ([077c952](077c95243000d15cd5a60309bdd0cd55f9320dfe))
- Update module golang.org/x/tools to v0.33.0 ([c30fd16](c30fd1639817eed720bcbf80ddc3af13b2203b18))
- Update module google.golang.org/grpc to v1.72.1 ([8d7acc7](8d7acc7f2434cd21301dd65a7f5980dfa5f72b6a))
- Update dependency node to v22.15.1 ([f39c4ea](f39c4ea2223fb2cbdace26724ef74d8a5d6858d5))
- Update dependency node to v22.16.0 ([70eb1b8](70eb1b88fbb1ac4089b08d2513fb9eb03b654971))
- Update module google.golang.org/grpc to v1.72.2 ([f59e59e](f59e59e0249e556730fdcd504be7aa76d04ada96))
- Update module google.golang.org/grpc to v1.73.0 ([d32fdc4](d32fdc4c314e5307744d6bd71dcac08b32833ccc))

### Features

- Add mode support to the project ([0c8b09f](0c8b09f2fc535405aa2ecda166202dcc7819e021))
- Add initial chunker options ([0cc999a](0cc999a78523c17b45b6dd2508e9d525170836b8))
- Add structured streaming to chunk mode ([13e8080](13e808023399c8e18e67f2695dbee5b2a00f4350))
- Add timeout to chunk mode ([1b9eb33](1b9eb33a9f3aaf0adda2c250c59432d5d1ddf7cb))
- Add size chunker ([d34788c](d34788c49b72ee8724e8e2701e51fc0487a0ac96)), chore:lint and format, test:test the chunker.ChunkBySize function
- Add vector store clients ([0f08c78](0f08c78cefc2d22fff7e6c1dcacf9f69b6e32d53))
- Add tests ([ac1017a](ac1017a77ba3306130a3269ebdd279aef81a676f))
- Apply patch ([94074a4](94074a41c0950c317bd0b22541c8ab1a38fe6423))
- Opensearch client ([e917259](e9172590ea1f3175625da9ca4637cd30b65b511a))
- Add postgres client ([c16de63](c16de639a5da2130cc32505e7054da7613ad5139))

### Miscellaneous Tasks

- Use GITLAB_DEPENDENCY_PROXY except if author is project bot ([6b49f7b](6b49f7b42640e2f56061772a2588c4cc7af534ce))
- Add watch-test ([2b0efb8](2b0efb89ada1a5d367f1d02a7e09e1e7b6185d15))
- Add go-fmt linter ([feb84bc](feb84bc289cfb277ed02c21e4a3a1c2d7f111453))
- Add golangci-lint to .tool-versions ([6a90c64](6a90c64f67ec8c03e8e886a1a2863caec4a83ceb))
- Apply reviewer's suggestions ([63e26bf](63e26bf28979d5bdb3bead3e26ed4376ab273b9c))
- Remove not needed build constraint ([30422d6](30422d67cf4837beac716d00399885ffd52384f6))
- Add check tool versions job/lefthook ([5440bff](5440bff4ca4fdba48d5dd251eaf9928cae7ebd0d))
- Add mr title lint ([5b23e27](5b23e27b54638c69cf8e7e6e1f4efff829adde34))
- Update README ([e617af3](e617af39a819d77d42f8c6672c87e71c069b71e3))
- Add tag CI job ([11afa41](11afa4151ee434f5aee117c1bb53a28165163cfd))
- Upgrade go version to 1.24.2 ([e76b76b](e76b76b68353be302b718e35cbe315ec9ae233c0))
- Make sure CNG build go version is compatible ([b6a5e0f](b6a5e0f520283058c7d1233b119fdac6220b55c9))
- Allow failure in go version compatibility CI job ([eab01a9](eab01a9ee0ab3d512cf2d685e66498b0d76d78c1))
- Release v5.6.0 ([ad6855b](ad6855bdf1da4308ec2c48b20a83088193106972))

### Refactor

- Simplify & extract shared package ([fcf37e6](fcf37e660682eaab77d338e00d95c03aa32b3f63))
- Move packages to internal/mode/advanced ([71a5409](71a54090964e4d563cc26e4ff4ccb93e7da8ac73))
- Move shared package ([3b5d222](3b5d222ab0ac99311dcbb89ac22dc0b5fc7ab8dd))
- Patch for Size chunker ([227fbfc](227fbfc7bb2e0895776aa73385035e7d596ed693))
- Expose chunker.ChunkFile function instead of ChunkContent ([0901958](0901958f7221e276ee9d8819cb9306b1ed73e919))
- Check options in New, consider ChunkOverlap ([a53967a](a53967a6810445afdd86511aa06e0f3cf1fb756d))
- Make ChunkFiles private, rename fields, update tests ([534bcfc](534bcfceac130b5c807b0aa3d1ba64e128668d42))
- Use context in the SizeChunker ([a586e01](a586e011840aa5d8fe642760215214dc68da1520))
- Use int for the ContentType ([161b785](161b785a63f2c71339f8080bab0c118e67a02ec1))
- Patch for feat: add size chunker ([fb68569](fb68569611e2e81cf55b055317d4dd87a7c6c37d))
- Use only filename for content name ([7ccf3d6](7ccf3d6b27255d76756b1f179d65955470f08fb4))
- Minor updates ([4ab61b1](4ab61b1ff480de46de8eb6a166b38c15ff28e192))
- Fix spec ([9b0604d](9b0604d7dfe32579b4445308853c7cc4e30ba1fa))
- Add more tests ([e5aac83](e5aac83fd52789a5d49d891bc36c6ed116e7442a))
- Fix spec ([d51f24a](d51f24a7354e1090488940ff8063ba0487f844fa))
- Fix test ([1b7194c](1b7194c3068279534da0f92ab336b3ced2384b09))
- Apply reviewer feedback ([77d1177](77d1177f520afad7d4438189a3ffc941c4d497b2))

## [5.5.1](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.5.0...v5.5.1) (2025-04-24)

[36f2208](36f2208a6013e21a9df09d83178763cef8f7f3ae)...[204aaa1](204aaa1f901131ddda0d967d7d94bea9d656eb29)

### Bug Fixes

- Fixup! chore: automate release process ([04a8ce1](04a8ce1606e4b14ae019f04a975252f540992926))
- Fixup! chore: automate release process ([4ce749b](4ce749befa32600fb82b07e81acb6d8f5cf8a7f6))

### Dependencies

- Update dependency golangci-lint to v1.64.8 ([1746503](174650388ddc29ac49aecac58201db7e6fde9f25))
- Update module gitlab.com/gitlab-org/labkit to v1.23.2 ([d7ae336](d7ae3367e47589fed760d24bc9de8fe78576238a))
- Update dependency golangci-lint to v2 ([097dd5e](097dd5ed8a1f3b2c0d6ed2dd1322f288f4f280be))
- Update module golang.org/x/net to v0.38.0 ([9a208f2](9a208f278a09f81edfce66d664839ecbe13adac6))
- Update dependency danger-review to v2.1.0 ([e24e689](e24e689575a3cc29ef1ddfd13527de2cef77c8e4))
- Update module golang.org/x/net to v0.39.0 ([db2ce82](db2ce82e2c6da283d33fdf9e2dd5c41d524c5965))
- Update module google.golang.org/grpc to v1.71.1 ([e535393](e5353934fe0b98ecbc002b077f4f998b3efc8297))
- Update module google.golang.org/grpc to v1.72.0 ([7dc00d0](7dc00d05adc54def395fad398b4d334354ac0a28))
- Update dependency node to v22.15.0 ([921c74d](921c74da87153244a2d92c1125a2ed817b18f393))
- Update module github.com/aws/aws-sdk-go to v1.55.7 ([c2e1f86](c2e1f867b1a616483e630c99c558d27e8d64d72a))

### Miscellaneous Tasks

- Update es to 8.17.2 ([f9585f2](f9585f2f1952c4580ab72bd444c1b1797da12a54))
- Upgrade to 8.17.4 ([b822189](b822189dde4608982cecb3a4e77ffcc9b5560446))
- Use dependency proxy in ci for images ([4c2ecfe](4c2ecfe6e2b37ea66a6951c3ff8743ed494f8ce9))
- Automate release process ([dd804f5](dd804f5e0c96b83d5f6b4f77e7f1b0a646bcbcd5))
- Fix release MR script, check if unshallow is needed ([6768722](67687222fec9643d8b6a981ad388de3bef1ea951))
- Release v5.5.1 [skip ci] ([cf365bb](cf365bb31042891de2b6c25d7dee6aee4dc6cbd6))

### Refactor

- Apply changes to cliff.toml ([3453991](3453991bfbb2e7dbdfda2518b6b429495af25ed1))

## [5.5.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.4.0...v5.5.0) (2025-03-18)

[7a0d81c](7a0d81c7be6022c36902736fb83261b478f95d9f)...[36f2208](36f2208a6013e21a9df09d83178763cef8f7f3ae)

### Dependencies

- Update module github.com/stretchr/testify to v1.10.0 ([31db711](31db711b469b6e55fc2801a30284263fd430f183))
- Update dependency node to v22.12.0 ([c3a4cac](c3a4cac90c03d6e1f082043b4404f38a5aa4e09b))
- Update dependency danger-review to v2 ([81fa478](81fa478a7b84233834a28c96ed76673a95cdd228))
- Update dependency golang to v1.23.4 ([093c130](093c130c9b1fa80800844788d977ab924d13c3bc))
- Update dependency node to v22.13.0 ([e4fc5e5](e4fc5e5a75b02a34ba0ecd1e3195f91731115420))
- Update dependency node to v22.13.1 ([18a3120](18a3120caea8c7f56f8211d44bff63701b1e1738))
- Update module github.com/aws/aws-sdk-go to v1.55.6 ([5a154bd](5a154bdbbc8d73062c38fd10e6244a89deaaa769))
- Update module golang.org/x/net to v0.31.0 ([27f4cb1](27f4cb10c266a6640ec447223e069369066a9e6b))
- Update module golang.org/x/net to v0.34.0 ([fee4b66](fee4b668549e8a152c7b7d4c2ba0b2d4d58ef06c))
- Update module github.com/go-enry/go-enry/v2 to v2.9.2 ([eb5d79c](eb5d79cb32f9acf29f51a44e34fd580375c8fece))
- Update module golang.org/x/net to v0.35.0 ([c7bd90d](c7bd90d25018a2fe0e0cb551e9552df501895146))
- Update dependency node to v22.14.0 ([919c8b2](919c8b2ae339a2cc425cfec1a3b45d9fd1d9747d))
- Update module gitlab.com/gitlab-org/labkit to v1.22.0 ([f15f867](f15f8675c802d33726a1f95c4a93c1ed092ae9e3))
- Bump go version to 1.23 & tools-versions ([966ae65](966ae65ea3118ba4a1d7bbebefd66a5c6da62bf2))
- Update module google.golang.org/grpc to v1.71.0 ([aa1d395](aa1d395bf48af6b5ab83977da53b613eb02c141c))
- Update dependency golangci-lint to v1.64.7 ([99779c0](99779c0d6c3ebb140729bffd2ea2c43a500d07ff))
- Update module gitlab.com/gitlab-org/labkit to v1.23.0 ([dc83373](dc83373bf386747b538249355005697eabde213e))
- Update Gitaly client to include DNS lookup change ([9843916](9843916adb9629dd0ebd616b0b21099a64e2d69b))

### Miscellaneous Tasks

- Move package job to its own stage ([f32785b](f32785b7c33446730807d14b2e854554bdd5fbc3))
- Update CONTRIBUTING.md to replace `GitLab B.V.` with `GitLab Inc.` ([71b3ef2](71b3ef2d5677781104fc7801f8d959456a032c64))
- Update LICENSE.md to replace `GitLab B.V.` with `GitLab Inc.` ([700f2c6](700f2c6254bbf04ac540f3b31f0e9d5f3f0ac6e5))
- Update release process tag warning ([42ffb24](42ffb24ac18370fe696f693802a211f2770320d9))
- Version 5.5.0 ([1efc21c](1efc21c50170fb1c63a138d387b6f6e908965049))

### Refactor

- Remove ruby from tools-versions ([b623e1d](b623e1de74f53b971c1b64c068b73608383264f1))

## [5.4.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.3.0...v5.4.0) (2024-11-06)

[a4aab7f](a4aab7fbaa46dc99abe611a2a460c32bedd7fa36)...[7a0d81c](7a0d81c7be6022c36902736fb83261b478f95d9f)

### Bug Fixes

- Add missing library to build with libicu 76 ([9a58107](9a5810763d4e7bebcb971b3d2b5a258441783090))

### Dependencies

- Update dependency golang to v1.23.2 ([107dc5b](107dc5b04bf9e8a14571a9a0a2fc32e3f9567f62))
- Update module google.golang.org/grpc to v1.67.1 ([3eade4f](3eade4fc3ee753d9915ea78f3038c7212c0076f6))
- Update module golang.org/x/net to v0.30.0 ([0e5f8a0](0e5f8a0752730f4f374e08b4c757bb502b785c5e))
- Update module github.com/go-enry/go-enry/v2 to v2.9.1 ([d4fd35a](d4fd35abb7cb39a03246832ae73bff39fe4d2b97))
- Update dependency node to v20.18.0 ([85d7686](85d768691add94655129e00f002711497f1c75a0))
- Update dependency node to v22 ([26ddcb1](26ddcb1791b56ae1ee2b323c2377c4bfdd8ae005))

### Miscellaneous Tasks

- Add semantic-release config ([b16ad4b](b16ad4b6da9f124597e350ac6e95a899a91944ad))
- 5.4.0 ([d8fe556](d8fe556f75a7e1c381510ffdffa3115557f60d33))

## [5.3.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.2.0...v5.3.0) (2024-09-27)

[14b0000](14b00006696474cc3a0e42c43f1cf8b1bd63914c)...[a4aab7f](a4aab7fbaa46dc99abe611a2a460c32bedd7fa36)

### Bug Fixes

- Log warning for UTF encoding ([0d16c06](0d16c067389cb88687bcb59f61044ce84da5eced))

### Dependencies

- Update module github.com/aws/aws-sdk-go to v1.54.19 ([d1cb567](d1cb567a666721295724990c173be5b8dda18c5d))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.11.6 ([454ba51](454ba51e90ddc6ac77d5905ec22c328a3ce4f2ca))
- Update module github.com/aws/aws-sdk-go to v1.54.20 ([17d19e7](17d19e7cdfcab403c285ae4ddaff01aba0729288))
- Update module github.com/aws/aws-sdk-go to v1.55.0 ([642ffb8](642ffb8803a4b623c06ee4631b68aad4d1a8cd37))
- Update module github.com/aws/aws-sdk-go to v1.55.1 ([2b0c4e5](2b0c4e57517483e879ecf32abfe5abda86bebb14))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.11.7 ([b58dae7](b58dae7f0e9d2e9e1a8623772128f2c58a231e4b))
- Update module github.com/aws/aws-sdk-go to v1.55.2 ([23decfe](23decfeb75528b5f26810967dd364e71e85d18ae))
- Update module github.com/aws/aws-sdk-go to v1.55.3 ([e369b31](e369b318445dd7291f9e62349d7108cd2d49fd98))
- Update module github.com/aws/aws-sdk-go to v1.55.4 ([eb95adc](eb95adccca646e771d75e1ce037f628aa623f149))
- Update module github.com/aws/aws-sdk-go to v1.55.5 ([0eb3346](0eb33467b1b24800ba2c5ba780d1460dd83e78d8))
- Update dependency golang to v1.22.6 ([4529f63](4529f63f3cc8ba4f777f33ea22254c3bba0ae45a))
- Update module golang.org/x/tools to v0.24.0 ([eff91a0](eff91a0a7b5ed0eb3f3585d0dad2de2f318fa897))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.11.8 ([d103247](d103247129b2f756b39ee01283c404297869c1b2))
- Update dependency golang to v1.23.0 ([09ebfb3](09ebfb30508222106f2fc1a01fd6b0e10b783166))
- Update module github.com/go-enry/go-enry/v2 to v2.8.9 ([90b168c](90b168cd63e44569b437fbb95c3e3fc9add74ec2))
- Update module google.golang.org/grpc to v1.66.0 ([5e8bf95](5e8bf9517905f7e288e27278b41a67ca0c786b46))
- Update dependency golang to v1.23.1 ([c7b9a76](c7b9a76d679fcfafe1ee3740e4b2ab63f714a67a))
- Update module golang.org/x/net to v0.29.0 ([ece6976](ece6976588abad3197435f0df16be57569467b7a))
- Update module google.golang.org/grpc to v1.66.1 ([1c23a58](1c23a583c9043c03fa00311747aa96e00434e82d))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.11.9 ([2642125](2642125ffbc872d36cd37b09779b94fe662a9944))
- Update module google.golang.org/grpc to v1.66.2 ([474fd20](474fd200b244c36eb29a094f344acf11decf4ee2))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.11.10 ([e0ad922](e0ad922157f5c7ea8f8f3138978eb177e548ea6b))
- Update module github.com/go-enry/go-enry/v2 to v2.9.0 ([5f8b855](5f8b85560d8bf5238f0356b0c116851315d20cad))
- Update module google.golang.org/grpc to v1.67.0 ([57845a4](57845a4f05f5713bbb4dfa89700bb8b152bcdcd4))

### Features

- Release 5.3.0 ([d8abe52](d8abe520cdc2519118e5ddb1f9d84441189d84eb))

### Miscellaneous Tasks

- Update Golang 1.22 ([7b1acd3](7b1acd3299e3d22939fa4fafb1adeda869bc1e16))
- Remove obsolete version attribute ([aea758e](aea758ecd824ae2f2202058a06298e3dee7739d5))
- Update Debian version ([db9df37](db9df37a3744cdf130c266d76ca02be45e51460b))

## [5.2.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.1.0...v5.2.0) (2024-07-11)

[7a58942](7a58942737eab521f85b0134733544169f9f35d0)...[14b0000](14b00006696474cc3a0e42c43f1cf8b1bd63914c)

### Dependencies

- Update module github.com/aws/aws-sdk-go to v1.53.21 ([a83d017](a83d017aead68784c7fd4dc882042c57631f4c54))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.11.4 ([61b4708](61b47086d544bc5a46f7262f96515f736c5f5454))
- Update module github.com/aws/aws-sdk-go to v1.54.0 ([fdfc819](fdfc8191aec3b271ae52e876de9e33ba9bd196fc))
- Update module github.com/aws/aws-sdk-go to v1.54.1 ([122b867](122b867731194b5d4e03eefcf36098b97dda7bcf))
- Update module github.com/aws/aws-sdk-go to v1.54.2 ([4a6a91b](4a6a91b2a8942f6413b652cd175082709e104c8a))
- Update module github.com/aws/aws-sdk-go to v1.54.3 ([80ab08e](80ab08e11580e25d1378aeb6aab3cfc55bfd6a29))
- Update module github.com/aws/aws-sdk-go to v1.54.4 ([c4f3b32](c4f3b322edd1c7309d91c4b16da468afdbce41c9))
- Update module github.com/aws/aws-sdk-go to v1.54.5 ([4ae0dbc](4ae0dbc82c0bdcf3b87ccdf74dfb5a074f6eeb5f))
- Update module github.com/aws/aws-sdk-go to v1.54.6 ([bd1cf60](bd1cf608d1d874d5597d21e7c800b01bc640b33c))
- Update dependency danger-review to v1.4.0 ([326e7d8](326e7d857f27d8645031f6bca8235a9ff3519520))
- Update module github.com/aws/aws-sdk-go to v1.54.7 ([8d7e9c9](8d7e9c9aa59f23effff2bae1d427913b76cbaa9b))
- Update module github.com/aws/aws-sdk-go to v1.54.8 ([50178dc](50178dcaa209f484bf0d0757077790cd8f96d534))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.11.5 ([265142d](265142dd647b9b44b421bfb635331d673f36ac1b))
- Update module github.com/aws/aws-sdk-go to v1.54.9 ([21c742a](21c742a239fea8211aad3299088d6bd202cd81e5))
- Update module github.com/aws/aws-sdk-go to v1.54.10 ([4b0c37b](4b0c37b076011e25b85a60e110c145eb4b868dce))
- Update dependency danger-review to v1.4.1 ([b6d37c1](b6d37c1634f294ada5db48a683dfe77a0c49612a))
- Update module github.com/aws/aws-sdk-go to v1.54.12 ([affc4c6](affc4c64150b781c7b9a03cf3ee1049a22462ded))
- Update dependency golang to v1.22.5 ([2e7f719](2e7f719a4b437dc3084e226af50b4c3ff6914fb4))
- Update golang to v1.22.5 ([8a6b275](8a6b2753d16311343046b3b8859cef64edb03ea5))
- Update module google.golang.org/grpc to v1.65.0 ([2ed4577](2ed4577700ce0333cb0ee5046ce1e106a3c6a7fa))
- Update module github.com/aws/aws-sdk-go to v1.54.14 ([6990dea](6990dea2c037fd533f875175d17e9c1c28e4cf5b))
- Update module golang.org/x/net to v0.27.0 ([9b4f5c0](9b4f5c068d7449464da33a89b071c7e1cc5e5c5b))
- Update module golang.org/x/tools to v0.23.0 ([796986e](796986edb8dd2c580a1277555a4ffbe7d165f69d))
- Update module github.com/aws/aws-sdk-go to v1.54.15 ([edab04f](edab04f3b5dc7a5aa887e5290bcf421e05945409))
- Update module github.com/aws/aws-sdk-go to v1.54.16 ([be7e17d](be7e17d9485a2e98dddfc5626e3e05ac6c285337))
- Update module github.com/aws/aws-sdk-go to v1.54.17 ([956a3d8](956a3d8a2f9cfb3e0fb2f137873624602a5209a1))
- Update module github.com/aws/aws-sdk-go to v1.54.18 ([5a64d88](5a64d8814f804234f23e0b34f33d7cdfc21e4954))

### Features

- Release 5.2.0 ([a58f515](a58f5150b32cf6f5e60ed4a5bd3a7e4f6365cdb2))

### Miscellaneous Tasks

- Use the danger-review component ([409afa5](409afa55edbea8830e789f6f36145e2e4d029576)), Signed-off-by:Rémy Coutable <remy@rymai.me>

## [5.1.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v5.0.0...v5.1.0) (2024-06-11)

[4cb1c8c](4cb1c8c5f129c19c8e5cbc5e7b95ba72f4a3ded2)...[7a58942](7a58942737eab521f85b0134733544169f9f35d0)

### Dependencies

- Update module github.com/aws/aws-sdk-go to v1.53.0 ([d48a0e3](d48a0e3fae5dcef7d46084608e646735aa564ede))
- Update module github.com/aws/aws-sdk-go to v1.53.1 ([0d2c2c4](0d2c2c46ffdd7f857b9062f56facdac24e408c91))
- Update module github.com/aws/aws-sdk-go to v1.53.2 ([a1240b1](a1240b12628abfb3283158369c30a82d4ad0e7d9))
- Update module google.golang.org/grpc to v1.64.0 ([1c229e9](1c229e965c87b8dd6c10c970860bb5eeb34a1b53))
- Update module github.com/aws/aws-sdk-go to v1.53.6 ([273259f](273259f1dafce090d8f3d2d83da1da204f446f4e))
- Update module github.com/aws/aws-sdk-go to v1.53.7 ([e72c082](e72c082a49056d0fa8fce29d3da24510f4baabfe))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.11.3 ([8e244df](8e244dfe1db5efa30fb9e94b9f81c8d93a47086d))
- Update module github.com/aws/aws-sdk-go to v1.53.9 ([a931ae5](a931ae52b7dc20d5709c835739fbf2f62f15bf6d))
- Update module github.com/aws/aws-sdk-go to v1.53.10 ([4b2e0cf](4b2e0cf1b0234f28b77e1ec890c4d45a16f709af))
- Update module github.com/aws/aws-sdk-go to v1.53.11 ([3d85199](3d8519986f8b83c08e2e080e57c0604b2d2cc089))
- Update module github.com/aws/aws-sdk-go to v1.53.13 ([42d9f79](42d9f79ebcb6e9baa56677cad6a647d049283d67))
- Update module github.com/aws/aws-sdk-go to v1.53.14 ([20ceace](20ceaceff5a9432d6f5c4f128455f295c73eb5e3))
- Update module github.com/aws/aws-sdk-go to v1.53.15 ([5109a2a](5109a2a9730cc248de8e19f2037bbd1513775649))
- Update module github.com/aws/aws-sdk-go to v1.53.16 ([9f98f82](9f98f822936103cac77d2e67e174c83cfb51722c))
- Update dependency golang to v1.22.4 ([47c4f1d](47c4f1d64a71b58a40d53b5418ec28c8bbdab367))
- Update module github.com/aws/aws-sdk-go to v1.53.17 ([fdb79ee](fdb79ee5a42b2e2e8e5d2901dd3a3b8bf21d68be))
- Update module golang.org/x/net to v0.26.0 ([3152277](315227780290f98d9d05d87aed90f46f4781f206))
- Update module golang.org/x/tools to v0.22.0 ([9f6128d](9f6128d58700ed890bcc328784a8b7328878604c))
- Update module github.com/aws/aws-sdk-go to v1.53.18 ([d5cd07d](d5cd07db18ebd1aabd58026fabce6abd0b928972))
- Update module github.com/aws/aws-sdk-go to v1.53.19 ([d710b5a](d710b5a115b0aa200b05cfdd06803eb8b54e2725))
- Update module github.com/aws/aws-sdk-go to v1.53.20 ([3e420c3](3e420c36678a85ed194708a77db6b58e05d8337c))

### Features

- Release 5.1.0 ([ff37886](ff3788672fff9c83c20ae4289963b6e186819929))

### Miscellaneous Tasks

- Set min supported go version to 1.21 ([b73483b](b73483bce01b89751e2b5c525d45fe675763aed5))
- Remove deprecated check for commit index name ([8e8e12c](8e8e12c4cb9d1c5135016720675d45bfdc2ae9cd))

### Refactor

- Remove deprecated commit-schema-version flag ([29d59f4](29d59f48a78c7dacf4664b57b63aca043ca8ef5b))

## [5.0.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.8.0...v5.0.0) (2024-05-10)

[af5c129](af5c129ddc65fd25bd74fbb6f799f03a38348fb4)...[4cb1c8c](4cb1c8c5f129c19c8e5cbc5e7b95ba72f4a3ded2)

### Dependencies

- Update module github.com/aws/aws-sdk-go to v1.50.28 ([937c2e9](937c2e95601a0dd958bef245ffd568ea676b8f47))
- Update module github.com/stretchr/testify to v1.9.0 ([c1ee2e7](c1ee2e739a2e6adf77de9e3cae3617285fd46501))
- Update module golang.org/x/net to v0.22.0 ([0a29fea](0a29feac5658d08d7e8e3b75c29ac4c72bc712da))
- Update dependency golang to v1.22.1 ([d6fd705](d6fd7054463eae5ee7bfb462b4d5a84f054cb645))
- Update module google.golang.org/grpc to v1.62.1 ([8e986dc](8e986dccd8e38ec08f26357182b9ccae3f84bffc))
- Update module golang.org/x/tools to v0.19.0 ([f629db5](f629db590a33748001c0cb6a472a6d7662d08b84))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.9.2 ([a6c9ec6](a6c9ec65d47ec24fea03e0aaf19ca51898a99c81))
- Update module github.com/aws/aws-sdk-go to v1.51.5 ([9ed1a2c](9ed1a2c3184aa1a4abd496a77d1f82442c971c3e))
- Update module golang.org/x/tools to v0.20.0 ([9a7fceb](9a7fceb6ca2ffb3376682c69aa063dd7dbc8c520))
- Update dependency golang to v1.22.2 ([6ce94d3](6ce94d37b45d6afcb8958b137558618926c92187))
- Update module google.golang.org/grpc to v1.63.2 ([b42aa5a](b42aa5a5addd7d43b8448e36bb96b4f841b9f106))
- Update module github.com/aws/aws-sdk-go to v1.51.16 ([7b632ee](7b632ee6ab7f0fb5aea72be791f89fa510eaad6c))
- Update module github.com/aws/aws-sdk-go to v1.51.23 ([e9f5f12](e9f5f1296f5d6b7b876e1e3fd6c94d87ed5f709f))
- Update module github.com/aws/aws-sdk-go to v1.51.25 ([7e3fc07](7e3fc07f107b1ae1a8e47d5e7af4cb4330e98b8c))
- Update module github.com/aws/aws-sdk-go to v1.51.30 ([30dc806](30dc80698abf4a23aaefffe8a2214f4635e3ecc0))
- Update module github.com/aws/aws-sdk-go to v1.51.31 ([aee15ca](aee15ca257389795d0e96151956c29cb502ca4e6))
- Update module github.com/aws/aws-sdk-go to v1.51.32 ([e062cb0](e062cb02975fb07b9e30aafb2426c517be473e71))
- Update module github.com/aws/aws-sdk-go to v1.52.0 ([acbf312](acbf31246b30eda9f01b9be7c34f7a86e312d2ee))
- Update module github.com/aws/aws-sdk-go to v1.52.1 ([09135be](09135be36289b4f378f2ec4d2ef942771cfba20a))
- Update module github.com/aws/aws-sdk-go to v1.52.2 ([4d27bbf](4d27bbf7d47b8e4a709c78c18a713c7034ff4e9b))
- Update module github.com/aws/aws-sdk-go to v1.52.3 ([398d798](398d798f793437b6b3713faeb54401b4a8ac66c8))
- Update module golang.org/x/net to v0.25.0 ([ebe6ca8](ebe6ca8daad4f84a32c82e1e2bc969ab31e9d312))
- Update module github.com/aws/aws-sdk-go to v1.52.4 ([18862ad](18862ad9338462266dc4efd94670c8e6b14c5779))
- Update module github.com/aws/aws-sdk-go to v1.52.6 ([50d41d3](50d41d3c889e650801bdc10e4838329de3842da8))

### Features

- Release 5.0 ([87d53be](87d53be7602f9bb14fd99fcfe4921e39da6b1b0c))

### Miscellaneous Tasks

- Upgrade ci elasticsearch version to 8.11.4 ([aad4f87](aad4f87b21c4cdaf7ad49f587243e659bbe52ffc))
- Update ci to use go 1.21.9 and 1.22.2 ([73de42e](73de42e164b086a9ab21837dfe04ceb903dc87f6))
- Remove code for separate wiki index ([c599834](c5998343ae6eccd70205fca90a0c89b2a9998cd0)), Changelog:removed, EE:true

## [4.8.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.7.0...v4.8.0) (2024-02-29)

[ec83325](ec83325f1844d49f07b0723b5ae0abd59247aa6d)...[af5c129](af5c129ddc65fd25bd74fbb6f799f03a38348fb4)

### Bug Fixes

- Resolve linter errors ([d6a87bf](d6a87bf80b7afdcb0b7c5dfc038da8e7e4310720))
- Add support for SHA256 repositories ([6fca430](6fca4306d9b103ea9aa00aec6068ec7256a78e23))

### Dependencies

- Update module github.com/aws/aws-sdk-go to v1.50.10 ([2c82bae](2c82bae92cb3e0424a21c8dfa139310243b6a918))
- Update module github.com/aws/aws-sdk-go to v1.50.12 ([bb2496c](bb2496c432873c29f634fecdb2df1294ec7e64ef))
- Use go 1.21 in linter and container ([c7c8cc0](c7c8cc0b7117f51faf801767af2f43b6324f5f37))
- Update dependency golang to v1.22.0 ([217524f](217524f73fe4240937830ba70361a0610a55205a))
- Update module golang.org/x/net to v0.21.0 ([345f5ad](345f5ad7c2b4cfff289da1523753df55bba1dffc))
- Update module github.com/aws/aws-sdk-go to v1.50.13 ([2253e22](2253e225a3047d40d86951e2bde7c7951f393ed9))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.8.2 ([53a354d](53a354d8c07b7c40f6799351ce131b5ecb2471bf))
- Update module github.com/aws/aws-sdk-go to v1.50.15 ([59fcf07](59fcf076acdd0bc5d33d087c1e1be4b60d6ba04f))
- Update module github.com/aws/aws-sdk-go to v1.50.16 ([601a71e](601a71e8fdeca77a167e471e39e3dc081ce6ad61))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.9.0 ([b96a132](b96a13271d0bae513a58ae2778c8ebcb888a572a))
- Update module google.golang.org/grpc to v1.61.1 ([1ddb467](1ddb4678c96ab32ba3823c0c84fe4cbc2d53fde0))
- Update module github.com/aws/aws-sdk-go to v1.50.17 ([5ab066f](5ab066f9bb7209793fa7efda29c5d5f6b3cbff66))
- Update module github.com/aws/aws-sdk-go to v1.50.21 ([257e9d2](257e9d25fd40b9a268c209262a63c3dae93fb25e))
- Update module github.com/go-enry/go-enry/v2 to v2.8.7 ([1ce0ff0](1ce0ff05e2d9d9501cfc5df40ba2c7a3b908293b))
- Update module google.golang.org/grpc to v1.62.0 ([7efdaa4](7efdaa4b0356602d5f45402c13d3a383b0703a78))
- Update module github.com/aws/aws-sdk-go to v1.50.22 ([7ca496a](7ca496aa0e10db929a8e162fb8492c8ff71cf50c))
- Update module github.com/aws/aws-sdk-go to v1.50.26 ([4fdb763](4fdb7636db6d7b3303f835152a75883b1ccf95ae))
- Update module github.com/aws/aws-sdk-go to v1.50.27 ([66471f9](66471f996c8403f9719af013155db4bf265e2664))

### Features

- Release 4.8 ([03c8a2f](03c8a2f7b11b6cfe0e2a901c3fef6a30bbb21754))

## [4.7.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.6.0...v4.7.0) (2024-01-30)

[f179fcd](f179fcdc776481818529868b6e69f11dcf83e323)...[ec83325](ec83325f1844d49f07b0723b5ae0abd59247aa6d)

### Bug Fixes

- Add prefix p for project wiki and g from group wiki in ID ([8ba1ff6](8ba1ff6322b66f3bf82fb5c9c71ea54b42e42074))
- Refactor the method ([cb5a074](cb5a074428d8e8e16fbdf298b488401f11ddddd2))

### Dependencies

- Update module golang.org/x/net to v0.20.0 ([b0bdb8c](b0bdb8c520cacb3404689b5356de46ee0ce1fd78))
- Update module github.com/aws/aws-sdk-go to v1.49.16 ([1c95583](1c955837ae18143028180b453030ce14a195c5f6))
- Update module golang.org/x/tools to v0.17.0 ([7e71d83](7e71d83b9825988f7740d69f8a2a620b86de33a5))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.7.3 ([4b9a466](4b9a4665f58a43b4f9791ace29070e642ad40687))
- Update module github.com/aws/aws-sdk-go to v1.49.21 ([e0dc0da](e0dc0dab94dca18a73e2bf1636cb14cf226434b4))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.8.0 ([ad74582](ad74582f3e80b2a9597d109686040615fa146b5f))
- Update module github.com/aws/aws-sdk-go to v1.49.24 ([397ae97](397ae9785e9a398b9bca802dd2fba525ebaa79c5))
- Update module github.com/aws/aws-sdk-go to v1.50.0 ([2093c66](2093c66604105188f137c23d18346a52ee9452a5))
- Update module github.com/aws/aws-sdk-go to v1.50.1 ([6379eb5](6379eb529d8d0791f7cf3579505752903b0d0a2e))
- Update module github.com/aws/aws-sdk-go to v1.50.2 ([72c9cc7](72c9cc730b31088c5f0123f55363dfac05f9e2a9))
- Update module google.golang.org/grpc to v1.61.0 ([333c3f7](333c3f733dd306270d1163ebb735b4280bf639af))
- Update dependency golang to v1.21.6 ([9f5dd29](9f5dd29bbe022747662598e748c1c6685669940b))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.8.1 ([2bfc46e](2bfc46e6f5e7b87c227b2e4c481ec20cddec14fa))

### Features

- Release 4.7.0 ([0ac45a5](0ac45a535d088a184704b9de49aa17d38adfda3f))

## [4.6.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.5.0...v4.6.0) (2024-01-05)

[dc8fee0](dc8fee04821a42d4bc8a430dd5de110f82e3ff3b)...[f179fcd](f179fcdc776481818529868b6e69f11dcf83e323)

### Dependencies

- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.5.2 ([0367d5e](0367d5ea36fa9713245ab533af1e90d1a0353613))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.6.0 ([1c6013d](1c6013d56b4e7777058f0cc5b166342c7a84b091))
- Update module gitlab.com/gitlab-org/labkit to v1.21.0 ([5f221d8](5f221d82fa1e05c27224619b254b36e2e6cb467b))
- Update module golang.org/x/net to v0.19.0 ([b1b0218](b1b0218cf3075ad4868d7c2f116be10dbb0cc82c))
- Update module github.com/aws/aws-sdk-go to v1.48.8 ([7958a7b](7958a7bf199e85a138b445b44eb512b5c4d226ec))
- Update module github.com/aws/aws-sdk-go to v1.48.9 ([8699af9](8699af9611a049e75381b89b078b57bc06a5a77d))
- Update module google.golang.org/grpc to v1.60.0 ([e8bbadd](e8bbaddb96fd4a94383e26c80b9dda11511a4804))
- Update module github.com/aws/aws-sdk-go to v1.49.2 ([71cc42e](71cc42efa3d6938f3721b0efe7385c7e629430a9))
- Update dependency golang to v1.21.5 ([2bddbde](2bddbde34813c7a19af1648a41b2c181301c32e3))
- Update module golang.org/x/tools to v0.16.1 ([bd034bc](bd034bcb4741552392be54be4a5774a1e34a2bfa))
- Update module google.golang.org/grpc to v1.60.1 ([56d1e83](56d1e830961eed4a875667ad475c6073b5f366b6))
- Update module github.com/aws/aws-sdk-go to v1.49.13 ([21b150d](21b150d59e2d6413e1d497e99bd93a1aed7c98bf))

### Features

- Release 4.6.0 ([a0860c3](a0860c38d033e10425f3a5e65bf145fab60842ce))

## [4.5.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.4.0...v4.5.0) (2023-11-10)

[f90fadb](f90fadbfc08f43faa9762be590035e5e422bc4b1)...[dc8fee0](dc8fee04821a42d4bc8a430dd5de110f82e3ff3b)

### Dependencies

- Update module github.com/aws/aws-sdk-go to v1.45.28 ([e2ac10f](e2ac10fd53910fcbd664ea4dc0813ade55cf1867))
- Update module github.com/aws/aws-sdk-go to v1.46.2 ([4d8116a](4d8116a812bd00b111e1bd2fa403e03ddbb320ca))
- Update module gitlab.com/gitlab-org/gitaly/v16 to v16.5.0 ([2bf10ef](2bf10ef4441820f958864d8d5e13ebea4d68dadf))
- Update module github.com/aws/aws-sdk-go to v1.46.3 ([3c82d4f](3c82d4f4aa31ea876be25360fd2417c0baedfc1c))
- Update module google.golang.org/grpc to v1.59.0 ([c2aa2b0](c2aa2b0c251d5d08323b5994d0d26b897e13b249))
- Update dependency golang to v1.21.4 ([876f204](876f204b1bafcfa90968f725422e01c7f3bcb102))

### Miscellaneous Tasks

- Add commitlint ([f6cf341](f6cf341acfd000e5e5b948cfc393a61b6bf57adc))

## [4.4.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.9...v4.4.0) (2023-09-27)

[cd67969](cd67969305021c5c46e875fb45a9cf4ef961ce99)...[f90fadb](f90fadbfc08f43faa9762be590035e5e422bc4b1)

## [4.3.9](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.8...v4.3.9) (2023-08-29)

[de3c442](de3c442222b48cafb5f0c4ff75ddec256b119134)...[cd67969](cd67969305021c5c46e875fb45a9cf4ef961ce99)

## [4.3.8](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.7...v4.3.8) (2023-07-24)

[5b36ce9](5b36ce903dae961cc7c0fe464ac88a01c53b6021)...[de3c442](de3c442222b48cafb5f0c4ff75ddec256b119134)

## [4.3.7](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.6...v4.3.7) (2023-07-05)

[f5b02c1](f5b02c19bc905e7759ffd3466c4daca0c1f22fbc)...[5b36ce9](5b36ce903dae961cc7c0fe464ac88a01c53b6021)

## [4.3.6](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.5...v4.3.6) (2023-06-22)

[5fea866](5fea8665c86c26ab6a075a29e5a8ce2912da9377)...[f5b02c1](f5b02c19bc905e7759ffd3466c4daca0c1f22fbc)

## [4.3.5](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.4...v4.3.5) (2023-06-08)

[99dd056](99dd0560d2ccffdb88e16637dc9412b6cc4e2bce)...[5fea866](5fea8665c86c26ab6a075a29e5a8ce2912da9377)

## [4.3.4](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.3...v4.3.4) (2023-05-31)

[d7e70ce](d7e70ce9964bdbb9955a312ff626e16e05835a95)...[99dd056](99dd0560d2ccffdb88e16637dc9412b6cc4e2bce)

## [4.3.3](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.2...v4.3.3) (2023-05-16)

[06b1b84](06b1b84c9c1b15d8ba2d25b8275f79aa64a2711c)...[d7e70ce](d7e70ce9964bdbb9955a312ff626e16e05835a95)

## [4.3.2](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.1...v4.3.2) (2023-05-05)

[127919e](127919e64124e5ecad53b49db2f046038851c289)...[06b1b84](06b1b84c9c1b15d8ba2d25b8275f79aa64a2711c)

### Makefile

- `go.mod` is the default since go 1.16 ([fb4d9d3](fb4d9d3ad1347f32c54e09a7a79fefbfe3535bd0))

## [4.3.1](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.3.0...v4.3.1) (2023-05-03)

[c0a7107](c0a71075f58bcce5fa55e3e0cf2a2106230858a4)...[127919e](127919e64124e5ecad53b49db2f046038851c289)

## [4.3.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.2.0...v4.3.0) (2023-04-11)

[f6ef8b4](f6ef8b460c59c3999baab7982a241aeab488ee45)...[c0a7107](c0a71075f58bcce5fa55e3e0cf2a2106230858a4)

## [4.2.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.1.0...v4.2.0) (2023-03-29)

[c33cd08](c33cd08b6239fb9e3bc86302f27037d00c647049)...[f6ef8b4](f6ef8b460c59c3999baab7982a241aeab488ee45)

## [4.1.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v4.0.0...v4.1.0) (2023-02-07)

[310814a](310814a9f038b5b25fa37c29aeb62e4ff34b1f4b)...[c33cd08](c33cd08b6239fb9e3bc86302f27037d00c647049)

## [4.0.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v3.2.0...v4.0.0) (2023-01-10)

[4dfd8f1](4dfd8f10c41f4a9b65b9a8197e881776c4695b90)...[310814a](310814a9f038b5b25fa37c29aeb62e4ff34b1f4b)

## [3.2.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v3.1.2...v3.2.0) (2022-12-22)

[b43e9da](b43e9da6a12a474628e4c8894eacdc3d706455eb)...[4dfd8f1](4dfd8f10c41f4a9b65b9a8197e881776c4695b90)

## [3.1.2](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v3.1.1...v3.1.2) (2022-12-22)

[191313f](191313f046d423c3972493400a70cc14bdc3d61c)...[b43e9da](b43e9da6a12a474628e4c8894eacdc3d706455eb)

## [3.1.1](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v3.1.0...v3.1.1) (2022-12-19)

[43c40ec](43c40ec09ca315dd7d67b93316f9be7c417786df)...[191313f](191313f046d423c3972493400a70cc14bdc3d61c)

## [3.1.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v3.0.3...v3.1.0) (2022-11-05)

[3e6212a](3e6212a81a2eb7f2bedf59b380a9281fa31eabc2)...[43c40ec](43c40ec09ca315dd7d67b93316f9be7c417786df)

## [3.0.3](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v3.0.2...v3.0.3) (2022-10-13)

[b21403a](b21403a0cdaea1292c796456914329673ecc3e38)...[3e6212a](3e6212a81a2eb7f2bedf59b380a9281fa31eabc2)

## [3.0.2](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v3.0.1...v3.0.2) (2022-09-06)

[13a14c6](13a14c697ada73449b9b8ed15d58b74b4d4a4d9b)...[b21403a](b21403a0cdaea1292c796456914329673ecc3e38)

## [3.0.1](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v3.0.0...v3.0.1) (2022-06-28)

[f49f8a5](f49f8a54e8a65688a749f25303479915f3029464)...[13a14c6](13a14c697ada73449b9b8ed15d58b74b4d4a4d9b)

### Miscellaneous Tasks

- Bump image for code_navigation pipeline ([de3d068](de3d06815b487f4ccdf2bdff50cd7a9b7f63ef6e))
- Start integrating go 1.18 into the CI pipelines ([fc21460](fc2146026320fed7ce6129538a5f6f1dd97f5cdd))

### Build

- Bump go to 1.17.9 for asdf users ([be2fac2](be2fac2dfe9d15b5e58758c78330c5eadfeffd16))

## [3.0.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.17.0...v3.0.0) (2022-04-02)

[ef14405](ef1440548effec15831eda2d246dacc43233cefb)...[f49f8a5](f49f8a54e8a65688a749f25303479915f3029464)

## [2.17.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.16.0...v2.17.0) (2021-12-10)

[16bf7ce](16bf7ce3b308ef505f6624cae32a9ae6b6db93ea)...[ef14405](ef1440548effec15831eda2d246dacc43233cefb)

### Miscellaneous Tasks

- Fix usage of out-of-date Gitaly version ([33f2147](33f21478bada337efddc9bf73c6a02ce912ae73a))

### Gitaly

- Convert use of deprecated path fields in RawChanges responses ([55fcb3d](55fcb3dc0067f4775d9cba7a39996699e8e48bea)), Changelog:fixed
- Upgrade protobuf definitions to v14.4.0 ([4155b2c](4155b2c6f382906077169e83e4e4505044a35948))
- Convert from CommitsBetween to ListCommits ([96717bb](96717bbe1bc60aa7ccad9c3ad35b58e9c5922d7e))

## [2.16.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.15.0...v2.16.0) (2021-10-10)

[7d536d9](7d536d99e12b8f73cd643d5e40c5ea5362f3362a)...[16bf7ce](16bf7ce3b308ef505f6624cae32a9ae6b6db93ea)

### Miscellaneous Tasks

- Install libicu-dev in code_navigation job ([834ce38](834ce385856dbdbe93beaf19db2fe8f5f3eb44fc)), error:Package icu-i18n was not found in the pkg-config search path.
- Switch to sourcegraph/lsif-go image with builtin lsif-go ([36c7bc2](36c7bc2bd959ae868f0c53a26da5adf91ceb86e9))

### Build

- Drop -i flag from test target ([b6bb128](b6bb128dae7ac3562f53dec82644451c87cb8955))

## [2.15.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.14.0...v2.15.0) (2021-09-30)

[2746781](2746781711257a278bb990f16b5a0770c6e5eed0)...[7d536d9](7d536d99e12b8f73cd643d5e40c5ea5362f3362a)

### Fix

- Remove before_script for gosec-sast job ([dc27517](dc27517050c684575f012d1115d3e5ffedf55a5f))

### Miscellaneous Tasks

- Remove go 1.15 test jobs ([6a5d6c2](6a5d6c28ce65050fe3cc9aa4f9b71357364a1b63))

### Refactor

- Move away from ioutil (deprecated) ([a1e4965](a1e496517cc6bfd30233f0903d78835147f9a8b3))

### Build

- Bump go to 1.16 ([8069f71](8069f712956f75fcb86b41a40bca88683e1fe171))

## [2.14.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.13.0...v2.14.0) (2021-09-14)

[31d8f69](31d8f69fc3155cfb266d2d8828722bf25dc8f22e)...[2746781](2746781711257a278bb990f16b5a0770c6e5eed0)

### Features

- Replace linguist with go-enry ([6a7c660](6a7c660e870d21ac104c4c9939871d9637115b0e)), note:if the content is binary, no results will be returned.
binary test is fixed accordingly

### Refactor

- Remove custom implementation of linguist ([c1e6ec0](c1e6ec09a698ea22fa46593da84f2498fc080ff8))

### Build

- Add go-enry dependency ([51b6789](51b6789e3752e0f50e797bceab5c7e7707d0509b))

## [2.13.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.12.0...v2.13.0) (2021-07-26)

[30d52c4](30d52c4119cbc45bbae57217df75c7602d294615)...[31d8f69](31d8f69fc3155cfb266d2d8828722bf25dc8f22e)

## [2.12.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.11.0...v2.12.0) (2021-05-26)

[b2b3cc7](b2b3cc76f7e0f0b97a0c05c390916727959c48be)...[30d52c4](30d52c4119cbc45bbae57217df75c7602d294615)

## [2.11.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.10.0...v2.11.0) (2021-05-13)

[d5eab9a](d5eab9a7b3693180be8b6c54350f7fbf7ce46e42)...[b2b3cc7](b2b3cc76f7e0f0b97a0c05c390916727959c48be)

## [2.10.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.9.0...v2.10.0) (2021-04-30)

[b7feed9](b7feed9299684949050f9fa2627e43b25a01403a)...[d5eab9a](d5eab9a7b3693180be8b6c54350f7fbf7ce46e42)

### Miscellaneous Tasks

- Test against Go 1.16 ([886e221](886e22155c67258e28476778f16554a2c73bb1e7))

## [2.9.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.8.0...v2.9.0) (2021-02-09)

[723c949](723c949175a3be42c1b5e40db7fbb9f1050c5bb8)...[b7feed9](b7feed9299684949050f9fa2627e43b25a01403a)

## [2.8.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.7.0...v2.8.0) (2020-11-19)

[dbf92a3](dbf92a36238af7972fd36d330405103488396974)...[723c949](723c949175a3be42c1b5e40db7fbb9f1050c5bb8)

## [2.7.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.6.0...v2.7.0) (2020-09-14)

[618ca6d](618ca6d7f7b097d6393393e46d31b53424881c7e)...[dbf92a3](dbf92a36238af7972fd36d330405103488396974)

## [2.6.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.5.0...v2.6.0) (2020-07-29)

[283e3a8](283e3a85dc74ea7d8d0f637c8b5e5a7e952c057e)...[618ca6d](618ca6d7f7b097d6393393e46d31b53424881c7e)

## [2.5.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.4.0...v2.5.0) (2020-07-22)

[6c46a0d](6c46a0d525b2d1117f17d072f13495884b81fa61)...[283e3a8](283e3a85dc74ea7d8d0f637c8b5e5a7e952c057e)

### Refactor

- Extract indexer.NewIndexer ([07ffc72](07ffc723af3a4215588d8172361dd9ae81c0ea0d))

## [2.4.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.3.0...v2.4.0) (2020-07-03)

[a9333a2](a9333a2083099b620ec4a6f65b6395626a8d4b25)...[6c46a0d](6c46a0d525b2d1117f17d072f13495884b81fa61)

## [2.3.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.2.0...v2.3.0) (2020-05-14)

[575f22f](575f22fd6b47ef74172f9cf7e825741145746c3e)...[a9333a2](a9333a2083099b620ec4a6f65b6395626a8d4b25)

## [2.2.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.1.0...v2.2.0) (2020-04-09)

[1b9554a](1b9554a7e57adbe4e577ab36b85e6a5030b35961)...[575f22f](575f22fd6b47ef74172f9cf7e825741145746c3e)

## [2.1.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.0.0...v2.1.0) (2020-02-10)

[7bcbfb9](7bcbfb9b8b23a3e2f66bfbb70e9da8738047f570)...[1b9554a](1b9554a7e57adbe4e577ab36b85e6a5030b35961)

### Bug Fixes

- Fix unit tests for oliver/elastic upgradation ([24446ea](24446ea2602a58d3ec8572dae45de027a3d1e12a))

### Elastic

- Configurable bulk concurrency and size ([3e5f0dd](3e5f0dd574ba2e18b864a743332abcb4dd2f9964))

## [2.0.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v2.0.0-dg-test...v2.0.0) (2020-01-15)

[a7789f9](a7789f9fa61f15c7444f1fb4e9e49966d8983c55)...[7bcbfb9](7bcbfb9b8b23a3e2f66bfbb70e9da8738047f570)

## [2.0.0-dg-test](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v1.5.0...v2.0.0-dg-test) (2020-01-14)

[9299f10](9299f10abb9376582e790cfe1bd54fc32d82f5b5)...[a7789f9](a7789f9fa61f15c7444f1fb4e9e49966d8983c55)

## [1.5.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v1.4.0...v1.5.0) (2019-10-18)

[3df38a8](3df38a887e953b9a4b4c2f5d34c4b2905f3df154)...[9299f10](9299f10abb9376582e790cfe1bd54fc32d82f5b5)

## [1.4.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v1.3.0...v1.4.0) (2019-10-15)

[a47f24a](a47f24a63847ee4b1a88c35b6bdb8833d42f3c52)...[3df38a8](3df38a887e953b9a4b4c2f5d34c4b2905f3df154)

## [1.3.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v1.2.0...v1.3.0) (2019-08-29)

[b5c06b9](b5c06b9233ed195e12fc651d8f22536fa5ba9aae)...[a47f24a](a47f24a63847ee4b1a88c35b6bdb8833d42f3c52)

## [1.2.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v1.1.0...v1.2.0) (2019-06-06)

[9c9addf](9c9addf888b01571f7102e32a90579c6e0fa6f33)...[b5c06b9](b5c06b9233ed195e12fc651d8f22536fa5ba9aae)

## [1.1.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v1.0.0...v1.1.0) (2019-05-16)

[cbdfd95](cbdfd953fe3daf0fa45d4f709f1783531c63a709)...[9c9addf](9c9addf888b01571f7102e32a90579c6e0fa6f33)

## [1.0.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v0.3.0...v1.0.0) (2019-01-24)

[18d11ab](18d11aba3546ff9dce6f3b15674180592ad9f104)...[cbdfd95](cbdfd953fe3daf0fa45d4f709f1783531c63a709)

## [0.3.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v0.2.2...v0.3.0) (2018-10-19)

[ab8c55b](ab8c55baf214a1950e38afeb9a53369178e64eca)...[18d11ab](18d11aba3546ff9dce6f3b15674180592ad9f104)

## [0.2.2](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v0.2.1...v0.2.2) (2018-09-07)

[81af852](81af852f0776666b22cd40afdacb2439e5606abf)...[ab8c55b](ab8c55baf214a1950e38afeb9a53369178e64eca)

## [0.2.1](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v0.2.0...v0.2.1) (2017-08-11)

[7e24e4a](7e24e4a4a33cc850d87a078e77b36e14efa93ffe)...[81af852](81af852f0776666b22cd40afdacb2439e5606abf)

## [0.2.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v0.1.0...v0.2.0) (2017-06-15)

[84fca73](84fca7340c29bd3497a482a47507bc5f62872b45)...[7e24e4a](7e24e4a4a33cc850d87a078e77b36e14efa93ffe)

## [0.1.0](https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer/compare/v0.0.0...v0.1.0) (2017-04-19)

<!-- generated by git-cliff -->
