// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/meta"
)

// Meta is the model entity for the Meta schema.
type Meta struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Key holds the value of the "key" field.
	Key string `json:"key,omitempty"`
	// Value holds the value of the "value" field.
	Value string `json:"value,omitempty"`
	// AlertMetas holds the value of the "alert_metas" field.
	AlertMetas int `json:"alert_metas,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the MetaQuery when eager-loading is set.
	Edges        MetaEdges `json:"edges"`
	selectValues sql.SelectValues
}

// MetaEdges holds the relations/edges for other nodes in the graph.
type MetaEdges struct {
	// Owner holds the value of the owner edge.
	Owner *Alert `json:"owner,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// OwnerOrErr returns the Owner value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e MetaEdges) OwnerOrErr() (*Alert, error) {
	if e.Owner != nil {
		return e.Owner, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: alert.Label}
	}
	return nil, &NotLoadedError{edge: "owner"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Meta) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case meta.FieldID, meta.FieldAlertMetas:
			values[i] = new(sql.NullInt64)
		case meta.FieldKey, meta.FieldValue:
			values[i] = new(sql.NullString)
		case meta.FieldCreatedAt, meta.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Meta fields.
func (m *Meta) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case meta.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			m.ID = int(value.Int64)
		case meta.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				m.CreatedAt = value.Time
			}
		case meta.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				m.UpdatedAt = value.Time
			}
		case meta.FieldKey:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field key", values[i])
			} else if value.Valid {
				m.Key = value.String
			}
		case meta.FieldValue:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field value", values[i])
			} else if value.Valid {
				m.Value = value.String
			}
		case meta.FieldAlertMetas:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field alert_metas", values[i])
			} else if value.Valid {
				m.AlertMetas = int(value.Int64)
			}
		default:
			m.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// GetValue returns the ent.Value that was dynamically selected and assigned to the Meta.
// This includes values selected through modifiers, order, etc.
func (m *Meta) GetValue(name string) (ent.Value, error) {
	return m.selectValues.Get(name)
}

// QueryOwner queries the "owner" edge of the Meta entity.
func (m *Meta) QueryOwner() *AlertQuery {
	return NewMetaClient(m.config).QueryOwner(m)
}

// Update returns a builder for updating this Meta.
// Note that you need to call Meta.Unwrap() before calling this method if this Meta
// was returned from a transaction, and the transaction was committed or rolled back.
func (m *Meta) Update() *MetaUpdateOne {
	return NewMetaClient(m.config).UpdateOne(m)
}

// Unwrap unwraps the Meta entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (m *Meta) Unwrap() *Meta {
	_tx, ok := m.config.driver.(*txDriver)
	if !ok {
		panic("ent: Meta is not a transactional entity")
	}
	m.config.driver = _tx.drv
	return m
}

// String implements the fmt.Stringer.
func (m *Meta) String() string {
	var builder strings.Builder
	builder.WriteString("Meta(")
	builder.WriteString(fmt.Sprintf("id=%v, ", m.ID))
	builder.WriteString("created_at=")
	builder.WriteString(m.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(m.UpdatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("key=")
	builder.WriteString(m.Key)
	builder.WriteString(", ")
	builder.WriteString("value=")
	builder.WriteString(m.Value)
	builder.WriteString(", ")
	builder.WriteString("alert_metas=")
	builder.WriteString(fmt.Sprintf("%v", m.AlertMetas))
	builder.WriteByte(')')
	return builder.String()
}

// MetaSlice is a parsable slice of Meta.
type MetaSlice []*Meta
