// Code generated by ent, DO NOT EDIT.

package machine

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the machine type in the database.
	Label = "machine"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// FieldLastPush holds the string denoting the last_push field in the database.
	FieldLastPush = "last_push"
	// FieldLastHeartbeat holds the string denoting the last_heartbeat field in the database.
	FieldLastHeartbeat = "last_heartbeat"
	// FieldMachineId holds the string denoting the machineid field in the database.
	FieldMachineId = "machine_id"
	// FieldPassword holds the string denoting the password field in the database.
	FieldPassword = "password"
	// FieldIpAddress holds the string denoting the ipaddress field in the database.
	FieldIpAddress = "ip_address"
	// FieldScenarios holds the string denoting the scenarios field in the database.
	FieldScenarios = "scenarios"
	// FieldVersion holds the string denoting the version field in the database.
	FieldVersion = "version"
	// FieldIsValidated holds the string denoting the isvalidated field in the database.
	FieldIsValidated = "is_validated"
	// FieldAuthType holds the string denoting the auth_type field in the database.
	FieldAuthType = "auth_type"
	// FieldOsname holds the string denoting the osname field in the database.
	FieldOsname = "osname"
	// FieldOsfamily holds the string denoting the osfamily field in the database.
	FieldOsfamily = "osfamily"
	// FieldOsversion holds the string denoting the osversion field in the database.
	FieldOsversion = "osversion"
	// FieldFeatureflags holds the string denoting the featureflags field in the database.
	FieldFeatureflags = "featureflags"
	// FieldHubstate holds the string denoting the hubstate field in the database.
	FieldHubstate = "hubstate"
	// FieldDatasources holds the string denoting the datasources field in the database.
	FieldDatasources = "datasources"
	// EdgeAlerts holds the string denoting the alerts edge name in mutations.
	EdgeAlerts = "alerts"
	// Table holds the table name of the machine in the database.
	Table = "machines"
	// AlertsTable is the table that holds the alerts relation/edge.
	AlertsTable = "alerts"
	// AlertsInverseTable is the table name for the Alert entity.
	// It exists in this package in order to avoid circular dependency with the "alert" package.
	AlertsInverseTable = "alerts"
	// AlertsColumn is the table column denoting the alerts relation/edge.
	AlertsColumn = "machine_alerts"
)

// Columns holds all SQL columns for machine fields.
var Columns = []string{
	FieldID,
	FieldCreatedAt,
	FieldUpdatedAt,
	FieldLastPush,
	FieldLastHeartbeat,
	FieldMachineId,
	FieldPassword,
	FieldIpAddress,
	FieldScenarios,
	FieldVersion,
	FieldIsValidated,
	FieldAuthType,
	FieldOsname,
	FieldOsfamily,
	FieldOsversion,
	FieldFeatureflags,
	FieldHubstate,
	FieldDatasources,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
	// DefaultLastPush holds the default value on creation for the "last_push" field.
	DefaultLastPush func() time.Time
	// ScenariosValidator is a validator for the "scenarios" field. It is called by the builders before save.
	ScenariosValidator func(string) error
	// DefaultIsValidated holds the default value on creation for the "isValidated" field.
	DefaultIsValidated bool
	// DefaultAuthType holds the default value on creation for the "auth_type" field.
	DefaultAuthType string
)

// OrderOption defines the ordering options for the Machine queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByLastPush orders the results by the last_push field.
func ByLastPush(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLastPush, opts...).ToFunc()
}

// ByLastHeartbeat orders the results by the last_heartbeat field.
func ByLastHeartbeat(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLastHeartbeat, opts...).ToFunc()
}

// ByMachineId orders the results by the machineId field.
func ByMachineId(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldMachineId, opts...).ToFunc()
}

// ByPassword orders the results by the password field.
func ByPassword(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPassword, opts...).ToFunc()
}

// ByIpAddress orders the results by the ipAddress field.
func ByIpAddress(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldIpAddress, opts...).ToFunc()
}

// ByScenarios orders the results by the scenarios field.
func ByScenarios(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldScenarios, opts...).ToFunc()
}

// ByVersion orders the results by the version field.
func ByVersion(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldVersion, opts...).ToFunc()
}

// ByIsValidated orders the results by the isValidated field.
func ByIsValidated(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldIsValidated, opts...).ToFunc()
}

// ByAuthType orders the results by the auth_type field.
func ByAuthType(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAuthType, opts...).ToFunc()
}

// ByOsname orders the results by the osname field.
func ByOsname(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOsname, opts...).ToFunc()
}

// ByOsfamily orders the results by the osfamily field.
func ByOsfamily(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOsfamily, opts...).ToFunc()
}

// ByOsversion orders the results by the osversion field.
func ByOsversion(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOsversion, opts...).ToFunc()
}

// ByFeatureflags orders the results by the featureflags field.
func ByFeatureflags(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeatureflags, opts...).ToFunc()
}

// ByAlertsCount orders the results by alerts count.
func ByAlertsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newAlertsStep(), opts...)
	}
}

// ByAlerts orders the results by alerts terms.
func ByAlerts(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newAlertsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newAlertsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(AlertsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, AlertsTable, AlertsColumn),
	)
}
