// Code generated by ent, DO NOT EDIT.

package alert

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the alert type in the database.
	Label = "alert"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// FieldScenario holds the string denoting the scenario field in the database.
	FieldScenario = "scenario"
	// FieldBucketId holds the string denoting the bucketid field in the database.
	FieldBucketId = "bucket_id"
	// FieldMessage holds the string denoting the message field in the database.
	FieldMessage = "message"
	// FieldEventsCount holds the string denoting the eventscount field in the database.
	FieldEventsCount = "events_count"
	// FieldStartedAt holds the string denoting the startedat field in the database.
	FieldStartedAt = "started_at"
	// FieldStoppedAt holds the string denoting the stoppedat field in the database.
	FieldStoppedAt = "stopped_at"
	// FieldSourceIp holds the string denoting the sourceip field in the database.
	FieldSourceIp = "source_ip"
	// FieldSourceRange holds the string denoting the sourcerange field in the database.
	FieldSourceRange = "source_range"
	// FieldSourceAsNumber holds the string denoting the sourceasnumber field in the database.
	FieldSourceAsNumber = "source_as_number"
	// FieldSourceAsName holds the string denoting the sourceasname field in the database.
	FieldSourceAsName = "source_as_name"
	// FieldSourceCountry holds the string denoting the sourcecountry field in the database.
	FieldSourceCountry = "source_country"
	// FieldSourceLatitude holds the string denoting the sourcelatitude field in the database.
	FieldSourceLatitude = "source_latitude"
	// FieldSourceLongitude holds the string denoting the sourcelongitude field in the database.
	FieldSourceLongitude = "source_longitude"
	// FieldSourceScope holds the string denoting the sourcescope field in the database.
	FieldSourceScope = "source_scope"
	// FieldSourceValue holds the string denoting the sourcevalue field in the database.
	FieldSourceValue = "source_value"
	// FieldCapacity holds the string denoting the capacity field in the database.
	FieldCapacity = "capacity"
	// FieldLeakSpeed holds the string denoting the leakspeed field in the database.
	FieldLeakSpeed = "leak_speed"
	// FieldScenarioVersion holds the string denoting the scenarioversion field in the database.
	FieldScenarioVersion = "scenario_version"
	// FieldScenarioHash holds the string denoting the scenariohash field in the database.
	FieldScenarioHash = "scenario_hash"
	// FieldSimulated holds the string denoting the simulated field in the database.
	FieldSimulated = "simulated"
	// FieldUUID holds the string denoting the uuid field in the database.
	FieldUUID = "uuid"
	// FieldRemediation holds the string denoting the remediation field in the database.
	FieldRemediation = "remediation"
	// EdgeOwner holds the string denoting the owner edge name in mutations.
	EdgeOwner = "owner"
	// EdgeDecisions holds the string denoting the decisions edge name in mutations.
	EdgeDecisions = "decisions"
	// EdgeEvents holds the string denoting the events edge name in mutations.
	EdgeEvents = "events"
	// EdgeMetas holds the string denoting the metas edge name in mutations.
	EdgeMetas = "metas"
	// Table holds the table name of the alert in the database.
	Table = "alerts"
	// OwnerTable is the table that holds the owner relation/edge.
	OwnerTable = "alerts"
	// OwnerInverseTable is the table name for the Machine entity.
	// It exists in this package in order to avoid circular dependency with the "machine" package.
	OwnerInverseTable = "machines"
	// OwnerColumn is the table column denoting the owner relation/edge.
	OwnerColumn = "machine_alerts"
	// DecisionsTable is the table that holds the decisions relation/edge.
	DecisionsTable = "decisions"
	// DecisionsInverseTable is the table name for the Decision entity.
	// It exists in this package in order to avoid circular dependency with the "decision" package.
	DecisionsInverseTable = "decisions"
	// DecisionsColumn is the table column denoting the decisions relation/edge.
	DecisionsColumn = "alert_decisions"
	// EventsTable is the table that holds the events relation/edge.
	EventsTable = "events"
	// EventsInverseTable is the table name for the Event entity.
	// It exists in this package in order to avoid circular dependency with the "event" package.
	EventsInverseTable = "events"
	// EventsColumn is the table column denoting the events relation/edge.
	EventsColumn = "alert_events"
	// MetasTable is the table that holds the metas relation/edge.
	MetasTable = "meta"
	// MetasInverseTable is the table name for the Meta entity.
	// It exists in this package in order to avoid circular dependency with the "meta" package.
	MetasInverseTable = "meta"
	// MetasColumn is the table column denoting the metas relation/edge.
	MetasColumn = "alert_metas"
)

// Columns holds all SQL columns for alert fields.
var Columns = []string{
	FieldID,
	FieldCreatedAt,
	FieldUpdatedAt,
	FieldScenario,
	FieldBucketId,
	FieldMessage,
	FieldEventsCount,
	FieldStartedAt,
	FieldStoppedAt,
	FieldSourceIp,
	FieldSourceRange,
	FieldSourceAsNumber,
	FieldSourceAsName,
	FieldSourceCountry,
	FieldSourceLatitude,
	FieldSourceLongitude,
	FieldSourceScope,
	FieldSourceValue,
	FieldCapacity,
	FieldLeakSpeed,
	FieldScenarioVersion,
	FieldScenarioHash,
	FieldSimulated,
	FieldUUID,
	FieldRemediation,
}

// ForeignKeys holds the SQL foreign-keys that are owned by the "alerts"
// table and are not defined as standalone fields in the schema.
var ForeignKeys = []string{
	"machine_alerts",
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	for i := range ForeignKeys {
		if column == ForeignKeys[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
	// DefaultBucketId holds the default value on creation for the "bucketId" field.
	DefaultBucketId string
	// DefaultMessage holds the default value on creation for the "message" field.
	DefaultMessage string
	// DefaultEventsCount holds the default value on creation for the "eventsCount" field.
	DefaultEventsCount int32
	// DefaultStartedAt holds the default value on creation for the "startedAt" field.
	DefaultStartedAt func() time.Time
	// DefaultStoppedAt holds the default value on creation for the "stoppedAt" field.
	DefaultStoppedAt func() time.Time
	// DefaultSimulated holds the default value on creation for the "simulated" field.
	DefaultSimulated bool
)

// OrderOption defines the ordering options for the Alert queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByScenario orders the results by the scenario field.
func ByScenario(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldScenario, opts...).ToFunc()
}

// ByBucketId orders the results by the bucketId field.
func ByBucketId(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldBucketId, opts...).ToFunc()
}

// ByMessage orders the results by the message field.
func ByMessage(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldMessage, opts...).ToFunc()
}

// ByEventsCountField orders the results by the eventsCount field.
func ByEventsCountField(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEventsCount, opts...).ToFunc()
}

// ByStartedAt orders the results by the startedAt field.
func ByStartedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStartedAt, opts...).ToFunc()
}

// ByStoppedAt orders the results by the stoppedAt field.
func ByStoppedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStoppedAt, opts...).ToFunc()
}

// BySourceIp orders the results by the sourceIp field.
func BySourceIp(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceIp, opts...).ToFunc()
}

// BySourceRange orders the results by the sourceRange field.
func BySourceRange(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceRange, opts...).ToFunc()
}

// BySourceAsNumber orders the results by the sourceAsNumber field.
func BySourceAsNumber(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceAsNumber, opts...).ToFunc()
}

// BySourceAsName orders the results by the sourceAsName field.
func BySourceAsName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceAsName, opts...).ToFunc()
}

// BySourceCountry orders the results by the sourceCountry field.
func BySourceCountry(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceCountry, opts...).ToFunc()
}

// BySourceLatitude orders the results by the sourceLatitude field.
func BySourceLatitude(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceLatitude, opts...).ToFunc()
}

// BySourceLongitude orders the results by the sourceLongitude field.
func BySourceLongitude(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceLongitude, opts...).ToFunc()
}

// BySourceScope orders the results by the sourceScope field.
func BySourceScope(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceScope, opts...).ToFunc()
}

// BySourceValue orders the results by the sourceValue field.
func BySourceValue(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceValue, opts...).ToFunc()
}

// ByCapacity orders the results by the capacity field.
func ByCapacity(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCapacity, opts...).ToFunc()
}

// ByLeakSpeed orders the results by the leakSpeed field.
func ByLeakSpeed(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLeakSpeed, opts...).ToFunc()
}

// ByScenarioVersion orders the results by the scenarioVersion field.
func ByScenarioVersion(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldScenarioVersion, opts...).ToFunc()
}

// ByScenarioHash orders the results by the scenarioHash field.
func ByScenarioHash(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldScenarioHash, opts...).ToFunc()
}

// BySimulated orders the results by the simulated field.
func BySimulated(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSimulated, opts...).ToFunc()
}

// ByUUID orders the results by the uuid field.
func ByUUID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUUID, opts...).ToFunc()
}

// ByRemediation orders the results by the remediation field.
func ByRemediation(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldRemediation, opts...).ToFunc()
}

// ByOwnerField orders the results by owner field.
func ByOwnerField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newOwnerStep(), sql.OrderByField(field, opts...))
	}
}

// ByDecisionsCount orders the results by decisions count.
func ByDecisionsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newDecisionsStep(), opts...)
	}
}

// ByDecisions orders the results by decisions terms.
func ByDecisions(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newDecisionsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByEventsCount orders the results by events count.
func ByEventsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newEventsStep(), opts...)
	}
}

// ByEvents orders the results by events terms.
func ByEvents(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newEventsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByMetasCount orders the results by metas count.
func ByMetasCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newMetasStep(), opts...)
	}
}

// ByMetas orders the results by metas terms.
func ByMetas(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newMetasStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newOwnerStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(OwnerInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, OwnerTable, OwnerColumn),
	)
}
func newDecisionsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(DecisionsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, DecisionsTable, DecisionsColumn),
	)
}
func newEventsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(EventsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, EventsTable, EventsColumn),
	)
}
func newMetasStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(MetasInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, MetasTable, MetasColumn),
	)
}
