// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/decision"
)

// DecisionCreate is the builder for creating a Decision entity.
type DecisionCreate struct {
	config
	mutation *DecisionMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetCreatedAt sets the "created_at" field.
func (dc *DecisionCreate) SetCreatedAt(t time.Time) *DecisionCreate {
	dc.mutation.SetCreatedAt(t)
	return dc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableCreatedAt(t *time.Time) *DecisionCreate {
	if t != nil {
		dc.SetCreatedAt(*t)
	}
	return dc
}

// SetUpdatedAt sets the "updated_at" field.
func (dc *DecisionCreate) SetUpdatedAt(t time.Time) *DecisionCreate {
	dc.mutation.SetUpdatedAt(t)
	return dc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableUpdatedAt(t *time.Time) *DecisionCreate {
	if t != nil {
		dc.SetUpdatedAt(*t)
	}
	return dc
}

// SetUntil sets the "until" field.
func (dc *DecisionCreate) SetUntil(t time.Time) *DecisionCreate {
	dc.mutation.SetUntil(t)
	return dc
}

// SetNillableUntil sets the "until" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableUntil(t *time.Time) *DecisionCreate {
	if t != nil {
		dc.SetUntil(*t)
	}
	return dc
}

// SetScenario sets the "scenario" field.
func (dc *DecisionCreate) SetScenario(s string) *DecisionCreate {
	dc.mutation.SetScenario(s)
	return dc
}

// SetType sets the "type" field.
func (dc *DecisionCreate) SetType(s string) *DecisionCreate {
	dc.mutation.SetType(s)
	return dc
}

// SetStartIP sets the "start_ip" field.
func (dc *DecisionCreate) SetStartIP(i int64) *DecisionCreate {
	dc.mutation.SetStartIP(i)
	return dc
}

// SetNillableStartIP sets the "start_ip" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableStartIP(i *int64) *DecisionCreate {
	if i != nil {
		dc.SetStartIP(*i)
	}
	return dc
}

// SetEndIP sets the "end_ip" field.
func (dc *DecisionCreate) SetEndIP(i int64) *DecisionCreate {
	dc.mutation.SetEndIP(i)
	return dc
}

// SetNillableEndIP sets the "end_ip" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableEndIP(i *int64) *DecisionCreate {
	if i != nil {
		dc.SetEndIP(*i)
	}
	return dc
}

// SetStartSuffix sets the "start_suffix" field.
func (dc *DecisionCreate) SetStartSuffix(i int64) *DecisionCreate {
	dc.mutation.SetStartSuffix(i)
	return dc
}

// SetNillableStartSuffix sets the "start_suffix" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableStartSuffix(i *int64) *DecisionCreate {
	if i != nil {
		dc.SetStartSuffix(*i)
	}
	return dc
}

// SetEndSuffix sets the "end_suffix" field.
func (dc *DecisionCreate) SetEndSuffix(i int64) *DecisionCreate {
	dc.mutation.SetEndSuffix(i)
	return dc
}

// SetNillableEndSuffix sets the "end_suffix" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableEndSuffix(i *int64) *DecisionCreate {
	if i != nil {
		dc.SetEndSuffix(*i)
	}
	return dc
}

// SetIPSize sets the "ip_size" field.
func (dc *DecisionCreate) SetIPSize(i int64) *DecisionCreate {
	dc.mutation.SetIPSize(i)
	return dc
}

// SetNillableIPSize sets the "ip_size" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableIPSize(i *int64) *DecisionCreate {
	if i != nil {
		dc.SetIPSize(*i)
	}
	return dc
}

// SetScope sets the "scope" field.
func (dc *DecisionCreate) SetScope(s string) *DecisionCreate {
	dc.mutation.SetScope(s)
	return dc
}

// SetValue sets the "value" field.
func (dc *DecisionCreate) SetValue(s string) *DecisionCreate {
	dc.mutation.SetValue(s)
	return dc
}

// SetOrigin sets the "origin" field.
func (dc *DecisionCreate) SetOrigin(s string) *DecisionCreate {
	dc.mutation.SetOrigin(s)
	return dc
}

// SetSimulated sets the "simulated" field.
func (dc *DecisionCreate) SetSimulated(b bool) *DecisionCreate {
	dc.mutation.SetSimulated(b)
	return dc
}

// SetNillableSimulated sets the "simulated" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableSimulated(b *bool) *DecisionCreate {
	if b != nil {
		dc.SetSimulated(*b)
	}
	return dc
}

// SetUUID sets the "uuid" field.
func (dc *DecisionCreate) SetUUID(s string) *DecisionCreate {
	dc.mutation.SetUUID(s)
	return dc
}

// SetNillableUUID sets the "uuid" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableUUID(s *string) *DecisionCreate {
	if s != nil {
		dc.SetUUID(*s)
	}
	return dc
}

// SetAlertDecisions sets the "alert_decisions" field.
func (dc *DecisionCreate) SetAlertDecisions(i int) *DecisionCreate {
	dc.mutation.SetAlertDecisions(i)
	return dc
}

// SetNillableAlertDecisions sets the "alert_decisions" field if the given value is not nil.
func (dc *DecisionCreate) SetNillableAlertDecisions(i *int) *DecisionCreate {
	if i != nil {
		dc.SetAlertDecisions(*i)
	}
	return dc
}

// SetOwnerID sets the "owner" edge to the Alert entity by ID.
func (dc *DecisionCreate) SetOwnerID(id int) *DecisionCreate {
	dc.mutation.SetOwnerID(id)
	return dc
}

// SetNillableOwnerID sets the "owner" edge to the Alert entity by ID if the given value is not nil.
func (dc *DecisionCreate) SetNillableOwnerID(id *int) *DecisionCreate {
	if id != nil {
		dc = dc.SetOwnerID(*id)
	}
	return dc
}

// SetOwner sets the "owner" edge to the Alert entity.
func (dc *DecisionCreate) SetOwner(a *Alert) *DecisionCreate {
	return dc.SetOwnerID(a.ID)
}

// Mutation returns the DecisionMutation object of the builder.
func (dc *DecisionCreate) Mutation() *DecisionMutation {
	return dc.mutation
}

// Save creates the Decision in the database.
func (dc *DecisionCreate) Save(ctx context.Context) (*Decision, error) {
	dc.defaults()
	return withHooks(ctx, dc.sqlSave, dc.mutation, dc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (dc *DecisionCreate) SaveX(ctx context.Context) *Decision {
	v, err := dc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (dc *DecisionCreate) Exec(ctx context.Context) error {
	_, err := dc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (dc *DecisionCreate) ExecX(ctx context.Context) {
	if err := dc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (dc *DecisionCreate) defaults() {
	if _, ok := dc.mutation.CreatedAt(); !ok {
		v := decision.DefaultCreatedAt()
		dc.mutation.SetCreatedAt(v)
	}
	if _, ok := dc.mutation.UpdatedAt(); !ok {
		v := decision.DefaultUpdatedAt()
		dc.mutation.SetUpdatedAt(v)
	}
	if _, ok := dc.mutation.Simulated(); !ok {
		v := decision.DefaultSimulated
		dc.mutation.SetSimulated(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (dc *DecisionCreate) check() error {
	if _, ok := dc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`ent: missing required field "Decision.created_at"`)}
	}
	if _, ok := dc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`ent: missing required field "Decision.updated_at"`)}
	}
	if _, ok := dc.mutation.Scenario(); !ok {
		return &ValidationError{Name: "scenario", err: errors.New(`ent: missing required field "Decision.scenario"`)}
	}
	if _, ok := dc.mutation.GetType(); !ok {
		return &ValidationError{Name: "type", err: errors.New(`ent: missing required field "Decision.type"`)}
	}
	if _, ok := dc.mutation.Scope(); !ok {
		return &ValidationError{Name: "scope", err: errors.New(`ent: missing required field "Decision.scope"`)}
	}
	if _, ok := dc.mutation.Value(); !ok {
		return &ValidationError{Name: "value", err: errors.New(`ent: missing required field "Decision.value"`)}
	}
	if _, ok := dc.mutation.Origin(); !ok {
		return &ValidationError{Name: "origin", err: errors.New(`ent: missing required field "Decision.origin"`)}
	}
	if _, ok := dc.mutation.Simulated(); !ok {
		return &ValidationError{Name: "simulated", err: errors.New(`ent: missing required field "Decision.simulated"`)}
	}
	return nil
}

func (dc *DecisionCreate) sqlSave(ctx context.Context) (*Decision, error) {
	if err := dc.check(); err != nil {
		return nil, err
	}
	_node, _spec := dc.createSpec()
	if err := sqlgraph.CreateNode(ctx, dc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	dc.mutation.id = &_node.ID
	dc.mutation.done = true
	return _node, nil
}

func (dc *DecisionCreate) createSpec() (*Decision, *sqlgraph.CreateSpec) {
	var (
		_node = &Decision{config: dc.config}
		_spec = sqlgraph.NewCreateSpec(decision.Table, sqlgraph.NewFieldSpec(decision.FieldID, field.TypeInt))
	)
	_spec.OnConflict = dc.conflict
	if value, ok := dc.mutation.CreatedAt(); ok {
		_spec.SetField(decision.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := dc.mutation.UpdatedAt(); ok {
		_spec.SetField(decision.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if value, ok := dc.mutation.Until(); ok {
		_spec.SetField(decision.FieldUntil, field.TypeTime, value)
		_node.Until = &value
	}
	if value, ok := dc.mutation.Scenario(); ok {
		_spec.SetField(decision.FieldScenario, field.TypeString, value)
		_node.Scenario = value
	}
	if value, ok := dc.mutation.GetType(); ok {
		_spec.SetField(decision.FieldType, field.TypeString, value)
		_node.Type = value
	}
	if value, ok := dc.mutation.StartIP(); ok {
		_spec.SetField(decision.FieldStartIP, field.TypeInt64, value)
		_node.StartIP = value
	}
	if value, ok := dc.mutation.EndIP(); ok {
		_spec.SetField(decision.FieldEndIP, field.TypeInt64, value)
		_node.EndIP = value
	}
	if value, ok := dc.mutation.StartSuffix(); ok {
		_spec.SetField(decision.FieldStartSuffix, field.TypeInt64, value)
		_node.StartSuffix = value
	}
	if value, ok := dc.mutation.EndSuffix(); ok {
		_spec.SetField(decision.FieldEndSuffix, field.TypeInt64, value)
		_node.EndSuffix = value
	}
	if value, ok := dc.mutation.IPSize(); ok {
		_spec.SetField(decision.FieldIPSize, field.TypeInt64, value)
		_node.IPSize = value
	}
	if value, ok := dc.mutation.Scope(); ok {
		_spec.SetField(decision.FieldScope, field.TypeString, value)
		_node.Scope = value
	}
	if value, ok := dc.mutation.Value(); ok {
		_spec.SetField(decision.FieldValue, field.TypeString, value)
		_node.Value = value
	}
	if value, ok := dc.mutation.Origin(); ok {
		_spec.SetField(decision.FieldOrigin, field.TypeString, value)
		_node.Origin = value
	}
	if value, ok := dc.mutation.Simulated(); ok {
		_spec.SetField(decision.FieldSimulated, field.TypeBool, value)
		_node.Simulated = value
	}
	if value, ok := dc.mutation.UUID(); ok {
		_spec.SetField(decision.FieldUUID, field.TypeString, value)
		_node.UUID = value
	}
	if nodes := dc.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   decision.OwnerTable,
			Columns: []string{decision.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.AlertDecisions = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Decision.Create().
//		SetCreatedAt(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.DecisionUpsert) {
//			SetCreatedAt(v+v).
//		}).
//		Exec(ctx)
func (dc *DecisionCreate) OnConflict(opts ...sql.ConflictOption) *DecisionUpsertOne {
	dc.conflict = opts
	return &DecisionUpsertOne{
		create: dc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Decision.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (dc *DecisionCreate) OnConflictColumns(columns ...string) *DecisionUpsertOne {
	dc.conflict = append(dc.conflict, sql.ConflictColumns(columns...))
	return &DecisionUpsertOne{
		create: dc,
	}
}

type (
	// DecisionUpsertOne is the builder for "upsert"-ing
	//  one Decision node.
	DecisionUpsertOne struct {
		create *DecisionCreate
	}

	// DecisionUpsert is the "OnConflict" setter.
	DecisionUpsert struct {
		*sql.UpdateSet
	}
)

// SetUpdatedAt sets the "updated_at" field.
func (u *DecisionUpsert) SetUpdatedAt(v time.Time) *DecisionUpsert {
	u.Set(decision.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *DecisionUpsert) UpdateUpdatedAt() *DecisionUpsert {
	u.SetExcluded(decision.FieldUpdatedAt)
	return u
}

// SetUntil sets the "until" field.
func (u *DecisionUpsert) SetUntil(v time.Time) *DecisionUpsert {
	u.Set(decision.FieldUntil, v)
	return u
}

// UpdateUntil sets the "until" field to the value that was provided on create.
func (u *DecisionUpsert) UpdateUntil() *DecisionUpsert {
	u.SetExcluded(decision.FieldUntil)
	return u
}

// ClearUntil clears the value of the "until" field.
func (u *DecisionUpsert) ClearUntil() *DecisionUpsert {
	u.SetNull(decision.FieldUntil)
	return u
}

// SetAlertDecisions sets the "alert_decisions" field.
func (u *DecisionUpsert) SetAlertDecisions(v int) *DecisionUpsert {
	u.Set(decision.FieldAlertDecisions, v)
	return u
}

// UpdateAlertDecisions sets the "alert_decisions" field to the value that was provided on create.
func (u *DecisionUpsert) UpdateAlertDecisions() *DecisionUpsert {
	u.SetExcluded(decision.FieldAlertDecisions)
	return u
}

// ClearAlertDecisions clears the value of the "alert_decisions" field.
func (u *DecisionUpsert) ClearAlertDecisions() *DecisionUpsert {
	u.SetNull(decision.FieldAlertDecisions)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create.
// Using this option is equivalent to using:
//
//	client.Decision.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *DecisionUpsertOne) UpdateNewValues() *DecisionUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.CreatedAt(); exists {
			s.SetIgnore(decision.FieldCreatedAt)
		}
		if _, exists := u.create.mutation.Scenario(); exists {
			s.SetIgnore(decision.FieldScenario)
		}
		if _, exists := u.create.mutation.GetType(); exists {
			s.SetIgnore(decision.FieldType)
		}
		if _, exists := u.create.mutation.StartIP(); exists {
			s.SetIgnore(decision.FieldStartIP)
		}
		if _, exists := u.create.mutation.EndIP(); exists {
			s.SetIgnore(decision.FieldEndIP)
		}
		if _, exists := u.create.mutation.StartSuffix(); exists {
			s.SetIgnore(decision.FieldStartSuffix)
		}
		if _, exists := u.create.mutation.EndSuffix(); exists {
			s.SetIgnore(decision.FieldEndSuffix)
		}
		if _, exists := u.create.mutation.IPSize(); exists {
			s.SetIgnore(decision.FieldIPSize)
		}
		if _, exists := u.create.mutation.Scope(); exists {
			s.SetIgnore(decision.FieldScope)
		}
		if _, exists := u.create.mutation.Value(); exists {
			s.SetIgnore(decision.FieldValue)
		}
		if _, exists := u.create.mutation.Origin(); exists {
			s.SetIgnore(decision.FieldOrigin)
		}
		if _, exists := u.create.mutation.Simulated(); exists {
			s.SetIgnore(decision.FieldSimulated)
		}
		if _, exists := u.create.mutation.UUID(); exists {
			s.SetIgnore(decision.FieldUUID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Decision.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *DecisionUpsertOne) Ignore() *DecisionUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *DecisionUpsertOne) DoNothing() *DecisionUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the DecisionCreate.OnConflict
// documentation for more info.
func (u *DecisionUpsertOne) Update(set func(*DecisionUpsert)) *DecisionUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&DecisionUpsert{UpdateSet: update})
	}))
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *DecisionUpsertOne) SetUpdatedAt(v time.Time) *DecisionUpsertOne {
	return u.Update(func(s *DecisionUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *DecisionUpsertOne) UpdateUpdatedAt() *DecisionUpsertOne {
	return u.Update(func(s *DecisionUpsert) {
		s.UpdateUpdatedAt()
	})
}

// SetUntil sets the "until" field.
func (u *DecisionUpsertOne) SetUntil(v time.Time) *DecisionUpsertOne {
	return u.Update(func(s *DecisionUpsert) {
		s.SetUntil(v)
	})
}

// UpdateUntil sets the "until" field to the value that was provided on create.
func (u *DecisionUpsertOne) UpdateUntil() *DecisionUpsertOne {
	return u.Update(func(s *DecisionUpsert) {
		s.UpdateUntil()
	})
}

// ClearUntil clears the value of the "until" field.
func (u *DecisionUpsertOne) ClearUntil() *DecisionUpsertOne {
	return u.Update(func(s *DecisionUpsert) {
		s.ClearUntil()
	})
}

// SetAlertDecisions sets the "alert_decisions" field.
func (u *DecisionUpsertOne) SetAlertDecisions(v int) *DecisionUpsertOne {
	return u.Update(func(s *DecisionUpsert) {
		s.SetAlertDecisions(v)
	})
}

// UpdateAlertDecisions sets the "alert_decisions" field to the value that was provided on create.
func (u *DecisionUpsertOne) UpdateAlertDecisions() *DecisionUpsertOne {
	return u.Update(func(s *DecisionUpsert) {
		s.UpdateAlertDecisions()
	})
}

// ClearAlertDecisions clears the value of the "alert_decisions" field.
func (u *DecisionUpsertOne) ClearAlertDecisions() *DecisionUpsertOne {
	return u.Update(func(s *DecisionUpsert) {
		s.ClearAlertDecisions()
	})
}

// Exec executes the query.
func (u *DecisionUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for DecisionCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *DecisionUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *DecisionUpsertOne) ID(ctx context.Context) (id int, err error) {
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *DecisionUpsertOne) IDX(ctx context.Context) int {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// DecisionCreateBulk is the builder for creating many Decision entities in bulk.
type DecisionCreateBulk struct {
	config
	err      error
	builders []*DecisionCreate
	conflict []sql.ConflictOption
}

// Save creates the Decision entities in the database.
func (dcb *DecisionCreateBulk) Save(ctx context.Context) ([]*Decision, error) {
	if dcb.err != nil {
		return nil, dcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(dcb.builders))
	nodes := make([]*Decision, len(dcb.builders))
	mutators := make([]Mutator, len(dcb.builders))
	for i := range dcb.builders {
		func(i int, root context.Context) {
			builder := dcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*DecisionMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, dcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = dcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, dcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, dcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (dcb *DecisionCreateBulk) SaveX(ctx context.Context) []*Decision {
	v, err := dcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (dcb *DecisionCreateBulk) Exec(ctx context.Context) error {
	_, err := dcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (dcb *DecisionCreateBulk) ExecX(ctx context.Context) {
	if err := dcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Decision.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.DecisionUpsert) {
//			SetCreatedAt(v+v).
//		}).
//		Exec(ctx)
func (dcb *DecisionCreateBulk) OnConflict(opts ...sql.ConflictOption) *DecisionUpsertBulk {
	dcb.conflict = opts
	return &DecisionUpsertBulk{
		create: dcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Decision.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (dcb *DecisionCreateBulk) OnConflictColumns(columns ...string) *DecisionUpsertBulk {
	dcb.conflict = append(dcb.conflict, sql.ConflictColumns(columns...))
	return &DecisionUpsertBulk{
		create: dcb,
	}
}

// DecisionUpsertBulk is the builder for "upsert"-ing
// a bulk of Decision nodes.
type DecisionUpsertBulk struct {
	create *DecisionCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Decision.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *DecisionUpsertBulk) UpdateNewValues() *DecisionUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.CreatedAt(); exists {
				s.SetIgnore(decision.FieldCreatedAt)
			}
			if _, exists := b.mutation.Scenario(); exists {
				s.SetIgnore(decision.FieldScenario)
			}
			if _, exists := b.mutation.GetType(); exists {
				s.SetIgnore(decision.FieldType)
			}
			if _, exists := b.mutation.StartIP(); exists {
				s.SetIgnore(decision.FieldStartIP)
			}
			if _, exists := b.mutation.EndIP(); exists {
				s.SetIgnore(decision.FieldEndIP)
			}
			if _, exists := b.mutation.StartSuffix(); exists {
				s.SetIgnore(decision.FieldStartSuffix)
			}
			if _, exists := b.mutation.EndSuffix(); exists {
				s.SetIgnore(decision.FieldEndSuffix)
			}
			if _, exists := b.mutation.IPSize(); exists {
				s.SetIgnore(decision.FieldIPSize)
			}
			if _, exists := b.mutation.Scope(); exists {
				s.SetIgnore(decision.FieldScope)
			}
			if _, exists := b.mutation.Value(); exists {
				s.SetIgnore(decision.FieldValue)
			}
			if _, exists := b.mutation.Origin(); exists {
				s.SetIgnore(decision.FieldOrigin)
			}
			if _, exists := b.mutation.Simulated(); exists {
				s.SetIgnore(decision.FieldSimulated)
			}
			if _, exists := b.mutation.UUID(); exists {
				s.SetIgnore(decision.FieldUUID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Decision.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *DecisionUpsertBulk) Ignore() *DecisionUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *DecisionUpsertBulk) DoNothing() *DecisionUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the DecisionCreateBulk.OnConflict
// documentation for more info.
func (u *DecisionUpsertBulk) Update(set func(*DecisionUpsert)) *DecisionUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&DecisionUpsert{UpdateSet: update})
	}))
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *DecisionUpsertBulk) SetUpdatedAt(v time.Time) *DecisionUpsertBulk {
	return u.Update(func(s *DecisionUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *DecisionUpsertBulk) UpdateUpdatedAt() *DecisionUpsertBulk {
	return u.Update(func(s *DecisionUpsert) {
		s.UpdateUpdatedAt()
	})
}

// SetUntil sets the "until" field.
func (u *DecisionUpsertBulk) SetUntil(v time.Time) *DecisionUpsertBulk {
	return u.Update(func(s *DecisionUpsert) {
		s.SetUntil(v)
	})
}

// UpdateUntil sets the "until" field to the value that was provided on create.
func (u *DecisionUpsertBulk) UpdateUntil() *DecisionUpsertBulk {
	return u.Update(func(s *DecisionUpsert) {
		s.UpdateUntil()
	})
}

// ClearUntil clears the value of the "until" field.
func (u *DecisionUpsertBulk) ClearUntil() *DecisionUpsertBulk {
	return u.Update(func(s *DecisionUpsert) {
		s.ClearUntil()
	})
}

// SetAlertDecisions sets the "alert_decisions" field.
func (u *DecisionUpsertBulk) SetAlertDecisions(v int) *DecisionUpsertBulk {
	return u.Update(func(s *DecisionUpsert) {
		s.SetAlertDecisions(v)
	})
}

// UpdateAlertDecisions sets the "alert_decisions" field to the value that was provided on create.
func (u *DecisionUpsertBulk) UpdateAlertDecisions() *DecisionUpsertBulk {
	return u.Update(func(s *DecisionUpsert) {
		s.UpdateAlertDecisions()
	})
}

// ClearAlertDecisions clears the value of the "alert_decisions" field.
func (u *DecisionUpsertBulk) ClearAlertDecisions() *DecisionUpsertBulk {
	return u.Update(func(s *DecisionUpsert) {
		s.ClearAlertDecisions()
	})
}

// Exec executes the query.
func (u *DecisionUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the DecisionCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for DecisionCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *DecisionUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
