// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlist"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlistitem"
)

// AllowListItemCreate is the builder for creating a AllowListItem entity.
type AllowListItemCreate struct {
	config
	mutation *AllowListItemMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetCreatedAt sets the "created_at" field.
func (alic *AllowListItemCreate) SetCreatedAt(t time.Time) *AllowListItemCreate {
	alic.mutation.SetCreatedAt(t)
	return alic
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (alic *AllowListItemCreate) SetNillableCreatedAt(t *time.Time) *AllowListItemCreate {
	if t != nil {
		alic.SetCreatedAt(*t)
	}
	return alic
}

// SetUpdatedAt sets the "updated_at" field.
func (alic *AllowListItemCreate) SetUpdatedAt(t time.Time) *AllowListItemCreate {
	alic.mutation.SetUpdatedAt(t)
	return alic
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (alic *AllowListItemCreate) SetNillableUpdatedAt(t *time.Time) *AllowListItemCreate {
	if t != nil {
		alic.SetUpdatedAt(*t)
	}
	return alic
}

// SetExpiresAt sets the "expires_at" field.
func (alic *AllowListItemCreate) SetExpiresAt(t time.Time) *AllowListItemCreate {
	alic.mutation.SetExpiresAt(t)
	return alic
}

// SetNillableExpiresAt sets the "expires_at" field if the given value is not nil.
func (alic *AllowListItemCreate) SetNillableExpiresAt(t *time.Time) *AllowListItemCreate {
	if t != nil {
		alic.SetExpiresAt(*t)
	}
	return alic
}

// SetComment sets the "comment" field.
func (alic *AllowListItemCreate) SetComment(s string) *AllowListItemCreate {
	alic.mutation.SetComment(s)
	return alic
}

// SetNillableComment sets the "comment" field if the given value is not nil.
func (alic *AllowListItemCreate) SetNillableComment(s *string) *AllowListItemCreate {
	if s != nil {
		alic.SetComment(*s)
	}
	return alic
}

// SetValue sets the "value" field.
func (alic *AllowListItemCreate) SetValue(s string) *AllowListItemCreate {
	alic.mutation.SetValue(s)
	return alic
}

// SetStartIP sets the "start_ip" field.
func (alic *AllowListItemCreate) SetStartIP(i int64) *AllowListItemCreate {
	alic.mutation.SetStartIP(i)
	return alic
}

// SetNillableStartIP sets the "start_ip" field if the given value is not nil.
func (alic *AllowListItemCreate) SetNillableStartIP(i *int64) *AllowListItemCreate {
	if i != nil {
		alic.SetStartIP(*i)
	}
	return alic
}

// SetEndIP sets the "end_ip" field.
func (alic *AllowListItemCreate) SetEndIP(i int64) *AllowListItemCreate {
	alic.mutation.SetEndIP(i)
	return alic
}

// SetNillableEndIP sets the "end_ip" field if the given value is not nil.
func (alic *AllowListItemCreate) SetNillableEndIP(i *int64) *AllowListItemCreate {
	if i != nil {
		alic.SetEndIP(*i)
	}
	return alic
}

// SetStartSuffix sets the "start_suffix" field.
func (alic *AllowListItemCreate) SetStartSuffix(i int64) *AllowListItemCreate {
	alic.mutation.SetStartSuffix(i)
	return alic
}

// SetNillableStartSuffix sets the "start_suffix" field if the given value is not nil.
func (alic *AllowListItemCreate) SetNillableStartSuffix(i *int64) *AllowListItemCreate {
	if i != nil {
		alic.SetStartSuffix(*i)
	}
	return alic
}

// SetEndSuffix sets the "end_suffix" field.
func (alic *AllowListItemCreate) SetEndSuffix(i int64) *AllowListItemCreate {
	alic.mutation.SetEndSuffix(i)
	return alic
}

// SetNillableEndSuffix sets the "end_suffix" field if the given value is not nil.
func (alic *AllowListItemCreate) SetNillableEndSuffix(i *int64) *AllowListItemCreate {
	if i != nil {
		alic.SetEndSuffix(*i)
	}
	return alic
}

// SetIPSize sets the "ip_size" field.
func (alic *AllowListItemCreate) SetIPSize(i int64) *AllowListItemCreate {
	alic.mutation.SetIPSize(i)
	return alic
}

// SetNillableIPSize sets the "ip_size" field if the given value is not nil.
func (alic *AllowListItemCreate) SetNillableIPSize(i *int64) *AllowListItemCreate {
	if i != nil {
		alic.SetIPSize(*i)
	}
	return alic
}

// AddAllowlistIDs adds the "allowlist" edge to the AllowList entity by IDs.
func (alic *AllowListItemCreate) AddAllowlistIDs(ids ...int) *AllowListItemCreate {
	alic.mutation.AddAllowlistIDs(ids...)
	return alic
}

// AddAllowlist adds the "allowlist" edges to the AllowList entity.
func (alic *AllowListItemCreate) AddAllowlist(a ...*AllowList) *AllowListItemCreate {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return alic.AddAllowlistIDs(ids...)
}

// Mutation returns the AllowListItemMutation object of the builder.
func (alic *AllowListItemCreate) Mutation() *AllowListItemMutation {
	return alic.mutation
}

// Save creates the AllowListItem in the database.
func (alic *AllowListItemCreate) Save(ctx context.Context) (*AllowListItem, error) {
	alic.defaults()
	return withHooks(ctx, alic.sqlSave, alic.mutation, alic.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (alic *AllowListItemCreate) SaveX(ctx context.Context) *AllowListItem {
	v, err := alic.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (alic *AllowListItemCreate) Exec(ctx context.Context) error {
	_, err := alic.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (alic *AllowListItemCreate) ExecX(ctx context.Context) {
	if err := alic.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (alic *AllowListItemCreate) defaults() {
	if _, ok := alic.mutation.CreatedAt(); !ok {
		v := allowlistitem.DefaultCreatedAt()
		alic.mutation.SetCreatedAt(v)
	}
	if _, ok := alic.mutation.UpdatedAt(); !ok {
		v := allowlistitem.DefaultUpdatedAt()
		alic.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (alic *AllowListItemCreate) check() error {
	if _, ok := alic.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`ent: missing required field "AllowListItem.created_at"`)}
	}
	if _, ok := alic.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`ent: missing required field "AllowListItem.updated_at"`)}
	}
	if _, ok := alic.mutation.Value(); !ok {
		return &ValidationError{Name: "value", err: errors.New(`ent: missing required field "AllowListItem.value"`)}
	}
	return nil
}

func (alic *AllowListItemCreate) sqlSave(ctx context.Context) (*AllowListItem, error) {
	if err := alic.check(); err != nil {
		return nil, err
	}
	_node, _spec := alic.createSpec()
	if err := sqlgraph.CreateNode(ctx, alic.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	alic.mutation.id = &_node.ID
	alic.mutation.done = true
	return _node, nil
}

func (alic *AllowListItemCreate) createSpec() (*AllowListItem, *sqlgraph.CreateSpec) {
	var (
		_node = &AllowListItem{config: alic.config}
		_spec = sqlgraph.NewCreateSpec(allowlistitem.Table, sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt))
	)
	_spec.OnConflict = alic.conflict
	if value, ok := alic.mutation.CreatedAt(); ok {
		_spec.SetField(allowlistitem.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := alic.mutation.UpdatedAt(); ok {
		_spec.SetField(allowlistitem.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if value, ok := alic.mutation.ExpiresAt(); ok {
		_spec.SetField(allowlistitem.FieldExpiresAt, field.TypeTime, value)
		_node.ExpiresAt = value
	}
	if value, ok := alic.mutation.Comment(); ok {
		_spec.SetField(allowlistitem.FieldComment, field.TypeString, value)
		_node.Comment = value
	}
	if value, ok := alic.mutation.Value(); ok {
		_spec.SetField(allowlistitem.FieldValue, field.TypeString, value)
		_node.Value = value
	}
	if value, ok := alic.mutation.StartIP(); ok {
		_spec.SetField(allowlistitem.FieldStartIP, field.TypeInt64, value)
		_node.StartIP = value
	}
	if value, ok := alic.mutation.EndIP(); ok {
		_spec.SetField(allowlistitem.FieldEndIP, field.TypeInt64, value)
		_node.EndIP = value
	}
	if value, ok := alic.mutation.StartSuffix(); ok {
		_spec.SetField(allowlistitem.FieldStartSuffix, field.TypeInt64, value)
		_node.StartSuffix = value
	}
	if value, ok := alic.mutation.EndSuffix(); ok {
		_spec.SetField(allowlistitem.FieldEndSuffix, field.TypeInt64, value)
		_node.EndSuffix = value
	}
	if value, ok := alic.mutation.IPSize(); ok {
		_spec.SetField(allowlistitem.FieldIPSize, field.TypeInt64, value)
		_node.IPSize = value
	}
	if nodes := alic.mutation.AllowlistIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   allowlistitem.AllowlistTable,
			Columns: allowlistitem.AllowlistPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlist.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.AllowListItem.Create().
//		SetCreatedAt(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AllowListItemUpsert) {
//			SetCreatedAt(v+v).
//		}).
//		Exec(ctx)
func (alic *AllowListItemCreate) OnConflict(opts ...sql.ConflictOption) *AllowListItemUpsertOne {
	alic.conflict = opts
	return &AllowListItemUpsertOne{
		create: alic,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.AllowListItem.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (alic *AllowListItemCreate) OnConflictColumns(columns ...string) *AllowListItemUpsertOne {
	alic.conflict = append(alic.conflict, sql.ConflictColumns(columns...))
	return &AllowListItemUpsertOne{
		create: alic,
	}
}

type (
	// AllowListItemUpsertOne is the builder for "upsert"-ing
	//  one AllowListItem node.
	AllowListItemUpsertOne struct {
		create *AllowListItemCreate
	}

	// AllowListItemUpsert is the "OnConflict" setter.
	AllowListItemUpsert struct {
		*sql.UpdateSet
	}
)

// SetUpdatedAt sets the "updated_at" field.
func (u *AllowListItemUpsert) SetUpdatedAt(v time.Time) *AllowListItemUpsert {
	u.Set(allowlistitem.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AllowListItemUpsert) UpdateUpdatedAt() *AllowListItemUpsert {
	u.SetExcluded(allowlistitem.FieldUpdatedAt)
	return u
}

// SetExpiresAt sets the "expires_at" field.
func (u *AllowListItemUpsert) SetExpiresAt(v time.Time) *AllowListItemUpsert {
	u.Set(allowlistitem.FieldExpiresAt, v)
	return u
}

// UpdateExpiresAt sets the "expires_at" field to the value that was provided on create.
func (u *AllowListItemUpsert) UpdateExpiresAt() *AllowListItemUpsert {
	u.SetExcluded(allowlistitem.FieldExpiresAt)
	return u
}

// ClearExpiresAt clears the value of the "expires_at" field.
func (u *AllowListItemUpsert) ClearExpiresAt() *AllowListItemUpsert {
	u.SetNull(allowlistitem.FieldExpiresAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create.
// Using this option is equivalent to using:
//
//	client.AllowListItem.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *AllowListItemUpsertOne) UpdateNewValues() *AllowListItemUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.CreatedAt(); exists {
			s.SetIgnore(allowlistitem.FieldCreatedAt)
		}
		if _, exists := u.create.mutation.Comment(); exists {
			s.SetIgnore(allowlistitem.FieldComment)
		}
		if _, exists := u.create.mutation.Value(); exists {
			s.SetIgnore(allowlistitem.FieldValue)
		}
		if _, exists := u.create.mutation.StartIP(); exists {
			s.SetIgnore(allowlistitem.FieldStartIP)
		}
		if _, exists := u.create.mutation.EndIP(); exists {
			s.SetIgnore(allowlistitem.FieldEndIP)
		}
		if _, exists := u.create.mutation.StartSuffix(); exists {
			s.SetIgnore(allowlistitem.FieldStartSuffix)
		}
		if _, exists := u.create.mutation.EndSuffix(); exists {
			s.SetIgnore(allowlistitem.FieldEndSuffix)
		}
		if _, exists := u.create.mutation.IPSize(); exists {
			s.SetIgnore(allowlistitem.FieldIPSize)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.AllowListItem.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *AllowListItemUpsertOne) Ignore() *AllowListItemUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AllowListItemUpsertOne) DoNothing() *AllowListItemUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AllowListItemCreate.OnConflict
// documentation for more info.
func (u *AllowListItemUpsertOne) Update(set func(*AllowListItemUpsert)) *AllowListItemUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AllowListItemUpsert{UpdateSet: update})
	}))
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AllowListItemUpsertOne) SetUpdatedAt(v time.Time) *AllowListItemUpsertOne {
	return u.Update(func(s *AllowListItemUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AllowListItemUpsertOne) UpdateUpdatedAt() *AllowListItemUpsertOne {
	return u.Update(func(s *AllowListItemUpsert) {
		s.UpdateUpdatedAt()
	})
}

// SetExpiresAt sets the "expires_at" field.
func (u *AllowListItemUpsertOne) SetExpiresAt(v time.Time) *AllowListItemUpsertOne {
	return u.Update(func(s *AllowListItemUpsert) {
		s.SetExpiresAt(v)
	})
}

// UpdateExpiresAt sets the "expires_at" field to the value that was provided on create.
func (u *AllowListItemUpsertOne) UpdateExpiresAt() *AllowListItemUpsertOne {
	return u.Update(func(s *AllowListItemUpsert) {
		s.UpdateExpiresAt()
	})
}

// ClearExpiresAt clears the value of the "expires_at" field.
func (u *AllowListItemUpsertOne) ClearExpiresAt() *AllowListItemUpsertOne {
	return u.Update(func(s *AllowListItemUpsert) {
		s.ClearExpiresAt()
	})
}

// Exec executes the query.
func (u *AllowListItemUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for AllowListItemCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AllowListItemUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *AllowListItemUpsertOne) ID(ctx context.Context) (id int, err error) {
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *AllowListItemUpsertOne) IDX(ctx context.Context) int {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// AllowListItemCreateBulk is the builder for creating many AllowListItem entities in bulk.
type AllowListItemCreateBulk struct {
	config
	err      error
	builders []*AllowListItemCreate
	conflict []sql.ConflictOption
}

// Save creates the AllowListItem entities in the database.
func (alicb *AllowListItemCreateBulk) Save(ctx context.Context) ([]*AllowListItem, error) {
	if alicb.err != nil {
		return nil, alicb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(alicb.builders))
	nodes := make([]*AllowListItem, len(alicb.builders))
	mutators := make([]Mutator, len(alicb.builders))
	for i := range alicb.builders {
		func(i int, root context.Context) {
			builder := alicb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*AllowListItemMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, alicb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = alicb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, alicb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, alicb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (alicb *AllowListItemCreateBulk) SaveX(ctx context.Context) []*AllowListItem {
	v, err := alicb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (alicb *AllowListItemCreateBulk) Exec(ctx context.Context) error {
	_, err := alicb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (alicb *AllowListItemCreateBulk) ExecX(ctx context.Context) {
	if err := alicb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.AllowListItem.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AllowListItemUpsert) {
//			SetCreatedAt(v+v).
//		}).
//		Exec(ctx)
func (alicb *AllowListItemCreateBulk) OnConflict(opts ...sql.ConflictOption) *AllowListItemUpsertBulk {
	alicb.conflict = opts
	return &AllowListItemUpsertBulk{
		create: alicb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.AllowListItem.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (alicb *AllowListItemCreateBulk) OnConflictColumns(columns ...string) *AllowListItemUpsertBulk {
	alicb.conflict = append(alicb.conflict, sql.ConflictColumns(columns...))
	return &AllowListItemUpsertBulk{
		create: alicb,
	}
}

// AllowListItemUpsertBulk is the builder for "upsert"-ing
// a bulk of AllowListItem nodes.
type AllowListItemUpsertBulk struct {
	create *AllowListItemCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.AllowListItem.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *AllowListItemUpsertBulk) UpdateNewValues() *AllowListItemUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.CreatedAt(); exists {
				s.SetIgnore(allowlistitem.FieldCreatedAt)
			}
			if _, exists := b.mutation.Comment(); exists {
				s.SetIgnore(allowlistitem.FieldComment)
			}
			if _, exists := b.mutation.Value(); exists {
				s.SetIgnore(allowlistitem.FieldValue)
			}
			if _, exists := b.mutation.StartIP(); exists {
				s.SetIgnore(allowlistitem.FieldStartIP)
			}
			if _, exists := b.mutation.EndIP(); exists {
				s.SetIgnore(allowlistitem.FieldEndIP)
			}
			if _, exists := b.mutation.StartSuffix(); exists {
				s.SetIgnore(allowlistitem.FieldStartSuffix)
			}
			if _, exists := b.mutation.EndSuffix(); exists {
				s.SetIgnore(allowlistitem.FieldEndSuffix)
			}
			if _, exists := b.mutation.IPSize(); exists {
				s.SetIgnore(allowlistitem.FieldIPSize)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.AllowListItem.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *AllowListItemUpsertBulk) Ignore() *AllowListItemUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AllowListItemUpsertBulk) DoNothing() *AllowListItemUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AllowListItemCreateBulk.OnConflict
// documentation for more info.
func (u *AllowListItemUpsertBulk) Update(set func(*AllowListItemUpsert)) *AllowListItemUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AllowListItemUpsert{UpdateSet: update})
	}))
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AllowListItemUpsertBulk) SetUpdatedAt(v time.Time) *AllowListItemUpsertBulk {
	return u.Update(func(s *AllowListItemUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AllowListItemUpsertBulk) UpdateUpdatedAt() *AllowListItemUpsertBulk {
	return u.Update(func(s *AllowListItemUpsert) {
		s.UpdateUpdatedAt()
	})
}

// SetExpiresAt sets the "expires_at" field.
func (u *AllowListItemUpsertBulk) SetExpiresAt(v time.Time) *AllowListItemUpsertBulk {
	return u.Update(func(s *AllowListItemUpsert) {
		s.SetExpiresAt(v)
	})
}

// UpdateExpiresAt sets the "expires_at" field to the value that was provided on create.
func (u *AllowListItemUpsertBulk) UpdateExpiresAt() *AllowListItemUpsertBulk {
	return u.Update(func(s *AllowListItemUpsert) {
		s.UpdateExpiresAt()
	})
}

// ClearExpiresAt clears the value of the "expires_at" field.
func (u *AllowListItemUpsertBulk) ClearExpiresAt() *AllowListItemUpsertBulk {
	return u.Update(func(s *AllowListItemUpsert) {
		s.ClearExpiresAt()
	})
}

// Exec executes the query.
func (u *AllowListItemUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the AllowListItemCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for AllowListItemCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AllowListItemUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
