// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/meta"
)

// MetaCreate is the builder for creating a Meta entity.
type MetaCreate struct {
	config
	mutation *MetaMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetCreatedAt sets the "created_at" field.
func (mc *MetaCreate) SetCreatedAt(t time.Time) *MetaCreate {
	mc.mutation.SetCreatedAt(t)
	return mc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (mc *MetaCreate) SetNillableCreatedAt(t *time.Time) *MetaCreate {
	if t != nil {
		mc.SetCreatedAt(*t)
	}
	return mc
}

// SetUpdatedAt sets the "updated_at" field.
func (mc *MetaCreate) SetUpdatedAt(t time.Time) *MetaCreate {
	mc.mutation.SetUpdatedAt(t)
	return mc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (mc *MetaCreate) SetNillableUpdatedAt(t *time.Time) *MetaCreate {
	if t != nil {
		mc.SetUpdatedAt(*t)
	}
	return mc
}

// SetKey sets the "key" field.
func (mc *MetaCreate) SetKey(s string) *MetaCreate {
	mc.mutation.SetKey(s)
	return mc
}

// SetValue sets the "value" field.
func (mc *MetaCreate) SetValue(s string) *MetaCreate {
	mc.mutation.SetValue(s)
	return mc
}

// SetAlertMetas sets the "alert_metas" field.
func (mc *MetaCreate) SetAlertMetas(i int) *MetaCreate {
	mc.mutation.SetAlertMetas(i)
	return mc
}

// SetNillableAlertMetas sets the "alert_metas" field if the given value is not nil.
func (mc *MetaCreate) SetNillableAlertMetas(i *int) *MetaCreate {
	if i != nil {
		mc.SetAlertMetas(*i)
	}
	return mc
}

// SetOwnerID sets the "owner" edge to the Alert entity by ID.
func (mc *MetaCreate) SetOwnerID(id int) *MetaCreate {
	mc.mutation.SetOwnerID(id)
	return mc
}

// SetNillableOwnerID sets the "owner" edge to the Alert entity by ID if the given value is not nil.
func (mc *MetaCreate) SetNillableOwnerID(id *int) *MetaCreate {
	if id != nil {
		mc = mc.SetOwnerID(*id)
	}
	return mc
}

// SetOwner sets the "owner" edge to the Alert entity.
func (mc *MetaCreate) SetOwner(a *Alert) *MetaCreate {
	return mc.SetOwnerID(a.ID)
}

// Mutation returns the MetaMutation object of the builder.
func (mc *MetaCreate) Mutation() *MetaMutation {
	return mc.mutation
}

// Save creates the Meta in the database.
func (mc *MetaCreate) Save(ctx context.Context) (*Meta, error) {
	mc.defaults()
	return withHooks(ctx, mc.sqlSave, mc.mutation, mc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (mc *MetaCreate) SaveX(ctx context.Context) *Meta {
	v, err := mc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mc *MetaCreate) Exec(ctx context.Context) error {
	_, err := mc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mc *MetaCreate) ExecX(ctx context.Context) {
	if err := mc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (mc *MetaCreate) defaults() {
	if _, ok := mc.mutation.CreatedAt(); !ok {
		v := meta.DefaultCreatedAt()
		mc.mutation.SetCreatedAt(v)
	}
	if _, ok := mc.mutation.UpdatedAt(); !ok {
		v := meta.DefaultUpdatedAt()
		mc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mc *MetaCreate) check() error {
	if _, ok := mc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`ent: missing required field "Meta.created_at"`)}
	}
	if _, ok := mc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`ent: missing required field "Meta.updated_at"`)}
	}
	if _, ok := mc.mutation.Key(); !ok {
		return &ValidationError{Name: "key", err: errors.New(`ent: missing required field "Meta.key"`)}
	}
	if _, ok := mc.mutation.Value(); !ok {
		return &ValidationError{Name: "value", err: errors.New(`ent: missing required field "Meta.value"`)}
	}
	if v, ok := mc.mutation.Value(); ok {
		if err := meta.ValueValidator(v); err != nil {
			return &ValidationError{Name: "value", err: fmt.Errorf(`ent: validator failed for field "Meta.value": %w`, err)}
		}
	}
	return nil
}

func (mc *MetaCreate) sqlSave(ctx context.Context) (*Meta, error) {
	if err := mc.check(); err != nil {
		return nil, err
	}
	_node, _spec := mc.createSpec()
	if err := sqlgraph.CreateNode(ctx, mc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	mc.mutation.id = &_node.ID
	mc.mutation.done = true
	return _node, nil
}

func (mc *MetaCreate) createSpec() (*Meta, *sqlgraph.CreateSpec) {
	var (
		_node = &Meta{config: mc.config}
		_spec = sqlgraph.NewCreateSpec(meta.Table, sqlgraph.NewFieldSpec(meta.FieldID, field.TypeInt))
	)
	_spec.OnConflict = mc.conflict
	if value, ok := mc.mutation.CreatedAt(); ok {
		_spec.SetField(meta.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := mc.mutation.UpdatedAt(); ok {
		_spec.SetField(meta.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if value, ok := mc.mutation.Key(); ok {
		_spec.SetField(meta.FieldKey, field.TypeString, value)
		_node.Key = value
	}
	if value, ok := mc.mutation.Value(); ok {
		_spec.SetField(meta.FieldValue, field.TypeString, value)
		_node.Value = value
	}
	if nodes := mc.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   meta.OwnerTable,
			Columns: []string{meta.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.AlertMetas = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Meta.Create().
//		SetCreatedAt(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.MetaUpsert) {
//			SetCreatedAt(v+v).
//		}).
//		Exec(ctx)
func (mc *MetaCreate) OnConflict(opts ...sql.ConflictOption) *MetaUpsertOne {
	mc.conflict = opts
	return &MetaUpsertOne{
		create: mc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Meta.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (mc *MetaCreate) OnConflictColumns(columns ...string) *MetaUpsertOne {
	mc.conflict = append(mc.conflict, sql.ConflictColumns(columns...))
	return &MetaUpsertOne{
		create: mc,
	}
}

type (
	// MetaUpsertOne is the builder for "upsert"-ing
	//  one Meta node.
	MetaUpsertOne struct {
		create *MetaCreate
	}

	// MetaUpsert is the "OnConflict" setter.
	MetaUpsert struct {
		*sql.UpdateSet
	}
)

// SetUpdatedAt sets the "updated_at" field.
func (u *MetaUpsert) SetUpdatedAt(v time.Time) *MetaUpsert {
	u.Set(meta.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *MetaUpsert) UpdateUpdatedAt() *MetaUpsert {
	u.SetExcluded(meta.FieldUpdatedAt)
	return u
}

// SetAlertMetas sets the "alert_metas" field.
func (u *MetaUpsert) SetAlertMetas(v int) *MetaUpsert {
	u.Set(meta.FieldAlertMetas, v)
	return u
}

// UpdateAlertMetas sets the "alert_metas" field to the value that was provided on create.
func (u *MetaUpsert) UpdateAlertMetas() *MetaUpsert {
	u.SetExcluded(meta.FieldAlertMetas)
	return u
}

// ClearAlertMetas clears the value of the "alert_metas" field.
func (u *MetaUpsert) ClearAlertMetas() *MetaUpsert {
	u.SetNull(meta.FieldAlertMetas)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create.
// Using this option is equivalent to using:
//
//	client.Meta.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *MetaUpsertOne) UpdateNewValues() *MetaUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.CreatedAt(); exists {
			s.SetIgnore(meta.FieldCreatedAt)
		}
		if _, exists := u.create.mutation.Key(); exists {
			s.SetIgnore(meta.FieldKey)
		}
		if _, exists := u.create.mutation.Value(); exists {
			s.SetIgnore(meta.FieldValue)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Meta.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *MetaUpsertOne) Ignore() *MetaUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *MetaUpsertOne) DoNothing() *MetaUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the MetaCreate.OnConflict
// documentation for more info.
func (u *MetaUpsertOne) Update(set func(*MetaUpsert)) *MetaUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&MetaUpsert{UpdateSet: update})
	}))
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *MetaUpsertOne) SetUpdatedAt(v time.Time) *MetaUpsertOne {
	return u.Update(func(s *MetaUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *MetaUpsertOne) UpdateUpdatedAt() *MetaUpsertOne {
	return u.Update(func(s *MetaUpsert) {
		s.UpdateUpdatedAt()
	})
}

// SetAlertMetas sets the "alert_metas" field.
func (u *MetaUpsertOne) SetAlertMetas(v int) *MetaUpsertOne {
	return u.Update(func(s *MetaUpsert) {
		s.SetAlertMetas(v)
	})
}

// UpdateAlertMetas sets the "alert_metas" field to the value that was provided on create.
func (u *MetaUpsertOne) UpdateAlertMetas() *MetaUpsertOne {
	return u.Update(func(s *MetaUpsert) {
		s.UpdateAlertMetas()
	})
}

// ClearAlertMetas clears the value of the "alert_metas" field.
func (u *MetaUpsertOne) ClearAlertMetas() *MetaUpsertOne {
	return u.Update(func(s *MetaUpsert) {
		s.ClearAlertMetas()
	})
}

// Exec executes the query.
func (u *MetaUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for MetaCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *MetaUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *MetaUpsertOne) ID(ctx context.Context) (id int, err error) {
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *MetaUpsertOne) IDX(ctx context.Context) int {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// MetaCreateBulk is the builder for creating many Meta entities in bulk.
type MetaCreateBulk struct {
	config
	err      error
	builders []*MetaCreate
	conflict []sql.ConflictOption
}

// Save creates the Meta entities in the database.
func (mcb *MetaCreateBulk) Save(ctx context.Context) ([]*Meta, error) {
	if mcb.err != nil {
		return nil, mcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(mcb.builders))
	nodes := make([]*Meta, len(mcb.builders))
	mutators := make([]Mutator, len(mcb.builders))
	for i := range mcb.builders {
		func(i int, root context.Context) {
			builder := mcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*MetaMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, mcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = mcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, mcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, mcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (mcb *MetaCreateBulk) SaveX(ctx context.Context) []*Meta {
	v, err := mcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mcb *MetaCreateBulk) Exec(ctx context.Context) error {
	_, err := mcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mcb *MetaCreateBulk) ExecX(ctx context.Context) {
	if err := mcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Meta.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.MetaUpsert) {
//			SetCreatedAt(v+v).
//		}).
//		Exec(ctx)
func (mcb *MetaCreateBulk) OnConflict(opts ...sql.ConflictOption) *MetaUpsertBulk {
	mcb.conflict = opts
	return &MetaUpsertBulk{
		create: mcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Meta.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (mcb *MetaCreateBulk) OnConflictColumns(columns ...string) *MetaUpsertBulk {
	mcb.conflict = append(mcb.conflict, sql.ConflictColumns(columns...))
	return &MetaUpsertBulk{
		create: mcb,
	}
}

// MetaUpsertBulk is the builder for "upsert"-ing
// a bulk of Meta nodes.
type MetaUpsertBulk struct {
	create *MetaCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Meta.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *MetaUpsertBulk) UpdateNewValues() *MetaUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.CreatedAt(); exists {
				s.SetIgnore(meta.FieldCreatedAt)
			}
			if _, exists := b.mutation.Key(); exists {
				s.SetIgnore(meta.FieldKey)
			}
			if _, exists := b.mutation.Value(); exists {
				s.SetIgnore(meta.FieldValue)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Meta.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *MetaUpsertBulk) Ignore() *MetaUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *MetaUpsertBulk) DoNothing() *MetaUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the MetaCreateBulk.OnConflict
// documentation for more info.
func (u *MetaUpsertBulk) Update(set func(*MetaUpsert)) *MetaUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&MetaUpsert{UpdateSet: update})
	}))
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *MetaUpsertBulk) SetUpdatedAt(v time.Time) *MetaUpsertBulk {
	return u.Update(func(s *MetaUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *MetaUpsertBulk) UpdateUpdatedAt() *MetaUpsertBulk {
	return u.Update(func(s *MetaUpsert) {
		s.UpdateUpdatedAt()
	})
}

// SetAlertMetas sets the "alert_metas" field.
func (u *MetaUpsertBulk) SetAlertMetas(v int) *MetaUpsertBulk {
	return u.Update(func(s *MetaUpsert) {
		s.SetAlertMetas(v)
	})
}

// UpdateAlertMetas sets the "alert_metas" field to the value that was provided on create.
func (u *MetaUpsertBulk) UpdateAlertMetas() *MetaUpsertBulk {
	return u.Update(func(s *MetaUpsert) {
		s.UpdateAlertMetas()
	})
}

// ClearAlertMetas clears the value of the "alert_metas" field.
func (u *MetaUpsertBulk) ClearAlertMetas() *MetaUpsertBulk {
	return u.Update(func(s *MetaUpsert) {
		s.ClearAlertMetas()
	})
}

// Exec executes the query.
func (u *MetaUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the MetaCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for MetaCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *MetaUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
