package tlstool

import (
	"crypto/tls"
	"slices"
	"testing"
)

func TestSecureCipherSuites(t *testing.T) {
	stdlibSecureSuites := tls.CipherSuites()
	for _, suite := range secureCipherSuites() {
		if !slices.ContainsFunc(stdlibSecureSuites, func(s *tls.CipherSuite) bool {
			return s.ID == suite
		}) {
			t.Errorf("CipherSuite with ID=%d is not considered secure by stdlib", suite)
		}
	}
}
