package mock_modserver

import (
	"context"
	"runtime"
	"testing"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modserver"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/testing/testhelpers"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/testing/testlogger"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/entity/agentk"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/entity/agentw"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/entity/runnerc"
)

func IncomingAgentCtx(t *testing.T, rpcAPI *MockAgentRPCAPI) context.Context {
	agentTokenWithType := api.AgentTokenWithType{
		Token: testhelpers.AgentToken,
		Type:  api.AgentTypeKubernetes,
	}
	rpcAPI.EXPECT().
		AgentTokenWithType().
		Return(agentTokenWithType).
		AnyTimes()
	rpcAPI.EXPECT().
		Log().
		Return(testlogger.New(t)).
		AnyTimes()
	ctx, cancel := context.WithCancel(context.Background())
	t.Cleanup(cancel)
	ctx = modserver.InjectAgentRPCAPI(ctx, rpcAPI)

	return ctx
}

func AgentkMeta() *agentk.Meta {
	return &agentk.Meta{
		Version:      "v17.1.0",
		GitRef:       "0123456789abcdef0123456789abcdef00000000",
		PodNamespace: "ns1",
		PodName:      "n1",
		KubernetesVersion: &agentk.KubernetesVersion{
			Major:    "1",
			Minor:    "30",
			Platform: "linux/amd64",
		},
		ExtraTelemetryData: map[string]string{"some-key": "some-value"},
	}
}

func AgentwMeta() *agentw.Meta {
	return &agentw.Meta{
		Version:            "v1.2.3",
		GitRef:             "0123456789abcdef0123456789abcdef00000000",
		ExtraTelemetryData: map[string]string{"some-key": "some-value"},
		Architecture:       runtime.GOARCH,
	}
}

func RunnerControllerMeta() *runnerc.Meta {
	return &runnerc.Meta{
		Version:            "v1.2.3",
		GitRef:             "0123456789abcdef0123456789abcdef00000000",
		ExtraTelemetryData: map[string]string{"some-key": "some-value"},
		Architecture:       runtime.GOARCH,
	}
}
