package watch_graph //nolint:staticcheck

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestError(t *testing.T) {
	tests := []struct {
		code           ErrorCode
		expectedString string
	}{
		{InvalidArgument, "InvalidArgument: boom"},
		{Unavailable, "Unavailable: boom"},
		{InternalError, "InternalError: boom"},
	}
	for _, test := range tests {
		t.Run(test.code.String(), func(t *testing.T) {
			err := Error{
				Message: "boom",
				Code:    test.code,
			}
			assert.Equal(t, test.expectedString, err.String())
		})
	}
}
